
/*************************************************************************
* FILE:         SWUpdateControlMain.h
* PROJECT:      Gen3 Platform
* SW-COMPONENT: SW Update
*----------------------------------------------------------------------
*
* DESCRIPTION:  Application to restart the system in the recovery download mode when a valid USB device is detected.
*
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
**************************************************************************/

#define PROGRAM_VERSION_MAJOR 1
#define PROGRAM_VERSION_MINOR 2

// Exit code for success
#define SWUPDCTRL_EXIT_SUCCESS 				0
// Exit code for failure
#define SWUPDCTRL_EXIT_FAILURE 				1
// Exit code for failed reset counter comparison
#define SWUPDCTRL_EXIT_FAILURE_RSTCNTR_CMP 	2

void print2stdout(const char *Msg, ...);
void print2errmem(const char *Format, ...);
void hexdump(const unsigned char *Buff, const int Len);
int  ExecCommand(const char *FileName, char *Args[], const bool Wait, const char *UsrName=NULL, const char *GrpName=NULL);
int  ExecCommandAsUser(const char *CmdLine, const bool Wait);

// empty on purpose
