#include "fcswupd_types.hpp"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_UTIL
#include "trcGenProj/Header/fcswupd_types.cpp.trc.h"
#endif

namespace fcswupdate {
const char *sourceTypeToString(tenSourceType enSourceType) {
   switch (enSourceType) {
      case tenSourceType_USB:
         return "USB";
      case tenSourceType_SD:
         return "SD";
      case tenSourceType_OTA:
         return "OTA";
      case tenSourceType_SCOMO:
         return "SCOMO";
      case tenSourceType_SCOMO_INDEX:
         return "SCOMO-INDEX";
      case tenSourceType_other:
      default:
         return "other";
   }
}


tenSourceType enSourceTypeFromString(std::string const &sourceType) {
   if (sourceType=="USB") {
      return tenSourceType_USB;
   } else if (sourceType=="SD") {
      return tenSourceType_SD;
   } else if (sourceType=="OTA") {
      return tenSourceType_OTA;
   }
   
   return tenSourceType_other;
}

const char *enSwUpdateErrorTypeToString(tenSwUpdateError enErrorType) {

   switch (enErrorType) {
      
      case tenSwUpdateError_OK: return "OK";
      case tenSwUpdateError_ECU_TO_BE_UPDATED: return "ECU_TO_BE_UPDATED";
      case tenSwUpdateError_ERROR_DOWNLOAD_MRG_BUSY: return "ERROR_DOWNLOAD_MRG_BUSY";
      case tenSwUpdateError_ERROR_ERG_WRITE: return "ERROR_ERG_WRITE";
      case tenSwUpdateError_ERROR_ERG_READ: return "ERROR_ERG_READ";
      case tenSwUpdateError_ERROR_NOT_ENOUGH_MEMORY: return "ERROR_NOT_ENOUGH_MEMORY";
      case tenSwUpdateError_ERROR_SUMMARY_SCREENS: return "ERROR_SUMMARY_SCREENS";
      case tenSwUpdateError_ERROR_INVALID_SOURCE_SET: return "ERROR_INVALID_SOURCE_SET";
      case tenSwUpdateError_ERROR_UNKNOWN: return "ERROR_UNKNOWN";
      case tenSwUpdateError_ERROR_METAINFO_NOT_FOUND: return "ERROR_METAINFO_NOT_FOUND";
      case tenSwUpdateError_ERROR_METAINFO_READ: return "ERROR_METAINFO_READ";
      case tenSwUpdateError_ERROR_METAINFO_CHECKSUM: return "ERROR_METAINFO_CHECKSUM";
      case tenSwUpdateError_ERROR_METAINFO_PARSE: return "ERROR_METAINFO_PARSE";
      case tenSwUpdateError_ERROR_METAINFO_SECTION_COMMON_NOT_FOUND: return "ERROR_METAINFO_SECTION_COMMON_NOT_FOUND";
      case tenSwUpdateError_ERROR_METAINFO_SECTION_SIGNATURE_NOT_FOUND: return "ERROR_METAINFO_SECTION_SIGNATURE_NOT_FOUND";
      case tenSwUpdateError_ERROR_METAINFO_MANDATORY_TAG_NOT_FOUND: return "ERROR_METAINFO_MANDATORY_TAG_NOT_FOUND";
      case tenSwUpdateError_ERROR_METAINFO_DUPLICATE_SECTION: return "ERROR_METAINFO_DUPLICATE_SECTION";
      case tenSwUpdateError_ERROR_METAINFO_SECTION_NOT_FOUND: return "ERROR_METAINFO_SECTION_NOT_FOUND";
      case tenSwUpdateError_ERROR_METAINFO_UNEXPECTED_SUBSECTION: return "ERROR_METAINFO_UNEXPECTED_SUBSECTION";
      case tenSwUpdateError_ERROR_METAINFO_INVALID_SUBSECTION_PATH: return "ERROR_METAINFO_INVALID_SUBSECTION_PATH";
      case tenSwUpdateError_ERROR_METAINFO_REGION_CONFLICT: return "ERROR_METAINFO_REGION_CONFLICT";
      case tenSwUpdateError_ERROR_METAINFO_VARIANT_CONFLICT: return "ERROR_METAINFO_VARIANT_CONFLICT";
      case tenSwUpdateError_ERROR_METAINFO_INVALID_TRAIN_NAME: return "ERROR_METAINFO_INVALID_TRAIN_NAME";
      case tenSwUpdateError_ERROR_IMAGE_SIZE: return "ERROR_IMAGE_SIZE";
      case tenSwUpdateError_ERROR_IMAGE_CHECKSUM: return "ERROR_IMAGE_CHECKSUM";
      case tenSwUpdateError_ERROR_IMAGE_INVALID_SECTORHEADER: return "ERROR_IMAGE_INVALID_SECTORHEADER";
      case tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_VERSION: return "ERROR_IMAGE_INCOMPATIBLE_VERSION";
      case tenSwUpdateError_ERROR_IMAGE_READ: return "ERROR_IMAGE_READ";
      case tenSwUpdateError_ERROR_IMAGE_FLASHING: return "ERROR_IMAGE_FLASHING";
      case tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_SUPPORTED: return "ERROR_IMAGE_DEVICE_NOT_SUPPORTED";
      case tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_READY: return "ERROR_IMAGE_DEVICE_NOT_READY";
      case tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_SELECTED: return "ERROR_IMAGE_DEVICE_NOT_SELECTED";
      case tenSwUpdateError_ERROR_IMAGE_DEVICE_INCOMPATIBLE_DM_VERSION: return "ERROR_IMAGE_DEVICE_INCOMPATIBLE_DM_VERSION";
      case tenSwUpdateError_ERROR_SIGNATURE_CHECK_FAILED: return "ERROR_SIGNATURE_CHECK_FAILED";
      case tenSwUpdateError_ERROR_CHANGE_BOOTMODE_NOT_POSSIBLE: return "ERROR_CHANGE_BOOTMODE_NOT_POSSIBLE";
      case tenSwUpdateError_ERROR_NO_RELEASE_FOUND: return "ERROR_NO_RELEASE_FOUND";
      case tenSwUpdateError_ERROR_MEDIA_UNAVAILABLE: return "ERROR_MEDIA_UNAVAILABLE";
      case tenSwUpdateError_ERROR_MEDIUM_REMOVED: return "ERROR_MEDIUM_REMOVED";
      case tenSwUpdateError_ERROR_OTP_READ_FAILED: return "ERROR_OTP_READ_FAILED";
      case tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_DOWNGRADE: return "ERROR_IMAGE_INCOMPATIBLE_DOWNGRADE";
      case tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_SAME_VERSION: return "ERROR_IMAGE_INCOMPATIBLE_SAME_VERSION";
      case tenSwUpdateError_ERROR_INCOMPATIBLE_USB_FORMAT: return "ERROR_INCOMPATIBLE_USB_FORMAT";
      default: return "unknown";
   }
}

}

