#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "util/swu_execCommand.h"
#include "util/swu_trace.h"
#include "util/fcswupd_trace.hpp"
#include "util/fcswupd_globalLog.h"
#include "config/fcswupd_config.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
// take class CTRL to remain compatible for test-automation
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_CTRL
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_CTRL_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_I_FILE_PREFIX fcswupdate::GlobalLog::

#include "trcGenProj/Header/fcswupd_globalLog.cpp.trc.h"
#endif


namespace fcswupdate {

static const char *LoggingScript="/usr/bin/log_to_p3.sh";
static const char *StartLoggingCmd="/usr/bin/log_to_p3.sh start >> /tmp/downloadPipe";
static const char *StopLoggingCmd="/usr/bin/log_to_p3.sh stop >> /tmp/downloadPipe";
static bool loggingEnabled=false;



void GlobalLog::printInternal(std::string const &text) {
   if (loggingEnabled) {
      swu::printToDownloadPipe(text);
   } else {
      FILE *f;
      f = fopen("/dev/console","w");
      if (f) {
         fprintf(f,"%s\n", text.c_str());
         fclose(f);      
      }
   }
}

void GlobalLog::marker() {
   std::string marker("*****************************************************************");
   printInternal(marker);
   ETG_TRACE_FATAL(("%s", marker.c_str()));

}

void GlobalLog::logResourcesInfo(std::string text) {
   swu::print2stdout("\n*****************************************************************\n");
   text = text + "\n";
   swu::print2stdout(text.c_str());
   swu::execCommand("/bin/bash /opt/bosch/swupdate/memwatcher.sh");
   swu::print2stdout("\n*****************************************************************\n");         
}
void GlobalLog::print(std::string text, tU8 options) {
    bool useErrmem=(options & logErrmem);
    bool addMarker=(options & logMarker);
    bool addStdout=(options & logstdOut);
   if (useErrmem) {
      ETG_TRACE_ERRMEM(("%s", text.c_str()));     
   }
   if (addMarker) {
      marker();
   }
   if (addStdout) {
      swu::print2stdout("\n*****************************************************************\n");
      swu::print2stdout(text.c_str());
      swu::print2stdout("\n*****************************************************************\n");
   }
   printInternal(text);
 

   ETG_TRACE_FATAL(("%s", text.c_str()));
   ETG_TRACE_COMP_CLS((TR_CLASS_FCSWUPDATE_CUST, "%s", text.c_str()));
   if (addMarker) {
      marker();
   }
}

void GlobalLog::logSwuErrorOnce(tenSwUpdateError errorCode) {
   static bool errorLogged=false;
   if (errorCode==tenSwUpdateError_OK || 
       errorCode==tenSwUpdateError_ERROR_METAINFO_NOT_FOUND ||
       errorCode==tenSwUpdateError_ERROR_MEDIA_UNAVAILABLE ||
       errorCode==tenSwUpdateError_ERROR_NO_RELEASE_FOUND) {
      return;
   }
   if (errorLogged) {
      return;
   }
   errorLogged=true;
   marker();
   print(std::string("Error Update-Medium: ") + enSwUpdateErrorTypeToString(errorCode) + " " + swu::uIntToString((tUInt)errorCode) + " FCID:" + Config::instance()->cfg_FcIdStr.get(), logErrmem);
   marker();
}

ETG_I_CMD_DEFINE((startLoggingFile, "startLoggingFile"))
void GlobalLog::startLoggingFile() {
   if (loggingEnabled) {
      return;
   }
   loggingEnabled=true;
   ETG_TRACE_USR4(("startLoggingFile: start"));

   // FIXME: Path is temporary and for debugging only!
   if(access(LoggingScript,F_OK)==0) {
      swu::execCommand(StartLoggingCmd);
   } else {
      printf("startLoggingFile: access to %s failed", LoggingScript);
   }
   ETG_TRACE_USR4(("startLoggingFile: end"));

}

ETG_I_CMD_DEFINE((stopLoggingFile, "stopLoggingFile"))
void GlobalLog::stopLoggingFile() {
   if (!loggingEnabled) {
      return;
   }
   ETG_TRACE_USR4(("stopLoggingFile: start"));
   loggingEnabled=false;
   ::sync();
   if(access(LoggingScript,F_OK)==0) {
      swu::execCommand(StopLoggingCmd);
   } else {
      printf("stopLoggingFile: access to %s failed", LoggingScript);
   }

   ETG_TRACE_USR4(("stopLoggingFile: end"));
}


ETG_I_CMD_DEFINE((exportLoggingFile, "exportLoggingFile %s", ETG_I_STRING))
void GlobalLog::exportLoggingFile(std::string mediaPath) {
   std::string logMarker = mediaPath+"./log.dnl";
   std::string logDirName = mediaPath+"./SpecialLogDir/";
   std::string logFile;
   bool        _logAvail=false;
   std::string _logPath;
   bool        pers_marker=swu::exists("/var/opt/bosch/persistent/DownloadLogWriter.ini");
   bool        tmp_marker=swu::exists("/tmp/DownloadLogWriter.ini");

   printf("exportLoggingFile: start");
   if(pers_marker != tmp_marker)
   {
      printf("exportLoggingFile: logging disabled");
      return;
   }

   tU8 logDirNr = 0;
   const int maxDirNumberLen=5;
   char dirNumberStr[maxDirNumberLen + 1];
   if((access(logMarker.c_str(),F_OK) == 0) && !_logAvail)
   {
      system(("mount -o remount,rw " + mediaPath).c_str());
      swu::makeDirectoryRecursive(logDirName, 0755);
      ETG_TRACE_COMP(("Ctrl:Created USB log directory %s",logDirName.c_str()));

      system(("ls "+logDirName+" |sort -n | tail -n 1 > /tmp/lastDir").c_str());
      FILE *file = fopen("/tmp/lastDir","r");
      if(file)
      {
	  // cast- for gen3 and gen4 compatibality
         int res=fscanf(file,"%u",(unsigned int*)&logDirNr);
         fclose(file);
         if (res<=1 || res==EOF) {
            logDirNr=0;
         }
         ETG_TRACE_COMP(("Ctrl:Log Dir Number %u",logDirNr));
      }
      logDirNr++;

      _logPath.assign(logDirName.c_str());
      snprintf(dirNumberStr, maxDirNumberLen + 1,"%u",logDirNr);
      dirNumberStr[maxDirNumberLen]=0;
      _logPath+=dirNumberStr;

      ETG_TRACE_COMP(("Ctrl:Log USB path %s",_logPath.c_str()));
      swu::makeDirectoryRecursive(_logPath, 0755);
      _logAvail = true;
      system((std::string("cp /tmp/downloadPipe ")+ _logPath+"/downloadPipe &").c_str());
      ::sync();
      system(("mount -o remount,ro " + mediaPath).c_str());
   }
}

}
