/*
 * fcswupd_cust_update_info.hpp
 *
 *  Created on: Jan 10, 2014
 *      Author: efs1hi
 */
#ifndef FCSWUPD_CUST_UPDATE_INFO_HPP_
#define FCSWUPD_CUST_UPDATE_INFO_HPP_

#include <string>
#include <list>
#include <map>

class TiXmlElement;

namespace fcswupdate {

class CustUpdateInfo {
public:
   struct Translation {
      std::string device;
      std::string name;
      std::string version;
   };

   CustUpdateInfo(std::string filepath, const TiXmlElement *checksum = NULL);

   ~CustUpdateInfo();

   bool init();

   inline std::string getDevice() const;

   inline std::string getName(std::string language) const;

   inline std::string getVersion(std::string language) const;

private:
   std::string _filepath;

   const TiXmlElement *_checksum;

   std::string _device;

   std::map< std::string, std::string > _names;

   std::map< std::string, std::string > _versions;
};

class CustUpdateInfoManager {
public:
   struct Translations {
      std::list< CustUpdateInfo::Translation > translations;
   };

   CustUpdateInfoManager() {
   }

   ~CustUpdateInfoManager() {
   }

   static void setCurrentLanguage(const std::string &language) {
      _currentLanguage = language;
   }

   Translations getTranslations(std::string updateTxtPath, TiXmlElement *checksum = NULL);

private:
   static std::string _currentLanguage;
};

std::string CustUpdateInfo::getDevice() const {
   return _device;
}

std::string CustUpdateInfo::getName(std::string language) const {
   std::map< std::string, std::string >::const_iterator it = _names.find(
         language);
   if (it == _names.end()) {
      std::map< std::string, std::string >::const_iterator it2 = _names.find(
            "default");
      return it2->second;
   }
   return it->second;
}

std::string CustUpdateInfo::getVersion(std::string language) const {
   std::map< std::string, std::string >::const_iterator it = _versions.find(
         language);
   if (it == _versions.end()) {
      std::map< std::string, std::string >::const_iterator it2 = _versions.find(
            "default");
      return it2->second;
      //return _versions["default"];
   }
   return it->second;
}

}
#endif /* FCSWUPD_CUST_UPDATE_INFO_HPP_ */
