/*
 * fcswupd_cust_update_info.cpp
 *
 *  Created on: Jan 10, 2014
 *      Author: efs1hi
 */
#include <main/fcswupd_component.h>
#include <string.h>
#include "util/swu_filesystem.h"
#include "util/swu_util.hpp"
#include "util/fcswupd_cust_update_info.hpp"
#include "tinyxml/tinyxml.h"
#include "util/fcswupd_trace.hpp"
#include "ctrl/fcswupd_ctrlXmlUtil.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_UTIL
#include "trcGenProj/Header/fcswupd_cust_update_info.cpp.trc.h"
#endif

using std::string;

namespace fcswupdate {

std::string CustUpdateInfoManager::_currentLanguage = "";

CustUpdateInfoManager::Translations CustUpdateInfoManager::getTranslations(string updateTxtPath,
      TiXmlElement *checksum) {
   CustUpdateInfoManager::Translations result;
   CustUpdateInfo::Translation t;
   CustUpdateInfo update_file(updateTxtPath, checksum);
   if (!update_file.init()) {
      ETG_TRACE_ERR(
            ("Could not load update.txt file %s", updateTxtPath.c_str()));
   } else {
      t.device = update_file.getDevice();
      //result.devices = update_file.getDevices();
      std::string lang = _currentLanguage;
      if (lang == "" ) {
         ETG_TRACE_ERR(
               ("get Translation was called before a language was set, using default"));
         lang = "default";
      }
      t.name = update_file.getName(lang);
      t.version = update_file.getVersion(lang);
      result.translations.push_back(t);
   }
   return result;
}

CustUpdateInfo::CustUpdateInfo(string filepath, const TiXmlElement *checksum) :
      _filepath(filepath), _checksum(checksum), _device(), _names(), _versions() {
}

CustUpdateInfo::~CustUpdateInfo() {
   _checksum = 0;
}

/*
  peha:
  please check general parsing with parser (wolfgang/timothy).
 */
void stripString(string &str) {
   while ( 1) {
      char first=str.at(0);
      if (first == ' ' || first == '\t' || first == 0x22) {
         str.erase( 0, 1 ); // erase the first character
         continue;
      }
      break;
   }
   while (1) {
      char last = *str.rbegin();
      if (last==0x22 || last ==' ' || last =='\n'  || last =='\r'  || last =='\t') {
         str.erase( str.size() - 1 ); // erase the last character 
         continue;
      } 
      break;
   }
}

bool CustUpdateInfo::init() {
   string data;
   if (!swu::loadFile(_filepath, data)) {
      ETG_TRACE_ERR(("Could not load update.txt file %s", _filepath.c_str()));
      return false;
   }

   if (_checksum) {
      swu::CCkSumElement cck;
      cck.init(_checksum);
      if (cck.GetType() != swu::tenDigestTypeNone) {
         const unsigned char *pos = (const unsigned char *) data.c_str();
         size_t rest_len = data.size();
         const ::std::vector< ::std::vector< uint8 > > checksums =
               cck.GetDigests();
         int i = 0;
         while (rest_len > 0) {
            unsigned char buffer[checksums[i].size()];
            for (size_t j = 0; j < checksums[i].size(); ++j) {
               buffer[j] = checksums[i][j];
            }
            bool result;
            if (!swu::checkChecksum(pos,
                  rest_len > cck.GetSeglen() ? cck.GetSeglen() : rest_len,
                  buffer, checksums[i].size(), result)) {
               ETG_TRACE_ERR(
                     ("Error checking checksum for update.txt %s", _filepath.c_str()));
               return false;
            }
            if (!result) {
               ETG_TRACE_ERR(
                     ("Error: update.txt has an invalid checksum %s", _filepath.c_str()));
               return false;
            }
            if (rest_len > cck.GetSeglen()) {
               pos += cck.GetSeglen();
               rest_len -= cck.GetSeglen();
            } else {
               rest_len = 0;
            }
            ++i;
         }
      }
   }

   const char *runner = data.c_str();
   const char *end = runner + data.length();

#if 0
    istringstream stream(data);
    while(1) {
      string line;
      getline(stream, line);
    }
#endif

   while (runner != end) {

      const char *linestart = runner;
      ETG_TRACE_USR4(("CustUpdateInfo::init: line=%s", linestart));
      size_t pre_length = 0;
 
      // search for separator =
     while ((runner != end) && (*runner != '\n') && (*runner != '=')) {
         ++pre_length;
         ++runner;
      }

      if (*runner == '=') {
         ETG_TRACE_USR4(("found separator =, pre_length=%u", pre_length));
         // found separator =
         const char *seperator = runner;
         size_t post_length = 0;
         ++runner;

         bool utf8_char = false;
         while ((runner != end) && (utf8_char || (*runner != '\n'))) {
            ++post_length;
            char inc = 1;
            // gen3x86make, gen4lsim: conversion to 'char' alters 'int' constant value
            char check = static_cast<char> (128);

            // As we have utf8 the characters have no constant size...
            utf8_char = false;
            while ((check & *runner) && (inc < 8)) {
               check =static_cast<char> (check >> 1);
               ++inc;
            }
            if (inc == 8) {
               ETG_TRACE_ERR(
                     ("update.txt file seems not to be utf8 encoded.... %s", _filepath.c_str()));
               return false;
            }
            if (runner + inc > end) {
               runner = end;
            } else {
               runner += inc;
            }
            utf8_char = (inc != 1);
         }

         if ((pre_length == 6) && (!strncmp(linestart, "device", 6))) {
            linestart += 6;
            //bool valid = true;

            // For later, when we support several devices
            //while ((linestart != seperator) && valid) {
            //   valid = (*linestart >= '0') && (*linestart <= '9');
            //}

            string devicename(seperator + 1, post_length - 1);
            stripString(devicename);
            _device = devicename;
            ETG_TRACE_USR4(("CustUpdateInfo::found  devicename=%s", devicename.c_str()));
            //_devices.push_back(devicename);
         } else if ((pre_length >= 5) && (!strncmp(linestart, "name.", 5))) {
            
            string language(linestart + 5, pre_length - 5);
            stripString(language);
            ETG_TRACE_USR4(("CustUpdateInfo::name: language=%s", language.c_str()));
            string name(seperator + 1, post_length - 1);
            stripString(name);
            ETG_TRACE_USR4(("CustUpdateInfo::name: name=%s", name.c_str()));
            _names[language] = name;
         } else if ((pre_length >= 8) && (!strncmp(linestart, "version.", 8))) {

            string language(linestart + 8, pre_length - 8);
            stripString(language);
            ETG_TRACE_USR4(("CustUpdateInfo::version: language=%s", language.c_str()));            
            string name(seperator + 1, post_length - 1);
            stripString(name);
            _versions[language] = name;
            ETG_TRACE_USR4(("CustUpdateInfo::version: name=%s", name.c_str()));
         }
      }

      while ((runner != end) && (*runner == '\n')) {
         ++runner;
      }
   }

   bool ok = true;
   if (!_device.size()) {
      ETG_TRACE_ERR(
            ("update.txt file has no device entry %s", _filepath.c_str()));
      ok = false;
   }
   if (!_names.size()) {
      ETG_TRACE_ERR(
            ("update.txt file has no valid name entry %s", _filepath.c_str()));
      ok = false;
   } else if (_names.find("default") == _names.end()) {
      ETG_TRACE_ERR(
            ("update.txt file has no valid default name entry %s", _filepath.c_str()));
      ok = false;
   }
   if (!_versions.size()) {
      ETG_TRACE_ERR(
            ("update.txt file has no valid version entry %s", _filepath.c_str()));
      ok = false;
   } else if (_versions.find("default") == _versions.end()) {
      ETG_TRACE_ERR(
            ("update.txt file has no valid default version entry %s", _filepath.c_str()));
      ok = false;
   }

   return ok;
}

}

