/*
 * fcswupd_parserBosch.h
 *
 *  Created on: Apr 15, 2014
 *      Author: efs1hi
 */

#ifndef FCSWUPD_PARSERBOSCH_H_
#define FCSWUPD_PARSERBOSCH_H_

#include "main/fcswupd_parserIf.h"

class TiXmlDocument;

namespace fcswupdate {

class BoschParser : public ParserIf {
public:
   BoschParser ();

   virtual ~BoschParser () {
      if (_document) {
         delete _document;
         _document = 0;
      }
   }

   
   virtual std::list<TiXmlElement> getReleaseList(trSourceInfo const &sourceInfo, tenSwUpdateError *errorCode);

   virtual bool setOverallSection(TiXmlElement const &overallSection);

   virtual TiXmlDocument *getReleaseXml(size_t id=0);

   virtual tenSwUpdateError getParserError(void) const;

private:
   TiXmlDocument *readBoschXmlFromMedium(trSourceInfo const &sourceInfo, tenSwUpdateError *errorCode);
   
   TiXmlDocument *_document;
   
   tenSwUpdateError _errorCode;

   BoschParser ( const BoschParser & );  //Coverity fix for 48148
   BoschParser& operator = ( const BoschParser & );  //Coverity fix for 47816

};

}



#endif /* FCSWUPD_PARSERBOSCH_H_ */
