/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*
 * fcswupd_vehicleDataIf.h
 *
 *  Created on: Feb 3, 2016
 *      Author: zaa8hi
 */

#ifndef FCSWUPD_VEHICLEDATAIF_H_
#define FCSWUPD_VEHICLEDATAIF_H_

#include "VEHICLE_MAIN_FIProxy.h"

#include "util/swu_asfUtil.hpp"
#include "util/swu_member.hpp"
#include "util/swu_singleton.hpp"
#include "main/fcswupd_component.h"

#define AUTO_PROPERTY_VEDA(PROPERTY) AUTO_PROPERTY_CCA_LOCAL(FcSwUpdateVeDaIf, getProxy, PROPERTY, __LINE__)


namespace fcswupdate {

/* message from Vehicle Data */

DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(VEHICLE_MAIN_FI, VEHICLE_MAIN_FIProxy, LanguageStatus);

class FcSwUpdateVeDaIf :
      public swu::Singleton< FcSwUpdateVeDaIf >,
      public swu::Member< FcSwUpdRoot >,
      public VEHICLE_MAIN_FI::LanguageCallbackIF
{
   // allow only instance() to construct this
   friend class Singleton< FcSwUpdateVeDaIf >;
   FcSwUpdateVeDaIf();
   
public:
   virtual ~FcSwUpdateVeDaIf();
   /** @brief Debug output, @see swu::MemberBase */
   virtual void traceState();
   /** @brief Name of the class, @see swu::MemberBase */
   virtual char const *getName() { return "FcSwUpdateVeDaIf"; }
   /** @brief Create the encapsulated VEHICLE_MAIN_FIProxy.
    *  The proxy is bound to the port defined in .cma file.
    *  The object can not be used prior to calling vInit().
    *  @see swu::MemberBase */
   virtual void vInit();
   virtual void vDeInit();
   void vProcess(swu::Msg_ProxyAvailability< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy, FcSwUpdRoot > *pMsg);
   // implement DistanceTotalizerCallbackIF
	virtual void onLanguageStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::LanguageStatus >& payload);

	AUTO_DISPATCH_ERROR(VEHICLE_MAIN_FI, VEHICLE_MAIN_FIProxy, LanguageError);

   ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >getProxy() { return _vedaProxy.getProxy(); }
   /** @brief Indicate if the connected service is available. */
   bool isAvailable() { return _vedaProxy.isAvail(); }

private:
	std::string getLanguageName(vehicle_main_fi_types::T_e8_Language_Code eLangName);
   static const int INVALID_UNIT_VALUE = 255;
   
	AUTO_PROPERTY_VEDA(Language);
   swu::ProxyAccess< FcSwUpdateComponent, VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _vedaProxy;

};

}

#endif /* FCSWUPD_VEHICLEDATAIF_H_ */
