#ifndef FCSWUPD_TFTP_IF_H
#define FCSWUPD_TFTP_IF_H

#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"
#include "main/fcswupd_component.h"


namespace fcswupdate {

struct Msg_TriggerTftp: public swu::Msg< Msg_TriggerTftp, FcSwUpdRoot > {
   virtual tVoid vTrace() {};
};


class TftpIf: 
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<TftpIf>
 {
      
   friend class swu::Singleton<TftpIf>;
 private:
    TftpIf() {
	_durationMs=0;   //Coverity fix for 98873
}

public:
    virtual ~TftpIf() {};
    virtual char const *getName() {
      return "TftpIf";
   }
    virtual void traceState() {};
    virtual void vInit();

    // start searching for tftp-release
    void start(tUInt durationMs);       
    // stop searching for tftp-release
    void stop();
    void vProcess(Msg_TriggerTftp *pMsg);
   
private:
    bool fetchTftp();
    tUInt _durationMs;
   swu::SwUpdTimer< TftpIf, Msg_TriggerTftp > _triggerTimer;
};

}



#endif
