#ifndef FCSWUPD_SYSTEM_DATA_H
#define FCSWUPD_SYSTEM_DATA_H

/*
 class SystemData should provide all (version-) of our target.
 - installed swTrain
 - muVersion
 - Version of modules/devices

 */



#ifndef   FCSWUPD_MNF_PARSER_LOCALBUILD
#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "tinyxml/tinyxml.h"
#include "main/fcswupd_modVersionIf.h"
#include <map>
//#include <sstream>

namespace fcswupdate {




class AdrVersionIf:public ModVersionIf {
public:
   AdrVersionIf():
      ModVersionIf("IVI/FIRMWARE/ADR")
   {}
   virtual std::string readBoschVersion();

   /*
     todo: how do we find out that version has changed?
     (polling via timer?)
    */

};




// Explicit Imx application & bootloader version interfaces

// deprecated
class ImxAppVersionIf:public ModVersionIf {
public:
  ImxAppVersionIf():
    ModVersionIf("IVI/FIRMWARE/RFS")
   {}
   virtual std::string readBoschVersion();
};

// deprecated
class ImxBlVersionIf:public ModVersionIf {
public:
  ImxBlVersionIf():
   ModVersionIf("IVI/FIRMWARE/BOOT")
   {}
   virtual std::string readBoschVersion();
};

class SxmAppVersionIf:public ModVersionIf {
public:
   SxmAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/SXM")
   {}
   virtual std::string readBoschVersion();
};

class CPLDVersionIf:public ModVersionIf {
public:
	CPLDVersionIf():
    ModVersionIf("IVI/FIRMWARE/CPLD")
    {}
   virtual std::string readBoschVersion();
};

class FpgaVersionIf:public ModVersionIf {
public:
   FpgaVersionIf():
   ModVersionIf("IVI/FIRMWARE/FPGA")
   {}
   virtual std::string readBoschVersion();
};

class ExtFpgaVersionIf:public ModVersionIf {
public:
   ExtFpgaVersionIf():
      ModVersionIf("IVI/FIRMWARE/EXTFPGA")
   {}
   virtual std::string readBoschVersion();
};

// Explicit v850 application & bootloader version interfaces
class V850AppVersionIf:public ModVersionIf {
public:
   V850AppVersionIf():
   ModVersionIf("IVI/FIRMWARE/V850")
   {}
   virtual std::string readBoschVersion();
};

class V850BlVersionIf:public ModVersionIf {
public: 
   V850BlVersionIf():
   ModVersionIf("IVI/FIRMWARE/V850BOOT")
   {}
   virtual std::string readBoschVersion();
};

class TeseoAppVersionIf:public ModVersionIf {
public:
   TeseoAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/TESEO")
   {}
   virtual std::string readBoschVersion();
};

class PdConfigAppVersionIf:public ModVersionIf {
public:
   PdConfigAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/PDCONFIG")
   {}
   virtual std::string readBoschVersion();
};

class CdDefConfigAppVersionIf:public ModVersionIf {
public:
   CdDefConfigAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/CDDEFCONFIG")
   {}
   virtual std::string readBoschVersion();
};


class CdConfigAppVersionIf:public ModVersionIf {
public:
   CdConfigAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/CDCONFIG")
   {}
   virtual std::string readBoschVersion();
};

class ToolsAppVersionIf:public ModVersionIf {
public:
   ToolsAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/SWUTOOLS")
   {}
};


class ScomoWcsAppVersionIf:public ModVersionIf {
public:
   ScomoWcsAppVersionIf():
   ModVersionIf("IVI/WCS/APPLICATION")
   {}
};

class ScomoRdlAppVersionIf:public ModVersionIf {
public:
   ScomoRdlAppVersionIf():
   ModVersionIf("IVI/RDL/APPLICATION")
   {}
};

class ScomoSvsAppVersionIf:public ModVersionIf {
public:
   ScomoSvsAppVersionIf():
   ModVersionIf("IVI/SVS/APPLICATION")
   {}
};

class ScomoSnmAppVersionIf:public ModVersionIf {
public:
   ScomoSnmAppVersionIf():
   ModVersionIf("IVI/SNM/APPLICATION")
   {}
};

class ScomoCvsAppVersionIf:public ModVersionIf {
public:
   ScomoCvsAppVersionIf():
   ModVersionIf("IVI/CVS/APPLICATION")
   {}
};

class DtvVersionIf:public ModVersionIf {
public:
   DtvVersionIf():
      ModVersionIf("IVI/FIRMWARE/DTV")
   {}
   virtual std::string readBoschVersion();
};

class MISAppVersionIf:public ModVersionIf {
public:
   MISAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/MIS")
   {}
   virtual std::string readBoschVersion();
};

class MCPAppVersionIf:public ModVersionIf {
public:
   MCPAppVersionIf():
   ModVersionIf("IVI/FIRMWARE/MCP")
   {}
   virtual std::string readBoschVersion();
};

class SXMHardwareType {
public:
  SXMHardwareType() { }
  ~SXMHardwareType() { }

   std::string get();
private:
   static std::string _HWType;
};


class HistoryRelease;


class SystemData: public swu::Member<FcSwUpdRoot>, public swu::Singleton< SystemData > {

   friend class swu::Singleton< SystemData > ;
   typedef enum {
      tenState_Initial, tenState_Initialized
   } tenState;

private:
   SystemData();

   virtual ~SystemData();

public:

   virtual char const *getName() {
      return "SystemData";
   }

   virtual void traceState();
   virtual tVoid vInit();
   virtual tVoid vDeInit();



/*
  get notification from any changed ModVersionIf
 */

   bool getFCID(tU16 & fcid);

   bool u64GetBuildTime(tU64 &);





   std::string const &getTrain() {
      assert(_enState == tenState_Initialized);
      return _trainVersion;
   }

   std::string const &getMuVersion() {
      assert(_enState == tenState_Initialized);
      // currently we make no difference between mu-version and train.
      // later for the Bosch-target muVersion shall be used, since
      // the train is reserved for the overall-version of the vehicle-SW
      // we are updating
      return _trainVersion;
   }

   bool hasValidTrain() {
      return _hasValidTrain;
   }




   bool registerInstalledRelease(const TiXmlElement *release,
         const TiXmlElement *releaseProgress, const std::string &type);

   bool registerModVersionIf(ModVersionIf *modVersionIf);
   void deregisterModVersionIf(ModVersionIf *modVersionIf);

   std::string getCurrentModVersion(std::string name);
   void onModVersionChanged(std::string name);

   unsigned int getBoradID();


   TiXmlElement const &getXml() {
      return _releaseXml;
   }
   // and so on ...

private:

   ModVersionIf *getModVersionIf(std::string name); 
   tenState _enState;
   // as long as asf is stubbed, we have to remember the porperty-values ourself
   std::string _trainVersion;
   std::string _muVersion;
   std::string _defaultUpdateKey;
   bool _defaultUpdateKeyInitialized;
   bool _hasValidTrain;
   std::map<std::string, ModVersionIf *> _modVersionIfs;
   /*
    peha: todo
    here we want to have to complete state of the current sw.
    assumptions: we only hold information that are part of latest history-element. Only state and version will later be updated by information retrieved from HW, e.g. ADR3
    all lookup shall be done with the naming from metainfo, e.g. "IVI/FIRMWARE/ADR".
    If the key shall be used as file-name, replace "/" by "#"
    Translation to this naming has to be done close to our interfaces, e.g. when the version is received from ADR.

    */
   TiXmlElement _releaseXml;


};

}

#endif

#endif   //   FCSWUPD_MNF_PARSER_LOCALBUILD
