#include <pthread.h>
// #include <set>
#include "util/swu_thread.hpp"
#include "util/fcswupd_types.hpp"
#include "main/fcswupd_history.h"

namespace fcswupdatesrv {
namespace FcSwUpdateSrvTypes {
class trUpdLog;
class trResult;
class trTartgetState;
class trSubModuleData;
class trModuleData;
class trDeviceData;
}
}

namespace fcswupdate {

   class Msg_StoreHistoryToStickRequest;
   class Msg_GetCacheDirectoryRequest;
   class Msg_GetUpdateHistoryRequest;
   class Msg_GetUpdateHistoryScopedRequest;
   class Msg_DeleteHistoryRequestRequest;
   class Msg_GetTargetStateRequest;
   class Msg_GetTargetStateByTypeRequest;
   class Msg_HandleCtrlError;
   class Msg_HandleCtrlResult;
   class Msg_ProgressInformation;
   class Msg_SetAllowRecoveryModeRequest;
   class Msg_EnterRecoveryModeRequest;
   class Msg_VerifyChecksumRequest;
   class Msg_GetUpdateFileRequest;
   class Msg_DisplayBgImageUpdate;

typedef enum {
   enVersionStyle_FromTo,
   enVersionStyle_To,
   enVersionStyle_Current,
} tenVersionStyle;


class VerifyChecksumWorker : public ::swu::ThreadBase<VerifyChecksumWorker> {
public:
   // message worker will send when result has been evaluated
   struct Msg_ChecksumWorkerFinished: public swu::Msg<Msg_ChecksumWorkerFinished, FcSwUpdRoot>  {
      Msg_ChecksumWorkerFinished(VerifyChecksumWorker *worker_):worker(worker_) {};
      virtual tVoid vTrace();
      VerifyChecksumWorker *worker;
   };
   VerifyChecksumWorker(act_t act, FCSWUPD_NS_FCSWUPD_T::tenVerifyType verifyType, std::string  area);
   virtual ~VerifyChecksumWorker() {};
   
   friend class ::swu::ThreadBase<VerifyChecksumWorker>;
   void getAsfResult(FCSWUPD_NS_FCSWUPD_T::trVerifyChecksumResult &asfResult);
   act_t getAct() { return _act; };

private:
   virtual void theadFn();
   bool parseChecksumFile( const ::std::string & outputFile,  std::string &ckSum );
   void notifyDone();

   act_t _act;
   FCSWUPD_NS_FCSWUPD_T::tenVerifyType _verifyType;
   std::string _area;
   FCSWUPD_NS_FCSWUPD_T::tenVerifyResult _verifyResult;
   ::std::string _checksum;
   bool  _success;
};


struct trHistoryContext {
   trHistoryContext(tenVersionStyle enVerisonStyle_, bool showRemoved_):
      enVersionStyle(enVerisonStyle_),
      showRemoved(showRemoved_)
   {}
   tenVersionStyle enVersionStyle;
   bool showRemoved;
   std::string curDevice;
   std::string curModule;
};

struct trItemContext {
   trItemContext(tenVersionStyle enVerisonStyle_, bool showRemoved_=false):
      enVersionStyle(enVerisonStyle_),
      showRemoved(showRemoved_),
      asfScope(FCSWUPD_NS_FCSWUPD_T::tenScope__None) //Coverity fix for 22861
   {}
   tenVersionStyle enVersionStyle;
   bool showRemoved;
   std::string fromVersion;
   std::string toVersion;
   std::string info;
   FCSWUPD_NS_FCSWUPD_T::tenScope asfScope;
};

class SrvGeneric:
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<SrvGeneric>
{
   friend class swu::Singleton<SrvGeneric>;

private:
   SrvGeneric();

public:
   typedef enum {
      tenFeatures_GetUpdateHistoryRequest,
      tenFeatures_GetTargetStateRequest,
      tenFeatures_GetTargetStateByTypeRequest,
      tenFeatures_NotifyCtrlError,
      tenFeatures_NotifyCtrlResult,
      tenFeatures_NotifyProgress,
      tenFeatures_SetAllowRecoveryMode,
      tenFeatures_GetUpdateHistoryScopedRequest,
      tenFeatures_AutoHandlePostImageRelease,
      tenFeatures_BgImageUpdate,
      tenFeatures_Invalid,
      
   } tenFeatures;

   virtual ~SrvGeneric();
   virtual void vInit();
   virtual void vDeInit();
   virtual void traceState();
   virtual const char *getName() {
      return "SrvGeneric";
   }
   void setFeature(tenFeatures enFeature);


   tVoid vProcess(Msg_StoreHistoryToStickRequest *pMsg);
   tVoid vProcess(Msg_GetCacheDirectoryRequest *pMsg);
   tVoid vProcess(Msg_GetUpdateHistoryRequest *pMsg);
   tVoid vProcess(Msg_GetTargetStateRequest *pMsg);
   tVoid vProcess(Msg_GetTargetStateByTypeRequest *pMsg);
   tVoid vProcess(Msg_NotifyCtrlError *pMsg);
   tVoid vProcess(Msg_NotifyCtrlResult *pMsg);
   tVoid vProcess(Msg_ProgressInformation *pMsg);
   tVoid vProcess(Msg_SetAllowRecoveryModeRequest *pMsg);
   tVoid vProcess(Msg_EnterRecoveryModeRequest *pMsg);
   tVoid vProcess(Msg_GetUpdateHistoryScopedRequest *pMsg);
   tVoid vProcess(Msg_GetUpdateFileRequest *pMsg);
   tVoid vProcess(Msg_DeleteHistoryRequestRequest *pMsg);
   tVoid vProcess(Msg_VerifyChecksumRequest *pMsg);
   tVoid vProcess(VerifyChecksumWorker::Msg_ChecksumWorkerFinished *pMsg);
   void vProcess(Msg_UpdateSelectReleaseByFileResult *pMsg);
   tVoid vProcess(Msg_DisplayBgImageUpdate *pMsg);

   FCSWUPD_NS_FCSWUPD_T::tenErrorId convCoreErrorCodeToPrj(uint32_t errorCodeInt);

   void simPostImageInstallation();

private:
   class PostImageRelease {
   public:
      PostImageRelease():
         _running(false),
         _origParserType(0),
         _origCreatePersistentProgress(0),
         _origForceRecovery(false),
         _origSilentUpdate(false)
      {};
      bool isPending();
      bool isRunning() { return _running; };
      bool start();
      void done(bool success);
      void forceInstallation(); // for testing only, not crash-save
      
   private:
      char const *getPostImageSubDir() { return "postImage"; };
      std::string const &getPostImageBxmlDir();

      bool _running;
      tU32 _origParserType;
      tU32 _origCreatePersistentProgress;
      bool _origForceRecovery;
      bool _origSilentUpdate;
   } _postImageRelease;

   std::set<VerifyChecksumWorker *>_checksumWorkers;
   void AutoHandlePostImageRelease();


   tVoid addUpdLog(::std::vector<FCSWUPD_NS_FCSWUPD_T::trUpdLog> &updateLogs, TiXmlElement const *hr);
   FCSWUPD_NS_FCSWUPD_T::trUpdLog *toUpdLog(const TiXmlElement *hr) const;
   virtual std::string getVersionString(const TiXmlElement *hs, trHistoryContext const &context) const;


   static FCSWUPD_NS_FCSWUPD_T::trDeviceData
   createAsfDevice(XmlItemAccess &access, 
                   ::std::vector< FCSWUPD_NS_FCSWUPD_T::trModuleData > &asfModules, 
                   trItemContext &context);

   static FCSWUPD_NS_FCSWUPD_T::trModuleData
   createAsfModule(XmlItemAccess &access, 
                   ::std::vector< FCSWUPD_NS_FCSWUPD_T::trSubModuleData > &asfSubModules, 
                   trItemContext &context);

   static FCSWUPD_NS_FCSWUPD_T::trSubModuleData
   createAsfSubModule(XmlItemAccess &access, 
                      trItemContext &context);

   static FCSWUPD_NS_FCSWUPD_T::trTimeDate getAsfTimeData(TiXmlElement const *utcXml);

   };
      
}
