#ifndef FcSwUpdSrv_h
#define FcSwUpdSrv_h

#include "fcswupd_component.h"
#include "fcswupdatesrv/FcSwUpdateSrvStub.h"
#include "util/swu_msg.hpp"

namespace fcswupdate {


#define FCSWUPD_USE_STUBS

#define FCSWUPD_TRACE_ASF_PROPERTY(CLS, LVL, VAL, PROP){        \
      if (etg_bIsTraceActive(CLS, LVL)) {                               \
         if (FcSwUpdSrv::instance()->get##PROP()!=VAL) \
            swu::traceAsfMsg(CLS, LVL,  VAL, "Property:" #PROP);        \
      }                                                                 \
   }

#define FCSWUPD_SET_ASF_PROPERTY(USER, VAL, PROP)  {                     \
      FCSWUPD_TRACE_ASF_PROPERTY(TR_CLASS_FCSWUPDATE_MAIN, 5, VAL, PROP); \
      USER::instance()->set##PROP(VAL);                  \
   }


/*
  Example for the result of DISPATCHABLE_MSG_DECL(UpdateEnterRequest)
*/
#if 0
struct Msg_UpdateEnterRequest: public swu::Msg<Msg_UpdateEnterRequest> {
   Msg_UpdateEnterRequest(const ::boost::shared_ptr< UpdateEnterRequest> _payload):
      payload(_payload) {};
   virtual tVoid vTrace() {
      printf(" Msg_UpdateEnterRequest\n");
   }
   const ::boost::shared_ptr<UpdateEnterRequest> payload;
};
#endif


/*
  for each XXXRequest received from asf-client:
  Define a wrapper-class Msg_XXXRequest that can be subscribed by any member
    
*/
#define DISPATCHABLE_MSG_DECL_FCSWUPD(NS, TYPE)                              \
   DISPATCHABLE_MSG_DECL(FcSwUpdRoot, NS, TYPE);
   
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateSetReleaseFilterRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateEnterRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateGetSourcesRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateSelectSourceRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateSelectReleaseRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateSelectReleaseByFileRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetDeviceStateListRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, SetUpdateOptionsRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, ModifyReleaseDocRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetUpdateFileRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, ApplyDocRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, SetAllowRecoveryModeRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, RetryFailedModulesRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateEndRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateAbortRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, UpdateAbortDeviceRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, HandleErrorRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetUpdateHistoryRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetUpdateHistoryScopedRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetUpdateHistoryDetailedRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, DeleteHistoryRequestRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetTargetStateRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, SetVersionBackDocAckRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, GetCacheDirectoryRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, EnterRecoveryModeRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, StoreHistoryToStickRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, VerifyChecksumRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, RegisterBgLocksRequest);
DISPATCHABLE_MSG_DECL_FCSWUPD(FCSWUPD_NS_FCSWUPD, ApplyLockRequest);




typedef EnumUtil<FCSWUPD_NS_FCSWUPD_T::tenErrorId, FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_OK> DefaultError;
typedef EnumUtil<FCSWUPD_NS_FCSWUPD_T::tenUpdOptions, FCSWUPD_NS_FCSWUPD_T::tenUpdOptions__NewOnly> DefaultUpdOption;
typedef EnumUtil<FCSWUPD_NS_FCSWUPD_T::tenStoreHistoryResult, FCSWUPD_NS_FCSWUPD_T::tenStoreHistoryResult__Ok> DefaultStoreHistoryResult;
typedef EnumUtil<FCSWUPD_NS_FCSWUPD_T::tenGetUpdateFileResult, FCSWUPD_NS_FCSWUPD_T::tenGetUpdateFileResult__Ok> DefaultGetUpdateFileResult;
typedef EnumUtil<FCSWUPD_NS_FCSWUPD_T::tenHistoryScope, FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__All> DefaultHistoryScope;
typedef EnumUtil<tU32, 0> DefaultU32Zero;


class FcSwUpdSrv :
      // our service we are stub (server)
      public FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvStub,
      public swu::Singleton<FcSwUpdSrv>,
      public swu::Member<FcSwUpdRoot>

{
public:
   FcSwUpdSrv();
   virtual tVoid vInit();
   virtual tVoid vDeInit() {};


   virtual const char *getName() {
      return "FcSwUpdSrv";
   }

   virtual void traceState() {}; 

   virtual ~FcSwUpdSrv();

   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, UpdateEnter);
   // example for coder generated by macro AUTO_DISPATCH_REQ_1(UpdateEnter,trDlSources);
#if 0
   // imput from clients for fcSwUpdateSrv
   virtual void onUpdateEnterRequest (const ::boost::shared_ptr< UpdateEnterRequest >& payload) {
      // just broadcast the message
      DISPATCH_MSG_NEW_1(UpdateEnter,trDlSources);
      //  DISPATCH_MSG_1(Msg_UpdateEnterRequest, sendUpdateEnterResponse, trDlSources);
   };
#endif
   // methods to be handled by ConfiguratorHmi
   //    virtual void onUpdateGetSourcesRequest (const ::boost::shared_ptr< UpdateGetSourcesRequest >& payload) {};
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateSetReleaseFilter,FCSWUPD_NS_FCSWUPD_T::trReleaseFilter);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateGetSources,FCSWUPD_NS_FCSWUPD_T::trUpdSources);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateSelectSource,FCSWUPD_NS_FCSWUPD_T::trReleaseInfos);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateSelectRelease, DefaultError);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateSelectReleaseByFile, DefaultError);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetDeviceStateList,FCSWUPD_NS_FCSWUPD_T::trDeviceStates);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, SetUpdateOptions,DefaultUpdOption);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, ModifyReleaseDoc,FCSWUPD_NS_FCSWUPD_T::trModifyAction);


   // method to be handled by Core 
   //    virtual void onApplyDocRequest (const ::boost::shared_ptr< ApplyDocRequest >& payload) {};
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, ApplyDoc);
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, ApplyLock);
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, SetAllowRecoveryMode);
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, EnterRecoveryMode);

   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, RetryFailedModules);

   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, UpdateEnd);
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, UpdateAbort);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, UpdateAbortDevice, FCSWUPD_NS_FCSWUPD_T::trAbortDeviceRes);
   AUTO_DISPATCH_REQ_0(FCSWUPD_NS_FCSWUPD, HandleError);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetUpdateHistory, FCSWUPD_NS_FCSWUPD_T::trUpdLogs);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetTargetState, FCSWUPD_NS_FCSWUPD_T::trTartgetState);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, SetVersionBackDocAck, FCSWUPD_NS_FCSWUPD_T::trVersionBackDocInfo);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetCacheDirectory, std::string);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, StoreHistoryToStick, DefaultStoreHistoryResult);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetUpdateFile, DefaultGetUpdateFileResult);
   AUTO_DISPATCH_REQ_5(FCSWUPD_NS_FCSWUPD, GetUpdateHistoryScoped, 
                       DefaultHistoryScope, 
                       FCSWUPD_NS_FCSWUPD_T::trUpdLogs,
                       DefaultU32Zero,
                       DefaultU32Zero,
                       DefaultU32Zero);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, GetUpdateHistoryDetailed, FCSWUPD_NS_FCSWUPD_T::trGetUpdateHistoryDetailed);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, DeleteHistoryRequest, bool);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, VerifyChecksum, FCSWUPD_NS_FCSWUPD_T::trVerifyChecksumResult);
   AUTO_DISPATCH_REQ_1(FCSWUPD_NS_FCSWUPD, RegisterBgLocks, bool);


#ifdef FCSWUPD_USE_STUBS
   void sendUpdateEnterResponse (bool bOk, act_t act = 0);
   void sendUpdateSetReleaseFilterResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trReleaseFilter rReleaseFilter, act_t act = 0);
   void sendUpdateGetSourcesResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trUpdSources rSources, act_t act = 0);
   void sendUpdateSelectSourceResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trReleaseInfos releaseInfos, act_t act = 0);
   void sendUpdateSelectReleaseResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::tenErrorId enErrorId, act_t act = 0);
   void sendUpdateSelectReleaseByFileResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::tenErrorId enErrorId, act_t act = 0);
   void sendSetUpdateOptionsResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::tenUpdOptions enOptionRes, act_t act = 0);
   void sendModifyReleaseDocResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trModifyAction enModifyActionRes, act_t act = 0);
   void sendUpdateEndResponse(bool bOk, act_t act = 0);
   void sendRegisterLockResponse(bool bOk, act_t act =0);
   void sendRetryFailedModulesResponse(bool bOk, act_t act = 0);
   void sendUpdateAbortResponse (bool bOk, act_t act = 0);
   void sendUpdateAbortDeviceResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trAbortDeviceRes rAbortDeviceRes, act_t act = 0);
   void sendHandleErrorResponse (bool bOk, act_t act = 0);

   void sendGetUpdateFileResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::tenGetUpdateFileResult result, act_t act = 0);
   void sendApplyDocResponse (bool bOk, act_t act = 0);
   void sendApplyLockResponse (bool bOk, act_t act = 0);
   void sendSetAllowRecoveryModeResponse(bool bOk, act_t act = 0);
   void sendEnterRecoveryModeResponse(bool bOk, act_t act = 0);
   void sendDeleteHistoryRequestResponse(bool bOk, act_t act = 0);
   void sendGetUpdateHistoryResponse(bool bOk, FCSWUPD_NS_FCSWUPD_T::trUpdLogs& logs, act_t act = 0);
   void sendGetCacheDirectoryResponse(bool bOk, ::std::string& dir, act_t act = 0);
   void sendGetUpdateHistoryScopedResponse(bool bOk, FCSWUPD_NS_FCSWUPD_T::tenHistoryScope enScopeRes,
		   FCSWUPD_NS_FCSWUPD_T::trUpdLogs& logs, uint32 numberOfUpdates, uint32 numberOfUpdatesSinceDelivery,
           uint32 numberOfUpateLogs, act_t act = 0);
   void sendGetUpdateHistoryDetailedResponse(bool bOk, FCSWUPD_NS_FCSWUPD_T::trGetUpdateHistoryDetailed &result, act_t act = 0);
   void sendGetTargetStateResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trTartgetState& state, act_t act = 0);
   void sendSetVersionBackDocAckResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::trVersionBackDocInfo& info, act_t act = 0);
   void sendStoreHistoryToStickResponse (bool bOk, FCSWUPD_NS_FCSWUPD_T::tenStoreHistoryResult enResult, act_t act = 0);
   void sendVerifyChecksumResponse(bool bOk,
				   FCSWUPD_NS_FCSWUPD_T::trVerifyChecksumResult trResult,
				   act_t act = 0);
   void sendRegisterBgLocksResponse(bool bOk,act_t act = 0);
   #endif



   // simulate input from Hmi
   void simHmiUpdateEnterRequest(tenSwUpdateMode enMode);
   void simHmiUpdateEndRequest();
   void simHmiUpdateSetReleaseFilterRequest(tUInt enUpdateOption);
   void simHmiUpdateGetSourcesRequest();
   void simHmiUpdateSelectSourceRequest(tUInt sourceIndex);
   void simHmiUpdateSelectReleaseRequest(tUInt releaseIndex);
   void simHmiUpdateSelectReleaseByFileRequest(char const *mountPoint, char const *path, char const *file, bool useExtendedOptions, uint32 releaseFilter, uint32 updateOption, bool doApply, bool postImageInstallationMode);
   void simHmiSetUpdateOptionsRequest(tUInt enUpdateOption);
   void simHmiModifyReleaseDocRequest(tUInt dev, tUInt mod, tUInt subMod, bool select);
   void simHmiGetUpdateFileRequest();
   void simHmiApplyDocRequest();
   void simHmiApplyLockRequest();
   void simHmiSetAllowRecoveryModeRequest(bool allow);
   void simHmiEnterRecoveryModeRequest();
   void simHmiSetVersionBackDocAckRequest(tU16 ack);
   void simInitCtrlCustomerDownload(const char *path_xml);
   void simHmiHandleErrorRequestAbort();
   void simHmiHandleErrorRequestSkip();
   void simHmiHandleErrorRequestRetry();
   void simHmiRetryFailedModules();
   void simHmiUpdateAbortRequest(bool deviceOnly);

   void simSegmentationFault();
   void simHmiGetTargetStateRequest(tU8 u8Type);
   void simHmiGetUpdateHistoryRequest();
   void simHmiGetUpdateHistoryScopedRequest(tU32 enScope, tU32 indexStart, tU32 numEntriesMax);
   void simHmiGetUpdateHistoryDetailedRequest(tU32 enScope, tU32 indexStart, tU32 numEntriesMax, tU32 format);
   void simHmiDeleteHistoryRequest(bool sinceFactoryResetOnly);
   void simHmiGetCacheDirectoryRequest(tUInt action);
   void simHmiStoreHistoryToStickRequest(bool sinceFactoryReset, bool writeToAllSticks);
   void simHmiVerifyChecksumRequest( tUInt verifyType,  char const *area);
   void simHmiRegisterBgLocksRequest(tU32 lockRegisterMode,char const *locks);
   
};

}
#endif
