#include <fstream>
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "util/swu_asfUtil.hpp"
#include <util/swu_util.hpp>
#include <util/swu_filesystem.h>


#include "fcswupd_component.h"
#include "fcswupd_srv.h"


#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdSrv::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_srv.cpp.trc.h"
#endif 

namespace fcswupdate {

#define SEND_ASF_RESULT_IMPL(METHOD, ...)                                \
   SWU_SEND_ASF_RESULT_IMPL(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvStub, METHOD, ##__VA_ARGS__ )

FcSwUpdSrv::FcSwUpdSrv():
   FcSwUpdateSrvStub("fcSwUpdatePort") /* port name as specified in the component manifest */
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_COMP(("FcSwUpdSrv::FcSwUpdSrv() CTOR start"));


   ETG_TRACE_COMP(("FcSwUpdSrv::FcSwUpdateComponent() CTOR end\n"));
   printf("FcSwUpdSrv CTOR END");
}


FcSwUpdSrv::~FcSwUpdSrv() {
   ETG_I_UNREGISTER_FILE();
}

tVoid FcSwUpdSrv::vInit() {
   ETG_TRACE_USR4(("FcSwUpdSrv::vInit() start"));

   // Set UpdateState properties that do not change at run time
   std::vector<tU8> naviUnitId(Config::instance()->cfg_CmNaviUnit.get());
   std::string naviUnitIdStr=std::string(naviUnitId.begin(), naviUnitId.end());
   swu::purifyString(naviUnitIdStr);
   getUpdateStateMutable().setHeadUnitId(naviUnitIdStr);
   if (getUpdateState().hasHeadUnitId()) {
      ETG_TRACE_COMP(("FcSwUpdSrv::vInit() naviUnitId=%s", getUpdateState().getHeadUnitId().c_str()));
   }

   ETG_TRACE_USR4(("FcSwUpdSrv::vInit() end"));
}


// stubs for send-functions
//lint -save -e1032
void FcSwUpdSrv::sendUpdateEnterResponse(bool bOk, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateEnterResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(UpdateEnter, bOk);
}

void FcSwUpdSrv::sendDeleteHistoryRequestResponse(bool bOk, act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendDeleteHistoryRequestResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(DeleteHistoryRequest, bOk);
}

void FcSwUpdSrv::sendRegisterLockResponse(bool bOk, act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendRegisterLockResponse bOk:%u", bOk));
   SEND_ASF_RESULT_IMPL(RegisterBgLocks, bOk);
}


void FcSwUpdSrv::sendUpdateSetReleaseFilterResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::trReleaseFilter rReleaseFilter, act_t act) {
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateSetReleaseFilterResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, rReleaseFilter);
   SEND_ASF_RESULT_IMPL(UpdateSetReleaseFilter, bOk, rReleaseFilter);
}

void FcSwUpdSrv::sendUpdateGetSourcesResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::trUpdSources rSources, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateGetSourcesResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, rSources);
   SEND_ASF_RESULT_IMPL(UpdateGetSources, bOk, rSources);
}

void FcSwUpdSrv::sendUpdateSelectSourceResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::trReleaseInfos releaseInfos, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateSelectSourceResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, releaseInfos);
   SEND_ASF_RESULT_IMPL(UpdateSelectSource, bOk, releaseInfos);
}

void FcSwUpdSrv::sendUpdateSelectReleaseResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::tenErrorId enErrorId, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateSelectReleaseResponse bOk=%d enErrorId=%d", bOk, enErrorId));
   SEND_ASF_RESULT_IMPL(UpdateSelectRelease, bOk, enErrorId);
}

void FcSwUpdSrv::sendUpdateSelectReleaseByFileResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::tenErrorId enErrorId, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendUpdateSelectReleaseByFileResponse bOk=%d enErrorId=%d", bOk, enErrorId));
   SEND_ASF_RESULT_IMPL(UpdateSelectReleaseByFile, bOk, enErrorId);
}

void FcSwUpdSrv::sendSetUpdateOptionsResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::tenUpdOptions enOptionRes, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendSetUpdateOptionsResponse bOk=%d enOptionRes=%d", bOk, enOptionRes));
   SEND_ASF_RESULT_IMPL(SetUpdateOptions, bOk, enOptionRes);
}

void FcSwUpdSrv::sendModifyReleaseDocResponse(bool bOk,
FCSWUPD_NS_FCSWUPD_T::trModifyAction enModifyActionRes, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::, FCSWUPD_NS_FCSWUPD_T::trModifyAction, enModifyActionRes bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(ModifyReleaseDoc, bOk, enModifyActionRes);
}

void FcSwUpdSrv::sendUpdateEndResponse(bool bOk, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(
         ("FcSwUpdSrv::sendUpdateEndResponse(bOk=%s)",
               bOk ? "true" : "false"));
   SEND_ASF_RESULT_IMPL(UpdateEnd, bOk);
}


void FcSwUpdSrv::sendRetryFailedModulesResponse(bool bOk, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendRetryFailedModulesResponse(bOk=%s)", bOk ? "true" : "false"));
   SEND_ASF_RESULT_IMPL(RetryFailedModules, bOk);
}

void FcSwUpdSrv::sendUpdateAbortResponse(bool bOk, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(
         ("FcSwUpdSrv::sendUpdateAbortResponse(bOk=%s)",
               bOk ? "true" : "false"));
   SEND_ASF_RESULT_IMPL(UpdateAbort, bOk);
}

void FcSwUpdSrv::sendUpdateAbortDeviceResponse(bool bOk, 
                                                        FCSWUPD_NS_FCSWUPD_T::trAbortDeviceRes rAbortDeviceRes,
                                                        act_t act) {
	(void)act; 
   ETG_TRACE_COMP(
         ("FcSwUpdSrv::sendUpdateAbortDeviceResponse(bOk=%s), content follows:",
               bOk ? "true" : "false"));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, rAbortDeviceRes);
   SEND_ASF_RESULT_IMPL(UpdateAbortDevice, bOk, rAbortDeviceRes);
}


void FcSwUpdSrv::sendHandleErrorResponse(bool bOk, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(
         ("FcSwUpdSrv::sendHandleErrorResponse(bOk=%s)",
               bOk ? "true" : "false"));
   SEND_ASF_RESULT_IMPL(HandleError, bOk);
}

void FcSwUpdSrv::sendApplyDocResponse(bool bOk, act_t act) {
	(void)act; 
        ETG_TRACE_COMP(("FcSwUpdSrv::sendApplyDocResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(ApplyDoc, bOk);
}

void FcSwUpdSrv::sendApplyLockResponse(bool bOk, act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendApplyLockResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(ApplyLock, bOk);
}


void FcSwUpdSrv::sendSetAllowRecoveryModeResponse(bool bOk, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendSetAllowRecoveryModeResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(SetAllowRecoveryMode, bOk);
}

void FcSwUpdSrv::sendEnterRecoveryModeResponse(bool bOk, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendEnterRecoveryModeResponse bOk=%d", bOk));
   SEND_ASF_RESULT_IMPL(EnterRecoveryMode, bOk);
}

void FcSwUpdSrv::sendStoreHistoryToStickResponse(bool bOk, FCSWUPD_NS_FCSWUPD_T::tenStoreHistoryResult enResult, act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendStoreHistoryToStickResponse bOk=%d, enResult=%d", bOk, enResult));
   SEND_ASF_RESULT_IMPL(StoreHistoryToStick, bOk, enResult);
}

void FcSwUpdSrv::sendGetUpdateFileResponse(bool bOk, FCSWUPD_NS_FCSWUPD_T::tenGetUpdateFileResult result, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetUpdateFileResponse result=%u bOk=%d", (tU32)result, bOk));
   SEND_ASF_RESULT_IMPL(GetUpdateFile, bOk, result);
}

void FcSwUpdSrv::sendGetUpdateHistoryResponse(bool bOk,
      FCSWUPD_NS_FCSWUPD_T::trUpdLogs& logs, act_t act) {
   (void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetUpdateHistoryResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, logs);
   SEND_ASF_RESULT_IMPL(GetUpdateHistory, bOk, logs);
}

void FcSwUpdSrv::sendGetCacheDirectoryResponse(bool bOk, ::std::string& dir, act_t act)
{
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetCacheDirectoryResponse bOk=%d, dir=%s", bOk, dir.c_str()));
   SEND_ASF_RESULT_IMPL(GetCacheDirectory, bOk, dir);
}

void FcSwUpdSrv::sendGetUpdateHistoryScopedResponse(bool bOk, 
                                                    FCSWUPD_NS_FCSWUPD_T::tenHistoryScope enScopeRes,
                                                    FCSWUPD_NS_FCSWUPD_T::trUpdLogs& logs, 
                                                    uint32 numberOfUpdates, 
                                                    uint32 numberOfUpdatesSinceDelivery,
                                                    uint32 numberOfUpateLogs, 
                                                    act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetUpdateHistoryScopedResponse enScopeRes=%u, numberOfUpdates=%u, numberOfUpdatesSinceDelivery=%u, numberOfUpateLogs=%u",
		   enScopeRes, numberOfUpdates, numberOfUpdatesSinceDelivery, numberOfUpateLogs));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, logs);
   SEND_ASF_RESULT_IMPL(GetUpdateHistoryScoped, bOk, enScopeRes, logs, numberOfUpdates, numberOfUpdatesSinceDelivery, numberOfUpateLogs);
}

void FcSwUpdSrv::sendGetUpdateHistoryDetailedResponse(bool bOk, 
                                                    FCSWUPD_NS_FCSWUPD_T::trGetUpdateHistoryDetailed &result, 
                                                    act_t act) {
   (void)act;
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetUpdateHistoryScopedResponse enScope=%u, numberOfUpateLogs=%u, getNumberOfUpdates=%u, numberOfUpdatesSinceDelivery=%u, enFormat=%u",
		   (tU32)result.getEnScope(),
                   result.getLogs().getUpdateLogs().size(),
                   result.getNumberOfUpdates(),
                   result.getNumberOfUpdatesSinceDelivery(),
                   (tU32)result.getEnFormat()));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, result.getLogs());
   SEND_ASF_RESULT_IMPL(GetUpdateHistoryDetailed, bOk, result);
}


void FcSwUpdSrv::sendGetTargetStateResponse(bool bOk,
      FCSWUPD_NS_FCSWUPD_T::trTartgetState& state, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendGetTargetStateResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, state);
   SEND_ASF_RESULT_IMPL(GetTargetState, bOk, state);
}


void FcSwUpdSrv::sendSetVersionBackDocAckResponse(bool bOk,
      FCSWUPD_NS_FCSWUPD_T::trVersionBackDocInfo& info, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(("FcSwUpdSrv::sendSetVersionBackDocAckResponse bOk=%d", bOk));
   SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, info);
   SEND_ASF_RESULT_IMPL(SetVersionBackDocAck, bOk, info);
}


void FcSwUpdSrv::sendVerifyChecksumResponse (bool bOk,
                                             FCSWUPD_NS_FCSWUPD_T::trVerifyChecksumResult trResult,
                                             act_t act)
{
   ETG_TRACE_COMP(("FcSwUpdSrv::sendVerifyChecksumResponse bOk=%d act=%u", bOk, act));
    SWU_TRACE_ASF_MSG_VAL(TR_CLASS_FCSWUPDATE_MAIN, 7, trResult);
    if (act) {
       // for this method we expect several requests in parallel, so sender has to provide the act
       FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvStub::sendVerifyChecksumResponse(bOk, trResult, act);
    }
}

void FcSwUpdSrv::sendRegisterBgLocksResponse(bool bOk, act_t act) {
	(void)act; 
   ETG_TRACE_COMP(
         ("FcSwUpdSrv::sendRegisterBgLocksResponse(bOk=%s)",
               bOk ? "true" : "false"));
   SEND_ASF_RESULT_IMPL(RegisterBgLocks, bOk);
}

//lint -restore

ETG_I_CMD_DEFINE((simHmiUpdateEnterRequest, "simHmiUpdateEnterRequest", ETG_I_CONST_ARG(fcswupdate::tenSwUpdateMode_Hmi)))
ETG_I_CMD_DEFINE((simHmiUpdateEnterRequest, "simHmiUpdateEnterRequestRecovery", ETG_I_CONST_ARG(fcswupdate::tenSwUpdateMode_Emergency)))
void FcSwUpdSrv::simHmiUpdateEnterRequest(tenSwUpdateMode enMode) {
   std::ofstream ofs("/tmp/hello.txt", std::ofstream::out);
   ofs << "FcSwUpdSrv::simHmiUpdateEnterRequest start";
   ofs.close();
   ETG_TRACE_USR4(("simHmiUpdateEnterRequest: mode=%u",
                   ETG_CENUM(tenSwUpdateMode, enMode)));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateEnterRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateEnterRequest());
      FCSWUPD_NS_FCSWUPD_T::tenUser enAsfUser=FCSWUPD_NS_FCSWUPD_T::tenUser__None;
   if (enMode==tenSwUpdateMode_Hmi) {
      enAsfUser=FCSWUPD_NS_FCSWUPD_T::tenUser__Service;
   }  else if (enMode==tenSwUpdateMode_Emergency) {
      enAsfUser=FCSWUPD_NS_FCSWUPD_T::tenUser__Recovery;
   } else {
      ETG_TRACE_COMP(("simHmiUpdateEnterRequest invalid mode"));
      return;
   }
   payload->setEnUser(enAsfUser);
   ETG_TRACE_COMP(("simHmiUpdateEnterRequest START"));
   onUpdateEnterRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateEnterRequest END"));
}


ETG_I_CMD_DEFINE((simHmiUpdateEndRequest, "simHmiUpdateEndRequest"))void FcSwUpdSrv::simHmiUpdateEndRequest() {
   std::ofstream ofs("/tmp/hello.txt", std::ofstream::out);
   ofs << "FcSwUpdSrv::simHmiUpdateEndRequest start";
   ofs.close();
   ETG_TRACE_USR4(("simHmiUpdateEnterRequest"));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateEndRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateEndRequest());
   ETG_TRACE_COMP(("simHmiUpdateEndRequest START"));
   onUpdateEndRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateEndRequest END"));
}

ETG_I_CMD_DEFINE((simHmiUpdateSetReleaseFilterRequest, "simHmiUpdateSetReleaseFilterRequest %u", tU32))
void FcSwUpdSrv::simHmiUpdateSetReleaseFilterRequest(tUInt enUpdateOption) {
   ETG_TRACE_USR4(("simHmiSetReleaseFilterRequest enUpdateOption=%u", enUpdateOption));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateSetReleaseFilterRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateSetReleaseFilterRequest());
   ETG_TRACE_COMP(("simHmiUpdateSetReleaseFilterRequest START"));
   FCSWUPD_NS_FCSWUPD_T::trReleaseFilter releaseFilter((FCSWUPD_NS_FCSWUPD_T::tenUpdOptions)enUpdateOption);
   payload->setFilter(releaseFilter);
   onUpdateSetReleaseFilterRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateSetReleaseFilterRequest END"));
}


ETG_I_CMD_DEFINE(
      (simHmiUpdateGetSourcesRequest, "simHmiUpdateGetSourcesRequest"))void FcSwUpdSrv::simHmiUpdateGetSourcesRequest() {
   ETG_TRACE_USR4(("simHmiUpdateGetSourcesRequest"));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateGetSourcesRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateGetSourcesRequest());
   ETG_TRACE_COMP(("simHmiUpdateGetSourcesRequest START"));
   onUpdateGetSourcesRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateGetSourcesRequest END"));
}

ETG_I_CMD_DEFINE(
      (simHmiUpdateSelectSourceRequest, "simHmiUpdateSelectSourceRequest %u", tU32))
ETG_I_CMD_DEFINE(
      (simHmiUpdateSelectSourceRequest, "simHmiUpdateSelectSourceRequestHex %x", tU32))
void FcSwUpdSrv::simHmiUpdateSelectSourceRequest(
      tUInt sourceIndex) {
   ETG_TRACE_USR4(("simHmiUpdateSelectSourceRequest"));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateSelectSourceRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateSelectSourceRequest());
   payload->setSourceIndex(sourceIndex);
   ETG_TRACE_COMP(
         ("simHmiUpdateSelectSourceRequest(sourceIndex=%u) START", sourceIndex));
   onUpdateSelectSourceRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateSelectSourceRequest END"));
}

ETG_I_CMD_DEFINE(
      (simHmiUpdateSelectReleaseRequest, "simHmiUpdateSelectReleaseRequest %u", tU32))
void FcSwUpdSrv::simHmiUpdateSelectReleaseRequest(
      tUInt releaseIndex) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateSelectReleaseRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateSelectReleaseRequest());
   payload->setReleaseIndex(releaseIndex);
   ETG_TRACE_COMP(("simHmiUpdateSelectReleaseRequest(releaseIndex=%u) START", releaseIndex));
   onUpdateSelectReleaseRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateSelectReleaseRequest END"));
}

ETG_I_CMD_DEFINE(
                 (simHmiUpdateSelectReleaseByFileRequest, "simHmiUpdateSelectReleaseByFileRequest %50s %50s %50s %u %u %u %u %u", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING, tU32, tU32, tU32, tU32, tU32))
void FcSwUpdSrv::simHmiUpdateSelectReleaseByFileRequest(char const *mountPoint, 
                                                        char const *path, 
                                                        char const *file,
                                                        bool useExtendedOptions,
                                                        uint32 releaseFilter, 
                                                        uint32 updateOption,
                                                        bool doApply,
                                                        bool postImageInstallationMode) {
   ETG_TRACE_COMP(("simHmiUpdateSelectReleaseByFileRequest: "
                   "mountPoint=%50s path=%50s file=%50s useExtendedOptions=%u releaseFilter=%u updateOption=%u doApply=%u",
                   mountPoint, path, file, useExtendedOptions, releaseFilter, updateOption, doApply));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateSelectReleaseByFileRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateSelectReleaseByFileRequest());
   FCSWUPD_NS_FCSWUPD_T::trReleaseAccess releaseAccess;
   releaseAccess.setMountPoint(mountPoint);
   releaseAccess.setPath(path);
   releaseAccess.setFile(file);
   releaseAccess.setUseExtendedOptions(useExtendedOptions);
   FCSWUPD_NS_FCSWUPD_T::trReleaseFilter asfReleaseFilter((FCSWUPD_NS_FCSWUPD_T::tenUpdOptions)releaseFilter);
   releaseAccess.setReleaseFilter(asfReleaseFilter);
   releaseAccess.setUpdateOption((FCSWUPD_NS_FCSWUPD_T::tenUpdOptions)updateOption);
   releaseAccess.setDoApply(doApply);
   releaseAccess.setPostImageInstallationMode(postImageInstallationMode);

   payload->setReleaseAccess(releaseAccess);
   onUpdateSelectReleaseByFileRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateSelectReleaseByFileRequest END"));
}


ETG_I_CMD_DEFINE((simHmiSetUpdateOptionsRequest, "simHmiSetUpdateOptionsRequest %u", tU32))
void FcSwUpdSrv::simHmiSetUpdateOptionsRequest(tUInt enUpdateOption) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::SetUpdateOptionsRequest > payload(new FCSWUPD_NS_FCSWUPD::SetUpdateOptionsRequest((FCSWUPD_NS_FCSWUPD_T::tenUpdOptions)enUpdateOption));

   ETG_TRACE_COMP(("simHmiSetUpdateOptionsRequest enUpdateOption=%u START", enUpdateOption));
   onSetUpdateOptionsRequest(payload);
   ETG_TRACE_COMP(("simHmiSetUpdateOptionsRequest END"));
}

ETG_I_CMD_DEFINE((simHmiModifyReleaseDocRequest, "simHmiModifyReleaseDocRequest %u %u %u %u", tU32, tU32, tU32, tU32))
void FcSwUpdSrv::simHmiModifyReleaseDocRequest(tUInt dev, tUInt mod,
      tUInt subMod, bool select) {
   FCSWUPD_NS_FCSWUPD_T::trModifyAction trModifyAction(dev, mod,
         subMod, select ? FCSWUPD_NS_FCSWUPD_T::tenModifyAction__Activate : FCSWUPD_NS_FCSWUPD_T::tenModifyAction__DeActivate);

   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::ModifyReleaseDocRequest > payload(new FCSWUPD_NS_FCSWUPD::ModifyReleaseDocRequest(trModifyAction));

   ETG_TRACE_COMP(("simHmiModifyReleaseDocRequest dev=%u mod=%u subMod=%u select=%u START", dev, mod, subMod, select));
   onModifyReleaseDocRequest(payload);
   ETG_TRACE_COMP(("simHmiModifyReleaseDocRequest END"));
}

ETG_I_CMD_DEFINE((simHmiUpdateAbortRequest, "simHmiUpdateAbortRequest %u", tU8))
void FcSwUpdSrv::simHmiUpdateAbortRequest(bool deviceOnly) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateAbortRequest > payload(new FCSWUPD_NS_FCSWUPD::UpdateAbortRequest(deviceOnly));
   ETG_TRACE_COMP(("simHmiUpdateAbortRequest START deviceOnly=%u", deviceOnly));
   onUpdateAbortRequest(payload);
   ETG_TRACE_COMP(("simHmiUpdateAbortRequest END"));
}

ETG_I_CMD_DEFINE((simHmiGetUpdateFileRequest, "simHmiGetUpdateFileRequest"))
void FcSwUpdSrv::simHmiGetUpdateFileRequest() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetUpdateFileRequest > payload(new FCSWUPD_NS_FCSWUPD::GetUpdateFileRequest());
   ETG_TRACE_COMP(("simHmiGetUpdateFileRequest START"));
   onGetUpdateFileRequest(payload);
   ETG_TRACE_COMP(("simHmiGetUpdateFileRequest END"));
}

ETG_I_CMD_DEFINE((simHmiApplyDocRequest, "simHmiApplyDocRequest"))
void FcSwUpdSrv::simHmiApplyDocRequest() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::ApplyDocRequest > payload(new FCSWUPD_NS_FCSWUPD::ApplyDocRequest());
   ETG_TRACE_COMP(("simHmiApplyDocRequest START"));
   onApplyDocRequest(payload);
   ETG_TRACE_COMP(("simHmiApplyDocRequest END"));
}

ETG_I_CMD_DEFINE((simHmiApplyLockRequest, "simHmiApplyLockRequest"))
void FcSwUpdSrv::simHmiApplyLockRequest() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::ApplyLockRequest > payload(new FCSWUPD_NS_FCSWUPD::ApplyLockRequest());
   ETG_TRACE_COMP(("simHmiApplyLockRequest START"));
   onApplyLockRequest(payload);
   ETG_TRACE_COMP(("simHmiApplyLockRequest END"));
}


ETG_I_CMD_DEFINE((simHmiSetAllowRecoveryModeRequest, "simHmiSetAllowRecoveryModeRequest %u", tU8))
void FcSwUpdSrv::simHmiSetAllowRecoveryModeRequest(bool allow) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::SetAllowRecoveryModeRequest > payload(new FCSWUPD_NS_FCSWUPD::SetAllowRecoveryModeRequest(allow));
   ETG_TRACE_COMP(("simHmiSetAllowRecoveryModeRequest START allow=%u", allow));
   onSetAllowRecoveryModeRequest(payload);
   ETG_TRACE_COMP(("simHmiSetAllowRecoveryModeRequest END"));
}

ETG_I_CMD_DEFINE((simHmiEnterRecoveryModeRequest, "simHmiEnterRecoveryModeRequest"))
void FcSwUpdSrv::simHmiEnterRecoveryModeRequest() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::EnterRecoveryModeRequest > payload(new FCSWUPD_NS_FCSWUPD::EnterRecoveryModeRequest());
   ETG_TRACE_COMP(("simHmiEnterRecoveryModeRequest START"));
   onEnterRecoveryModeRequest(payload);
   ETG_TRACE_COMP(("simHmiEnterRecoveryModeRequest END"));
}


ETG_I_CMD_DEFINE((simHmiSetVersionBackDocAckRequest, "simHmiSetVersionBackDocAckRequestHex %x", tU16))
void FcSwUpdSrv::simHmiSetVersionBackDocAckRequest(tU16 ack) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::SetVersionBackDocAckRequest > payload(new FCSWUPD_NS_FCSWUPD::SetVersionBackDocAckRequest(ack));
   ETG_TRACE_COMP(("simHmiSetVersionBackDocAckRequest START"));
   onSetVersionBackDocAckRequest(payload);
   ETG_TRACE_COMP(("simHmiSetVersionBackDocAckRequest END"));
}


ETG_I_CMD_DEFINE((simHmiHandleErrorRequestAbort, "simHmiHandleErrorRequestAbort"))
void FcSwUpdSrv::simHmiHandleErrorRequestAbort() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::HandleErrorRequest > payload(new FCSWUPD_NS_FCSWUPD::HandleErrorRequest());
   payload->setEnMode(FCSWUPD_NS_FCSWUPD_T::tenErrorHandlingMode__Abort);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest START"));
   onHandleErrorRequest(payload);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest END"));
}

ETG_I_CMD_DEFINE((simHmiHandleErrorRequestRetry, "simHmiHandleErrorRequestRetry"))
void FcSwUpdSrv::simHmiHandleErrorRequestRetry() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::HandleErrorRequest > payload(new FCSWUPD_NS_FCSWUPD::HandleErrorRequest());
   payload->setEnMode(FCSWUPD_NS_FCSWUPD_T::tenErrorHandlingMode__Retry);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest START"));
   onHandleErrorRequest(payload);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest END"));
}

ETG_I_CMD_DEFINE((simHmiHandleErrorRequestSkip, "simHmiHandleErrorRequestSkip"))
void FcSwUpdSrv::simHmiHandleErrorRequestSkip() {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::HandleErrorRequest > payload(new FCSWUPD_NS_FCSWUPD::HandleErrorRequest());
   payload->setEnMode(FCSWUPD_NS_FCSWUPD_T::tenErrorHandlingMode__Skip);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest START"));
   onHandleErrorRequest(payload);
   ETG_TRACE_COMP(("simHmiHandleErrorRequest END"));
}

ETG_I_CMD_DEFINE((simHmiGetTargetStateRequest, "simHmiGetTargetStateRequestAll", ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetTargetStateRequest, "simHmiGetTargetStateRequestCustomer", ETG_I_CONST_ARG(1)))
void FcSwUpdSrv::simHmiGetTargetStateRequest(tU8 u8Type) {
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetTargetStateRequest > payload(new FCSWUPD_NS_FCSWUPD::GetTargetStateRequest());
   payload->setEnUpdateType((FCSWUPD_NS_FCSWUPD_T::tenUpdType)u8Type);
   ETG_TRACE_COMP(("simHmiGetTargetStateRequest START, type=%s", u8Type ? "Customer" : "All"));
   onGetTargetStateRequest(payload);
   ETG_TRACE_COMP(("simHmiGetTargetStateRequest END"));
}

ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryRequest, "simHmiGetUpdateHistoryRequest"))
void FcSwUpdSrv::simHmiGetUpdateHistoryRequest() {
   ETG_TRACE_COMP(("simHmiGetUpdateHistoryRequest START"));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetUpdateHistoryRequest> payload(new FCSWUPD_NS_FCSWUPD::GetUpdateHistoryRequest());
   FcSwUpdSrv::instance()->onGetUpdateHistoryRequest(payload);
   ETG_TRACE_COMP(("simHmiGetUpdateHistoryRequest END"));
}

ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestAll %u %u", ETG_I_CONST_ARG(0), tU32, tU32))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestFirstUsb", ETG_I_CONST_ARG(1), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestFirstOta", ETG_I_CONST_ARG(2), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestFirstUsbFactory", ETG_I_CONST_ARG(3), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestFirstOtaFactory", ETG_I_CONST_ARG(4), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestInitial", ETG_I_CONST_ARG(5), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryScopedRequest, "simHmiGetUpdateHistoryScopedRequestInitialFactory", ETG_I_CONST_ARG(6), ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(0)))
void FcSwUpdSrv::simHmiGetUpdateHistoryScopedRequest(tU32 enScope, tU32 indexStart, tU32 numEntriesMax)
{
	const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetUpdateHistoryScopedRequest > payload(new FCSWUPD_NS_FCSWUPD::GetUpdateHistoryScopedRequest());
	payload->setEnScope((FCSWUPD_NS_FCSWUPD_T::tenHistoryScope)enScope);
	payload->setIndexStart(indexStart);
	payload->setNumEntriesMax(numEntriesMax);
	const char *scope = "";
	switch (enScope)
	{
		case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__All: scope = "All"; break;
		case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__FirstUsb: scope = "FirstUsb"; break;
		case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__FirstOta: scope = "FirstOta"; break;
		case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__FirstUsbSinceFactory: scope = "FirstUsbFactory"; break;
		case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__FirstOtaSinceFactory: scope = "FirstOtaFactory"; break;
      case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__Initial: scope = "Initial"; break;
      case FCSWUPD_NS_FCSWUPD_T::tenHistoryScope__InitialSinceFactory: scope = "InitialFactory"; break;
	}
	ETG_TRACE_COMP(("simHmiGetUpdateHistoryScopedRequest START, start=%u, max=%u, scope=%s", indexStart, numEntriesMax, scope));
	onGetUpdateHistoryScopedRequest(payload);
	ETG_TRACE_COMP(("simHmiGetUpdateHistoryScopedRequest END"));
}


ETG_I_CMD_DEFINE((simHmiGetUpdateHistoryDetailedRequest, "simHmiGetUpdateHistoryDetailedRequestInitialFactory %u %u %u %u", tU32, U32, tU32, tU32))
void FcSwUpdSrv::simHmiGetUpdateHistoryDetailedRequest(tU32 enScope, tU32 indexStart, tU32 numEntriesMax, tU32 enFormat)
{
   FCSWUPD_NS_FCSWUPD_T::trGetUpdateHistoryDetailedRequest data;
   data.setEnScope((FCSWUPD_NS_FCSWUPD_T::tenHistoryScope)enScope);
   data.setIndexStart(indexStart);
   data.setNumEntriesMax(numEntriesMax);
   data.setEnFormat((FCSWUPD_NS_FCSWUPD_T::tenHistoryFormat)enFormat);
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetUpdateHistoryDetailedRequest > payload(new FCSWUPD_NS_FCSWUPD::GetUpdateHistoryDetailedRequest(data));
   ETG_TRACE_COMP(("simHmiGetUpdateHistoryDetailedRequest START, enScope=%u start=%u, max=%u, enFormat=%u", 
                   enScope, indexStart, numEntriesMax, enFormat));
   onGetUpdateHistoryDetailedRequest(payload);
   
}

ETG_I_CMD_DEFINE((simHmiDeleteHistoryRequest, "simHmiDeleteHistoryRequestAll", ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiDeleteHistoryRequest, "simHmiDeleteHistoryRequestSinceFactoryResetOnly", ETG_I_CONST_ARG(1)))
void FcSwUpdSrv::simHmiDeleteHistoryRequest(bool sinceFactoryResetOnly)
{
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::DeleteHistoryRequestRequest > payload(new FCSWUPD_NS_FCSWUPD::DeleteHistoryRequestRequest());
   payload->setSinceFactoryResetOnly(sinceFactoryResetOnly);
   ETG_TRACE_COMP(("simHmiDeleteHistoryRequest START, sinceFactoryResetOnly=%u", sinceFactoryResetOnly));
   onDeleteHistoryRequestRequest(payload);
   ETG_TRACE_COMP(("simHmiDeleteHistoryRequest END"));
}


ETG_I_CMD_DEFINE((simHmiGetCacheDirectoryRequest, "simHmiGetCacheDirectoryRequestAcqAndClear", ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simHmiGetCacheDirectoryRequest, "simHmiGetCacheDirectoryRequestAcqOnly", ETG_I_CONST_ARG(1)))
ETG_I_CMD_DEFINE((simHmiGetCacheDirectoryRequest, "simHmiGetCacheDirectoryRequestRelease", ETG_I_CONST_ARG(2)))
void FcSwUpdSrv::simHmiGetCacheDirectoryRequest(tUInt action)
{
   FCSWUPD_NS_FCSWUPD_T::tenCacheDirRequest enDirRequest;
   switch(action) {
      case 0:
         enDirRequest = FCSWUPD_NS_FCSWUPD_T::tenCacheDirRequest__AcquireAndClear;
         break;
      case 1:
         enDirRequest = FCSWUPD_NS_FCSWUPD_T::tenCacheDirRequest__AcquireOnly;
         break;
      case 2:
         enDirRequest = FCSWUPD_NS_FCSWUPD_T::tenCacheDirRequest__ReleaseOnly;
         break;
      default:
         enDirRequest = FCSWUPD_NS_FCSWUPD_T::tenCacheDirRequest__AcquireAndClear;
         break;
   }   
   FCSWUPD_NS_FCSWUPD_T::trGetCacheDirectory data;
   data.setDirRequest(enDirRequest);
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::GetCacheDirectoryRequest > payload(new FCSWUPD_NS_FCSWUPD::GetCacheDirectoryRequest(data));
   ETG_TRACE_COMP(("simHmiGetCacheDirectoryRequest START action=%u", enDirRequest));
   onGetCacheDirectoryRequest(payload);
   ETG_TRACE_COMP(("simHmiGetCacheDirectoryRequest END"));
}


ETG_I_CMD_DEFINE((simHmiStoreHistoryToStickRequest, "simHmiStoreHistoryToStickRequest %u %u", tU8, tU8))
void FcSwUpdSrv::simHmiStoreHistoryToStickRequest(bool sinceFactoryReset, bool writeToAllSticks)
{
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::StoreHistoryToStickRequest > payload(new FCSWUPD_NS_FCSWUPD::StoreHistoryToStickRequest(sinceFactoryReset, writeToAllSticks));
   ETG_TRACE_COMP(("simHmiStoreHistoryToStickRequest START sinceFactoryReset=%u", sinceFactoryReset));
   ETG_TRACE_COMP(("simHmiStoreHistoryToStickRequest writeToAllSticks=%u", writeToAllSticks));
   onStoreHistoryToStickRequest(payload);
   ETG_TRACE_COMP(("simHmiStoreHistoryToStickRequest END"));
}

ETG_I_CMD_DEFINE((simHmiVerifyChecksumRequest, "simHmiVerifyChecksumRequest %u %117s", tUInt, ETG_I_STRING))
void FcSwUpdSrv::simHmiVerifyChecksumRequest(tUInt verifyType, char const *area)
{
  ETG_TRACE_COMP(("simHmiVerifyChecksumRequest START"));
  FCSWUPD_NS_FCSWUPD::tenVerifyType enVerifyType;
  std::string memArea(area);
  switch(verifyType) {
  case 0:
	  enVerifyType=FCSWUPD_NS_FCSWUPD_T::tenVerifyType__Fingerprint;
	  break;
  default:
	  enVerifyType=FCSWUPD_NS_FCSWUPD_T::tenVerifyType__Md5Sum;
  } // End switch

  FCSWUPD_NS_FCSWUPD_T::trVerifyChecksumRequest verifyRequest;
  verifyRequest.setArea(area);
  verifyRequest.setEnVerifyType(enVerifyType);

  const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::VerifyChecksumRequest > payload(new FCSWUPD_NS_FCSWUPD::VerifyChecksumRequest());
  payload->setVerifyRequest(verifyRequest);

  onVerifyChecksumRequest(payload);
  ETG_TRACE_COMP(("simHmiVerifyChecksumRequest END"));
}
ETG_I_CMD_DEFINE((simHmiRegisterBgLocksRequest, "simHmiRegisterBgLocksRequest %u %117s", tU32,ETG_I_STRING))
void FcSwUpdSrv::simHmiRegisterBgLocksRequest(tU32 lockRegisterMode,char const *bgLocks) 
{
   ETG_TRACE_COMP(("simHmiRegisterBgLocksRequest START"));
   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::RegisterBgLocksRequest > payload(new FCSWUPD_NS_FCSWUPD::RegisterBgLocksRequest());
   
   FCSWUPD_NS_FCSWUPD_T::trBgLocks registeredBglocks;
   std::vector<std::string>listregisteredBglocks;
   if(bgLocks)
   {
   std::set <std::string> locksList = swu::splitString(bgLocks,','); 
   std::copy(locksList.begin(), locksList.end(),std::back_insert_iterator<std::vector<std::string> >(listregisteredBglocks));
   }
   
   for(std::vector<std::string>::iterator it=listregisteredBglocks.begin();it!=listregisteredBglocks.end();it++)
   {
      ETG_TRACE_COMP(("simHmiRegisterBgLocksRequest lockname=%s",it->c_str()));
   }
   registeredBglocks.setLocks(listregisteredBglocks);
   
   FCSWUPD_NS_FCSWUPD::tenLockRegisterMode enLockRegisterMode;
   switch(lockRegisterMode){
      case 0:
         enLockRegisterMode=FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Overwrite;
      break;
      case 1:
         enLockRegisterMode=FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Add;
      break;
      case 2:
          enLockRegisterMode=FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Remove;
      break;
      default:
           enLockRegisterMode=FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Add;
      break;
   }
   
   ETG_TRACE_COMP(("simHmiRegisterBgLocksRequest lockRegisterMode=%u",(int)enLockRegisterMode));
   
   payload->setLocks(registeredBglocks);
   payload->setMode(enLockRegisterMode);

   onRegisterBgLocksRequest(payload);
   ETG_TRACE_COMP(("simHmiRegisterBgLocksRequest END"));
}

}
