#ifndef FCSWUPD_SPM_IF_H
#define FCSWUPD_SPM_IF_H

#include "asf/core/Proxy.h"
#include "SPM_CORE_FIProxy.h"

#include "util/swu_asfUtil.hpp"
#include "util/swu_memberList.hpp"
#include "util/swu_timer.h"
#include "main/fcswupd_component.h"
#include "util/fcswupd_types.hpp"

#define FCSWUPD_NS_SPM ::SPM_CORE_FI
#define FCSWUPD_NS_SPM_T ::spm_core_fi_types

#ifndef __SW_UPDATE_UNIT_TESTING__
#define AUTO_PROPERTY_SPM(PROPERTY) AUTO_PROPERTY_CCA_LOCAL(SpmIf, getProxy, PROPERTY, __LINE__)
#else
#define AUTO_PROPERTY_SPM(PROPERTY)
#endif

namespace fcswupdate {


/* messages from SPM */
/* properties */
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemStateStatus);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SubStatesStatus);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, CvmEventStatus);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, RestartSystemResult);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemModeResult);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, MapDownloadLockStateStatus);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, UpdateLockResult);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, UpdateLockStatesStatus);


struct Msg_SpmModeReached: public swu::Msg<Msg_SpmModeReached, FcSwUpdRoot>  {
    Msg_SpmModeReached(tenSystemMode enSystemMode_):enSystemMode(enSystemMode_) {};
    virtual tVoid vTrace();
    tenSystemMode enSystemMode;
  };


  class SpmIf
:
      public swu::Member<FcSwUpdRoot>,
    public swu::Singleton<SpmIf>,
    public FCSWUPD_NS_SPM::CvmEventCallbackIF,
    public FCSWUPD_NS_SPM::SystemModeCallbackIF,
    public FCSWUPD_NS_SPM::SystemStateCallbackIF,
    public FCSWUPD_NS_SPM::SubStatesCallbackIF,
    public FCSWUPD_NS_SPM::RestartSystemCallbackIF,
    public FCSWUPD_NS_SPM::MapDownloadLockStateCallbackIF, 
    public FCSWUPD_NS_SPM::UpdateLockCallbackIF,
    public FCSWUPD_NS_SPM::UpdateLockStatesCallbackIF {

     friend class swu::Singleton<SpmIf>;
     SpmIf();
     virtual ~SpmIf();

     struct Msg_WaitSpmTimer {
     };

  public:
    typedef enum
    {
      V850_MODE_UNDEFINED,
      V850_MODE_BOOTLOADER,
      V850_MODE_APPLICATION
    } V850MODE;

    virtual void vInit();
    virtual void vDeInit();

     virtual const char *getName() {
        return "SpmIf";
     }
     virtual void traceState();

     /* messages from SPM */
     /* properties */
     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemStateStatus);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemStateError);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SubStatesStatus);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SubStatesError);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, CvmEventStatus);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, CvmEventError);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, RestartSystemResult);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, RestartSystemError);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemModeResult);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, SystemModeError);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, MapDownloadLockStateStatus);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, MapDownloadLockStateError);
     
     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, UpdateLockResult);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, UpdateLockError);
     
     AUTO_DISPATCH_RES(FCSWUPD_NS_SPM, SPM_CORE_FIProxy, UpdateLockStatesStatus);
     AUTO_DISPATCH_ERROR(FCSWUPD_NS_SPM, SPM_CORE_FIProxy,UpdateLockStatesError);

#ifndef __SW_UPDATE_UNIT_TESTING__
     ::boost::shared_ptr< FCSWUPD_NS_SPM::SPM_CORE_FIProxy >getProxy() {
        return _spmProxy.getProxy();
     }
#endif

    // current dl-mode from spm:
    void vProcess(Msg_SubStatesStatus *pMsg);

    void vProcess(Msg_SystemStateStatus *pMsg);
    void vProcess(Msg_CvmEventStatus *pMsg) { /* todo */};
    void vProcess(Msg_SystemModeResult *pMsg);
    void vProcess(Msg_MapDownloadLockStateStatus *pMsg);
    void vProcess(Msg_UpdateLockResult *pMsg);
    void vProcess(Msg_UpdateLockStatesStatus *pMsg);

     void vProcess(swu::Msg_ProxyAvailability<FCSWUPD_NS_SPM::SPM_CORE_FIProxy, FcSwUpdRoot> *pMsg);

     // timer waiting for spm available
     tVoid vProcess(Msg_WaitSpmTimer *pMsg);

    void checkMapDownloadLockState();

    // interface to request dl-mode.
    // app will be notified via Msg_SpmModeReached when state is reached.
     SWU_MOCK_VIRTUAL void requestSystemMode(tenSystemMode enSystemMode);

    // syncronous interface to check if dl-mode is active
     SWU_MOCK_VIRTUAL tenSystemMode enGetSystemMode() const {
      return _modeReceivedFromSpm;
    }

    // we assume that spm-service is always there. if not we are in a system without spm
    bool isInStandAloneMode();

    // interface to reset the system
    void reboot();
    void rebootToRecoveryMode();
    void persistConfigData();

     // interface to switch to recovery/normal mode for next reboot
     void requestRecoveryMode(bool recovery);
     void requestLockResource(FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand reqCmd, std::string resName);

    V850MODE getV850Mode(void);
    V850MODE setV850Mode(V850MODE Mode);

    // interface to shut down the system
    void shutdown();

    bool isMapLockAvailableForSWU();
    bool isLockHoldBySwUpdate();
    void resetV850IfNeeded();
    void resetV850();

    bool clearResetCounter(void);

    void wupGetStartType();

     // for ttfis-cmd
    void simSpmRequestSystemMode(tU8 mode);
    void requestSystemModeDl(bool on);
     // simulate input from SPM
    void simSpmSystemModeResult();
    void simCheckForMapLock();

  // protected:
  //    SpmIf();

  private:
     void onSystemModeAck();
     void sendSytemModeRequestToSpm(tenSystemMode enSystemMode);
     void sendSpmModeReachedToClients(); 
     void persistData();    

     AUTO_PROPERTY_SPM(SystemState);
     AUTO_PROPERTY_SPM(SubStates);
     AUTO_PROPERTY_SPM(CvmEvent);
     AUTO_PROPERTY_SPM(MapDownloadLockState);
     AUTO_PROPERTY_SPM(UpdateLockStates);

     tenSystemMode _modeSentToSpm;
     tenSystemMode _modeReceivedFromSpm;
     tenSystemMode _modeRequestedByUser;
     tU16 _mapDownloadLockOwner;
     bool _bFirst;
     static const tU16 SPM_APPID_SWUPDATE = 0x00BC;
     static const tU16 SPM_APPID_INVALID = 0xFFFF;

#ifndef __SW_UPDATE_UNIT_TESTING__
     swu::SwUpdTimer<SpmIf, Msg_WaitSpmTimer> _waitSpmTimer;
     swu::ProxyAccess<FcSwUpdateComponent, FCSWUPD_NS_SPM::SPM_CORE_FIProxy> _spmProxy;
#endif
  };


}

#endif


