#include "sstream"
#include <iostream>
#include <fstream>
#include <set>
#include "config/fcswupd_config.hpp"
#include "util/swu_types.h"
#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_specialRelease.h"
#include "config/fcswupd_config.hpp"

#define ETG_I_FILE_PREFIX fcswupdate::SpecialRelease::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_SPECIAL_RELEASE_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_specialRelease.cpp.trc.h"
#endif


namespace fcswupdate {

void SpecialRelease::traceState() {
}

SpecialRelease::SpecialRelease():
   _initialized(false) {
   ETG_I_REGISTER_FILE();
}

SpecialRelease::~SpecialRelease() {
   ETG_I_UNREGISTER_FILE();
   vDeInit();
}

tVoid SpecialRelease::vInit()
{
   if (!_initialized) {
      Msg_NotifyCtrlResult::vSubscribe(this);
      std::string configPath=Config::instance()->cfg_SpecialReleasePathAndName.get();
      if (configPath.length()) {
         set(configPath);
      }
      ETG_TRACE_USR1(("SpecialRelease::vInit()"));
      _initialized=true;
   }
}

tVoid SpecialRelease::clear() {
   _current="";
   store();
   send();
}
tVoid SpecialRelease::vDeInit()
{
   if (_initialized) {
      ETG_TRACE_USR1(("SpecialRelease::vDeInit()"));
      _initialized=false;
   }
}

tVoid SpecialRelease::vProcess(Msg_NotifyCtrlResult *pMsg) {
   // forget about the special release, either it was a success or it failed, and we won't try it again.
   clear();
}


std::string const &SpecialRelease::get() {
   return _current;
}

bool SpecialRelease::send() {
   PropDevMgr *property=PropDevMgr::instance();
   std::map< std::string, trSourceInfo > &mapSources=property->access()._mapSources;

   // delete all sources that we mounted previously, i.e. all USB sources
   for (std::map< std::string, trSourceInfo >::iterator it=mapSources.begin();
        it!=mapSources.end(); /* no increment */)
   {
      trSourceInfo &info = it->second;
      if (info.owner == getName()) {
         mapSources.erase(it++);
      }
      else {
         ++it;
      }
   }


   if (swu::exists(_current)) {
      trSourceInfo &medium = mapSources[_current];
      ETG_TRACE_USR1(("SpecialRelease:adding mount:%s", _current.c_str()));
      medium.bDeleted=false;
      medium.path = swu::parentDirname(_current);
      medium.infoFile = swu::getFileNamePortion(_current);
      medium.bMounted = true;
      medium.enSourceType = tenSourceType_other;
      medium.owner = getName();
   } 
   else if (_current.length()) {
      ETG_TRACE_ERR(("SpecialRelease::send(): %s does not exist", _current.c_str()));
      return false;
   }

   // notify asyc to let initialization finalize before special release is received. 
   property->notifyLater();

   ETG_TRACE_USR1(("SpecialRelease::send(): END"));
   return true;

}

void SpecialRelease::store() {
   ETG_TRACE_USR1(("SpecialRelease::store(%s)", _current.c_str()));
   Config::instance()->cfg_SpecialReleasePathAndName.set(_current);
}

// temp store special release dir
bool SpecialRelease::set(std::string const &bxmlPathAndName, bool doStore)
{
   ETG_TRACE_USR4(("SpecialRelease::set():doStore=%u bxmlPathAndName=%s", 
                   doStore, bxmlPathAndName.c_str()));
   Config *cfg=Config::instance();
   std::string current=cfg->cfg_SpecialReleasePathAndName.get();
   ETG_TRACE_USR1(("SpecialRelease::set(%50s->%s): START", current.c_str(), bxmlPathAndName.c_str()));
   if (current.length() && current!=bxmlPathAndName) {
      // new setting differs from persitent setting, so delete persistent setting
      clear();
   }

   _current=bxmlPathAndName;
   if (doStore) {
      store();
   }

   return send();
}







}
