

#ifndef FCSWUPD_RESOURCEMANAGER_H_
#define FCSWUPD_RESOURCEMANAGER_H_

#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "util/fcswupd_types.hpp"
#include "util/swu_util.hpp"
#include "util/swu_stlUtil.hpp"
#include "util/swu_trace.h"

#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_spmIf.h"
#include "main/fcswupd_srv.h"

#include "ccaservice.h"

namespace fcswupdate {

//lock resources
#define CENTRAL_LOCK_TEXT              "UPDATE_LOCK_CENTRAL"
#define SDB_LOCK_TEXT                  "UPDATE_LOCK_SDB"
#define ADR_LOCK_TEXT                  "UPDATE_LOCK_ADR"
#define TESEO_LOCK_TEXT                "UPDATE_LOCK_TESEO"
#define SXM_LOCK_TEXT                  "UPDATE_LOCK_SXM"


class Msg_SystemModeReached;


 typedef enum {
      _enResourceState_invalid,
      _enResourceState_free,
      _enResourceState_use,
      _enResourceState_reserved,
      _enResourceState_locking,
      _enResourceState_locked
   } tenResourceState;


   struct SPMResourceData {
      tenResourceState state;
      tU16 ownerName;
      std::string lockName;
   };

   
   struct SPMUserResData {
      std::string lockName;
      std::vector<tU16> userList;
   };

   struct ResourceData {
      tenReqMode mode;
      std::string lockName;
   };

   struct find_LockName {
      std::string findName;
      find_LockName(std::string name) : findName(name) {}
      bool operator () (ResourceData refName) const {
         return refName.lockName == findName;
      }
   };

   struct find_User {
      tU16 val;
      find_User(tU16 input) : val(input) {}
      bool operator () (tU16 refVal) const {
         return refVal == val;
      }
   };



class spmOwnerInfoStack : public swu::stack<SPMResourceData> {
public:
   void traceStack();   
   bool searchElemByLock(std::string resName, SPMResourceData &data);
   bool searchElemByOwner(tU16 resName, SPMResourceData &data);
};

class spmUserInfoStack : public swu::stack<SPMUserResData> {		
public:
   void traceStack();   
   bool searchElemByLock(std::string resName, SPMUserResData &data);
   bool searchElemByUser(tU16 appId);
};

class reqInfoStack : public swu::stack<ResourceData> {
public:
   void traceStack();
   bool searchElem(std::string resName, ResourceData &data);
   void updateElem(ResourceData data);
   void removeElem(std::string resName);
};

  
struct Msg_ResourceManagerChanged: public swu::Msg< Msg_ResourceManagerChanged, FcSwUpdRoot > {
   Msg_ResourceManagerChanged() {};
   virtual tVoid vTrace();
};


class ResourceManager:public swu::Member<FcSwUpdRoot>, public swu::Singleton<ResourceManager> {
      friend class swu::Singleton<ResourceManager>;
public:
   ResourceManager();     
   virtual ~ResourceManager();
   virtual tVoid vInit();
   virtual tVoid vDeInit();
   virtual tVoid traceState();
   virtual const char *getName() {
      return "ResourceManager";
   }

      

private:  
   //contains SPM User resource.
   spmUserInfoStack _spmUsersRes;

   //contains SPM owner resource.
   spmOwnerInfoStack _spmOwnersRes;

   //actual requested resource
   reqInfoStack _reqUsersRes;

   //resource hmi wants to handle.
   swu::stack<std::string> _hmiReqOwnerRes;

   //input to be provided to HMI.
   swu::stack<std::string> _hmiRegRes;
   swu::stack<std::string> _hmiPendingRes;
   tBool _bIsReady;

  

   tVoid requestResource(tenReqMode enState, std::string resName);

   tVoid handleResourceChange();  

   bool isFcSwuInUserList();
   bool isSystemLockAvailableReg();

   tenResourceState getResourceState(FCSWUPD_NS_SPM_T::T_e8_UpdateLockState spmState);

   tenReqMode getNextReqMode(tenReqMode actualReqMode,tenResourceState enstate);

   tBool checkHmiWantToHandle(std::string resName);

   void vSendBgLockState(); 
    
public:  
   void configure(tenReqMode mode, std::string data="");
   void configure(tenReqMode mode, std::set<std::string> data);

   tVoid lockSWU(bool bForce = false); 
   void verify();  
   bool isReady() { return _bIsReady; }

   void handleSpmResouces(::std::vector<FCSWUPD_NS_SPM_T::T_SPM_UpdateLockState> spmRes);   
   tVoid releaseResources();

   tVoid vProcess(Msg_ResourceManagerChanged *pMsg);
   tVoid vProcess(Msg_RegisterBgLocksRequest *pMsg);
   tVoid vProcess(Msg_ApplyLockRequest *pMsg);
   tVoid vProcess(Msg_SystemModeReached *pMsg);
   
   void applyConfig() { 
      Msg_ResourceManagerChanged *msg=new Msg_ResourceManagerChanged;
      msg->bNotifyLater();
   };

   //simulate
   void printSPMUsersInfo();
   void printSPMOwnersInfo();
   void printReqUsersInfo();
   void printHMIReqRes();
   void simClearReqUser();
   void simRequestResource(const char *name, tU16 mode);
   void simverifyResource();
   void simAcquireSWURes();

      
};

}

#endif
