#include <cstring>
#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "fcswupd_propDevMgr.h"
#include "config/fcswupd_config.hpp"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_propDevMgr.cpp.trc.h"
#endif 


namespace fcswupdate {

void PropDevMgr::traceState()
{
   ETG_TRACE_USR1(("  PropDevMgr::traceState:"));

   for (std::map< std::string, trSourceInfo >::iterator iter = _msg._mapSources.begin();
        iter != _msg._mapSources.end(); ++iter) {
      trSourceInfo &medium=iter->second;
      ETG_TRACE_COMP(("  mountPoint=%s", medium.path.c_str()));
      ETG_TRACE_COMP(("    name=%s", medium.name.c_str()));
      ETG_TRACE_COMP(("    sourceType=%u", ETG_CENUM(tenSourceType, medium.enSourceType)));
      ETG_TRACE_COMP(("    bMounted=%u", medium.bMounted));
   }
   
   ETG_TRACE_USR1(("  _bHasCustomerUpdate=%u", _msg._bHasCustomerUpdate));
}

trSourceInfo PropDevMgr::getSourceInfo(std::string const &mediaPath) {
   trSourceInfo sourceInfo;
   sourceInfo.enSourceType=tenSourceType_other;
   std::string mediaRealPath=swu::realPath(mediaPath);
   bool found=false;
   ETG_TRACE_COMP(("PropDevMgr::mediaRealPath=%s", mediaRealPath.c_str()));
   for (std::map< std::string, trSourceInfo >::iterator iter = _msg._mapSources.begin();
        iter != _msg._mapSources.end(); ++iter) {
      trSourceInfo &medium=iter->second;
      std::string srcRealPath=swu::realPath(medium.path);
      ETG_TRACE_COMP(("PropDevMgr::srcRealPath=%s", srcRealPath.c_str()));
      if (std::strstr(mediaRealPath.c_str(), srcRealPath.c_str())) {
         ETG_TRACE_COMP(("PropDevMgr::srcRealPath matched, set source_type=%u", ETG_CENUM(tenSourceType, medium.enSourceType)));
         sourceInfo= medium;
         found=true;
         break;
      }
      
   }
   ETG_TRACE_COMP(("PropDevMgr::getSourceInfo(%30s)=%u found=%u", mediaPath.c_str(), ETG_CENUM(tenSourceType, sourceInfo.enSourceType), found));

   return sourceInfo;
}

//reverse compId get is present in campaignManager (getActualScomoCompId)
std::string PropDevMgr::getComponentId() {
  ETG_TRACE_USR4(("PropDevMgr-getComponentId"));

  std::string compId;
  for (std::map< std::string, trSourceInfo >::iterator iter = _msg._mapSources.begin();
     iter != _msg._mapSources.end(); ++iter){
     trSourceInfo &medium=iter->second;
     compId = medium.compId;
     if(!compId.empty()) {        
        break;
     }
  }

  if(Config::instance()->cfg_EnterEngineering.readAsBool() || compId.empty()) {
     compId = "FIRMWARE";
     return compId;
  }

  Config* cfg = Config::instance();
  if(compId == cfg->getCompId(cfg->cfg_ScomoFirmwareCompId)) {
     compId = "FIRMWARE";
  } else if (compId == cfg->getCompId(cfg->cfg_ScomoWelcomeSequenceCompId)) {
     compId = "WCS";
  } else if (compId == cfg->getCompId(cfg->cfg_ScomoVisualsCompId) 
             || compId == cfg->getCompId(cfg->cfg_ScomoSpecialVisualsCompId)) {
     compId = "SVS";
  }  else if (compId == cfg->getCompId(cfg->cfg_ScomoSNMCompId)) {
     compId = "SNM";
  } else if (compId == cfg->getCompId(cfg->cfg_ScomoCarVisualsCompId)) {
     compId = "CVS";
  } else if (compId == cfg->getCompId(cfg->cfg_ScomoRadioLogoCompId)) {
     compId = "RDL";
  }
  ETG_TRACE_USR2(("ComponentId-%s", compId.c_str()));

  return compId;
}
}

