#ifndef FCSWUPD_PRM_IF_H
#define FCSWUPD_PRM_IF_H

#include "util/swu_plugin.h"
#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"
//#include "main/fcswupd_component.h"




namespace fcswupdate {

struct Msg_PrmCallback;



class PrmIf: 
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<PrmIf>,
      public Gen3If
 {
      
   friend class swu::Singleton<PrmIf>;
 private:
    PrmIf();

public:
   virtual ~PrmIf();
   virtual char const *getName() {
      return "PrmIf";
   }

   virtual void traceState();

   virtual void vInit();
   virtual void vDeInit();




   void vProcess(Msg_PrmCallback *pMsg);


   const std::map< std::string, trSourceInfo > &getSources();

   bool testPrm();



   // simulate input from device manager
   void simPrmConnectionStatus(bool bUsbAvail, const char *pathUsb, bool bSdAvail, const char *pathSd);

private:
   bool bHasMediumCustomerUpdate(trSourceInfo const &sourceInfo);
   bool bHasXmlAndIsofile(std::string const &path);
   bool hasMediumFormatSupported(std::string const path);
   static tVoid prmCallbackMount_(tPCU32 pu32MediaChangeInfo,tPCU8 pu8Array);
   bool registerPrmCallbacks();
   tVoid prmCallbackMount(tPCU32 pu32MediaChangeInfo,tPCU8 pu8Array);
   /**returns the suffix of a CMS file. */
   static const ::std::string CMS_SUFFIX() { return "cms"; }

};

}



#endif
