#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "util/fcswupd_types.hpp"
#include "util/swu_globallog.h"

#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_prmIf.h"
#include <dirent.h>

#define ETG_I_FILE_PREFIX fcswupdate::PrmIf::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_PRM_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_prmIf.cpp.trc.h"
#endif 


namespace fcswupdate {


struct Msg_PrmCallback : public swu::Msg<Msg_PrmCallback, FcSwUpdRoot>
{
   Msg_PrmCallback(std::string const &mountPoint_, bool avail_) : mountPoint(mountPoint_), avail(avail_)
   {
   };
   virtual tVoid vTrace()
   {
      ETG_TRACE_USR1((" Msg_PrmCallback avail=%u mountPoint=%s", avail, mountPoint.c_str()));
   };

   std::string mountPoint;
   bool avail;
};




void PrmIf::traceState() {
}

PrmIf::PrmIf() {
   ETG_I_REGISTER_FILE();
}

PrmIf::~PrmIf() {
   ETG_I_UNREGISTER_FILE();
}

tVoid PrmIf::vInit()
{
   ETG_TRACE_USR1(("PrmIf::vInit()"));
   Msg_PrmCallback::vSubscribe(this);
   FcSwUpdCore::regIf<Gen3If>(this);
   registerPrmCallbacks();
}

tVoid PrmIf::vDeInit() {
   ETG_TRACE_USR1(("DistTotalizerPrj::vDeInit()"));
   FcSwUpdCore::deregIf<Gen3If>(this);
}

bool PrmIf::bHasXmlAndIsofile(std::string const &path){
   ETG_TRACE_USR2(("PrmIf::bHasXmlAndIsofile:path:%s", path.c_str()));
   bool  res = false;
   Config *cfg=Config::instance();
   std::string updateIsoFileName=cfg->cfg_UpdateIsoFileName.get();
   std::string updateIsoPathAndName=path + "/" + updateIsoFileName;
   ETG_TRACE_USR2(("PrmIf::bHasXmlAndIsofile: updateIsoPathAndName :%s", updateIsoPathAndName.c_str()));
   std::string relDir=path;
   struct dirent *dent=0;
   DIR *dir=opendir(relDir.c_str());
   if (dir)
   {
       while (0 != (dent = readdir(dir)))
       {
         char* filename = dent->d_name;
         // look for files with suffix "cms"
         if(swu::hasSuffix(filename, CMS_SUFFIX()))
         {
            if(swu::exists(updateIsoPathAndName))
            {
              ETG_TRACE_USR2(("PrmIf::bHasXmlAndIsofile: found both Bosch.cms and iso file in path:%s", path.c_str()));
              res =true;
              break;
            }
         }
         else
         {
            continue;
         }
       }
       closedir (dir);
   }
   return res;
}

bool PrmIf::hasMediumFormatSupported(std::string const path) {
   ETG_TRACE_USR4(("PrmIf::hasMediumFormatSupported START"));

   std::string supportedFormats = Config::instance()->cfg_SupportedUSBFormats.get();

   if(supportedFormats.empty()) {
      ETG_TRACE_USR3(("PrmIf::hasMediumFormatSupported, supported format is empty allow all formats"));
      return true;
   }
   ETG_TRACE_USR2(("PrmIf::hasMediumFormatSupported, supportedFormats:%s", supportedFormats.c_str()));

   std::string mediumFormat = swu::getMediaType(path);
   ETG_TRACE_USR2(("PrmIf::hasMediumFormatSupported, mediumFormat:%s", mediumFormat.c_str()));

   std::set<std::string> formatList = swu::splitString(supportedFormats);
   for(std::set<std::string>::iterator Iter = formatList.begin(); Iter != formatList.end(); Iter++) {
      if(0 == mediumFormat.compare(*Iter)) {
         ETG_TRACE_USR4(("PrmIf::hasMediumFormatSupported format supported"));
         return true;
      }
   }

   ETG_TRACE_USR4(("PrmIf::hasMediumFormatSupported format not supported"));
   return false;
}

bool PrmIf::bHasMediumCustomerUpdate(trSourceInfo const &sourceInfo) {
   bool res=false;
   //only if isofile and bosch.xml ,both are present inside usb stick more priority is given to isofile
   bool result = bHasXmlAndIsofile(sourceInfo.path);
   if(result == true)
   {
      ETG_TRACE_USR2(("Isofile is given more priority here"));
      return res;
   }
   ETG_TRACE_USR2(("Msg_DevManagerNotifyConnectionStatus: found new medium with metainfo2.txt:%s", sourceInfo.path.c_str()));
   std::list<TiXmlElement> relList;
   FcSwUpdCore::instance()->getReleaseList(relList, sourceInfo);
   if (1==relList.size()) {
      // only single-release stick is appropriate for customer-update
      TiXmlElement &overallSection=*(relList.begin());
      if (overallSection.FirstChildElement("CUSTUPDATE_SECTION")) {
         res=true;
      }
   }
   return res;
}





void PrmIf::vProcess(Msg_PrmCallback *pMsg)
{
   ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): START"));
   ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): avail=%u mountPoint=%s", pMsg->avail, pMsg->mountPoint.c_str()));
   swu::LOG_INTERFACE("Msg_PrmCallback: avail=%u mountPoint=%s", pMsg->avail, pMsg->mountPoint.c_str());

   bool isSDCard = false;

   if(pMsg->avail)
   {
      char filename[OSAL_C_U32_MAX_PATHLENGTH + 1];
      strncpy(filename, "/dev/media/", OSAL_C_U32_MAX_PATHLENGTH);
      strncat(filename, pMsg->mountPoint.c_str(), OSAL_C_U32_MAX_PATHLENGTH - strlen(filename));
      OSAL_tIODescriptor handle = OSAL_IOOpen(filename, OSAL_EN_READONLY);
      if(handle == OSAL_ERROR)
      {
         ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): Can't open Device \'%s\'", filename));
         pMsg->avail = false; // CHECKME: Ask Peter if this is ok
      }

      OSAL_trIOCtrlCardState cardstate;
      if(OSAL_s32IOControl(handle, OSAL_C_S32_IOCTRL_CARD_STATE, (intptr_t)&cardstate) == OSAL_OK)
      {
         ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): Seems to be a SDCard"));
         isSDCard = true;
      }
      else
      {
         ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): Does NOT seem to be a SDCard"));
      }

      OSAL_s32IOClose(handle);
   }

   PropDevMgr *property=PropDevMgr::instance();
   std::map< std::string, trSourceInfo > &mapSources=property->access()._mapSources;

   std::map< std::string, trSourceInfo >::iterator iter=mapSources.find(pMsg->mountPoint);
   if(iter != mapSources.end())
   {
      trSourceInfo &info = iter->second;
      if (info.owner==getName()) {
         info.bDeleted = true;
         info.bNew = false;
      }
   }

   //bool bMounted = (device.getDeviceConnectStatus() == FCSWUPD_NS_DEVMGR_T::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED);
   bool bMounted = pMsg->avail;
   if(pMsg->mountPoint.size() && bMounted)
   {
      ETG_TRACE_USR2(("dev:"));
      ETG_TRACE_USR2(("\tMountPoint:%s", pMsg->mountPoint.c_str()));
      ETG_TRACE_USR2(("\tisSDCard:%d", isSDCard));

      trSourceInfo &medium = mapSources[pMsg->mountPoint];

      medium.bDeleted = false;
      medium.path = std::string("/dev/media/") + pMsg->mountPoint;
      medium.owner=getName();
      if(isSDCard)
      {
         medium.enSourceType = tenSourceType_SD;
         medium.name = "SD";
      }
      else //if(...)      // CHECKME: Notification should be for SD Cards and USB only, so no further tests required (and hard to do)
      {
         medium.enSourceType = tenSourceType_USB;
         medium.name = "USB";
         medium.bHasSupportedFormatType=hasMediumFormatSupported(pMsg->mountPoint);
      }

      if(!medium.bMounted)
      {
         // todo: check new source for customer-update
         medium.bNew = true;
         medium.bHasCustomerUpdate=bHasMediumCustomerUpdate(medium);
      }
      medium.bMounted = bMounted;

      ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback sourceType:%u", ETG_CENUM(tenSourceType, medium.enSourceType)));
    }

   property->access()._bHasCustomerUpdate = false;
   iter= mapSources.find(pMsg->mountPoint);
   if(iter != mapSources.end())
   {
      trSourceInfo &medium = iter->second;
      if(medium.bDeleted)
      {
         // todo: check if source is in use and handle problem
         ETG_TRACE_USR1(("Found deleted device %s", medium.path.c_str()));
         mapSources.erase(iter++);
      }
      else if(medium.bHasCustomerUpdate)
      {
         property->access()._bHasCustomerUpdate = true;
      }
   }
   ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): _bHasCustomerUpdate=%u", property->access()._bHasCustomerUpdate));

   // todo: here we have to check, if a new device arrived and send a message for possibly existing parser/configurator to make them check for customer-update.
   // if device disappears we have to notify active configurators/ctrl.
   property->iNotify(this);


   ETG_TRACE_USR1(("PrmIf::vProcess(Msg_PrmCallback): END"));
}





OSAL_tIODescriptor _osalPrmHandle;
OSAL_trNotifyDataExt2 _rNotifyData_Mount;

tVoid PrmIf::prmCallbackMount_(tPCU32 pu32MediaChangeInfo, tPCU8 pu8Array)
{
   PrmIf::instance()->prmCallbackMount(pu32MediaChangeInfo, pu8Array);
}




tVoid PrmIf::prmCallbackMount(tPCU32 pu32MediaChangeInfo, tPCU8 pu8Array)
{
   static std::map<std::string, bool> mediaStateMap;
   tU16 u16TriggerType = 0;
   tU16 u16TriggerValue = 0;
   //tBool bFound = FALSE;

   ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): START"));

   if(!pu8Array || !pu32MediaChangeInfo)
   {
      ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): invalid input: pu32MediaChangeInfo=0x%08x pu8Array=0x%08x", pu32MediaChangeInfo, pu8Array));
      ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): END"));
      return;
   }

   bool avail = false;
   std::string mountPoint = (char const *)pu8Array;
   if(!mountPoint.size())
   {
      ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): invalid input: mountPoint is an empty string"));
      ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): END"));
      return;
   }

   u16TriggerType =static_cast<tU16> (*pu32MediaChangeInfo >> 16);
   u16TriggerValue = (*pu32MediaChangeInfo & 0xFFFF);
   ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): u16TriggerType=0x%x,u16TriggerValue=0x%x   mntpnt=%s", u16TriggerType, u16TriggerValue, mountPoint.c_str()));
   switch(u16TriggerType)
   {
   case OSAL_C_U16_NOTI_MEDIA_CHANGE:
      switch(u16TriggerValue)
      {
      case OSAL_C_U16_DATA_MEDIA:
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): OSAL_C_U16_NOTI_MEDIA_CHANGE->OSAL_C_U16_DATA_MEDIA"));
         break;
      case OSAL_C_U16_MEDIA_EJECTED:
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): OSAL_C_U16_NOTI_MEDIA_CHANGE->OSAL_C_U16_MEDIA_EJECTED"));
         break;
      default:
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): UNUSED STATE: OSAL_C_U16_NOTI_MEDIA_CHANGE u16TriggerValue=0x%x", u16TriggerValue));
         break;
      }
      break;

   case OSAL_C_U16_NOTI_MEDIA_STATE:
      switch(u16TriggerValue)
      {
      case OSAL_C_U16_DEVICE_NOT_READY:
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): OSAL_C_U16_NOTI_MEDIA_STATE->OSAL_C_U16_DEVICE_NOT_READY"));
         break;
      case OSAL_C_U16_DEVICE_READY:
         avail = true;
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): OSAL_C_U16_NOTI_MEDIA_STATE->OSAL_C_U16_DEVICE_READY"));
         break;
      default:
         ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): UNUSED STATE: OSAL_C_U16_NOTI_MEDIA_STATE u16TriggerValue=0x%x", u16TriggerValue));
         break;
      }
      break;

   default:
      break;
   }

   bool oldAvail = mediaStateMap[mountPoint];
   ETG_TRACE_COMP(("PrmIf::prmCallbackMount(): avail: %i, oldAvail: %i", (int)avail, (int)oldAvail));
   if(oldAvail != avail)
   {
      Msg_PrmCallback *msg = new Msg_PrmCallback(mountPoint, avail);
      SWU_ASSERT_RETURN(msg);
      msg->bNotifyLater();
      msg = 0;
      mediaStateMap[mountPoint] = avail;
   }

   ETG_TRACE_ERR(("PrmIf::prmCallbackMount(): END"));
}



bool PrmIf::registerPrmCallbacks()
{
   ETG_TRACE_ERR(("registerPrmCallbacks: START"));

#ifndef VARIANT_S_FTR_ENABLE_G4G
   OSAL_pvMemorySet(&_rNotifyData_Mount, 0x00, sizeof(_rNotifyData_Mount));
   _rNotifyData_Mount.pCallbackExt2 = (OSALCALLBACKFUNCEXT2)prmCallbackMount_;
   _rNotifyData_Mount.u16AppID = OSAL_C_U16_DOWNLOAD_APPID;
   _rNotifyData_Mount.ResourceName = "/dev/media";
   _rNotifyData_Mount.u16NotificationType = OSAL_C_U16_NOTI_MEDIA_STATE | OSAL_C_U16_NOTI_MEDIA_CHANGE;
   _rNotifyData_Mount.u8Status = 0;
   _osalPrmHandle = OSAL_IOOpen("/dev/prm", OSAL_EN_READONLY);
   if(_osalPrmHandle == OSAL_ERROR)
   {
      ETG_TRACE_ERR(("OSAL_IOOpen(/dev/prm failed"));
   }
   tS32 s32RetVal = OSAL_s32IOControl(_osalPrmHandle, OSAL_C_S32_IOCTRL_PRM_REG_NOTIFICATION_EXT2, (intptr_t)&_rNotifyData_Mount);
   if(OSAL_ERROR == s32RetVal)
   {
      ETG_TRACE_ERR(("registerPrmCallbacks: OSAL_s32IOControl failed"));
   }
#endif
   return true;
}

ETG_I_CMD_DEFINE((testPrm, "testPrm"))bool PrmIf::testPrm()
{
#ifndef FCSWUPDATE_USE_PRM
   ETG_TRACE_ERR(("testPrm START"));
   bool res = registerPrmCallbacks();
   ETG_TRACE_ERR(("testPrm END, res=%u", res));
   return res;
#endif //FCSWUPDATE_USE_PRM
}

}
