#include "util/fcswupd_types.hpp"
#include "util/swu_msg.hpp"

#ifndef FCSWUPD_MOD_VERSION_IF_H
#define FCSWUPD_MOD_VERSION_IF_H


namespace fcswupdate {



class InstalledModInfo {
public:
   InstalledModInfo(std::string const &modName, bool doRead=true);

   std::string getPartition() { 
      return _kvPairs["partition"];
   }
   std::string getSubDir() { 
      return _kvPairs["path"];
   }
   std::string getVersion();

   bool read();
   bool isMounted() { return false;} // todo
   bool isValid() const {return _valid;};

   void setVal(std::string key, std::string val);
   void write();


private:
   std::map<std::string, std::string> _kvPairs;
   std::string _modName;
   std::string _fileNameBase;
   static std::string _installedDir;
   static std::string _activationsDir;
   bool _valid;
};



/*
  Interface to get access to the version of a module.
  
 */
class ModVersionIf;
/*
  message broadcasted by a ModVersionIf in case of a version change.
 */



class ModVersionIf {
public:
   typedef FcSwUpdRoot compType;
   ModVersionIf(std::string const &name, bool isOrphan_=true):
      _name(name),
      _isOrphan(isOrphan_), 
      _versionOk(false),
      _boschVersionOk(false)
 {
   }
   virtual ~ModVersionIf(){
      dereg();
   }
   std::string const &getModName() {
      return _name;
   }
   std::string getVersion();
   virtual std::string getBoschVersion();

   virtual std::string readBoschVersion()=0;
   virtual std::string readVersion() { 
      // default-behavior: but use the bosch version
      // (and mark version as Ok) 
      _versionOk=true; return getBoschVersion(); 

};
   
   virtual bool operator<(std::string const &comp){
	return	(getVersion().compare(comp.c_str()) < 0) ? true : false;
   }
   virtual bool operator!=(std::string const &comp){
	return ((*this < comp) || (comp.compare(getVersion().c_str())));
   }   

   //  register ModVersionIf at system-data
   bool reg();
   //  deregister ModVersionIf at system-data
   void dereg();
   /* default: memory is owned by someone else.
      Memory will not be freed by destructor of system-data
   */
   virtual bool isOrphan() {
      return _isOrphan;
   }

   virtual void invalidate(){
      _versionOk=false;
      _boschVersionOk=false;
      
   };

protected:
   virtual std::string fetchVersion(std::string processCmd);
   //  utility of ModVersionIf to notify listeners
private:
   // name of the module e.g. IMX/MAIN/APPLICATION
   std::string const _name;
   bool _isOrphan;
   bool _versionOk;
   bool _boschVersionOk;
   std::string _version;
   std::string _boschVersion;
};


/*
  default-implemtation of ModVersionIf using last installed version of module as current version
 */
class ModVersionDefaultIf:public ModVersionIf {
public:
   virtual std::string readBoschVersion();
   

   static ModVersionDefaultIf *create(std::string const &name);
   /*
     System-data shall take custody of this class and delete it on deregistration.
    */
   virtual bool isOrphan() {
      return true;
   }
   virtual void invalidate(){
      ModVersionIf::invalidate();
      _modInfo.read();
   };
   virtual void refresh(){_modInfo.read();};


private:
   ModVersionDefaultIf(std::string const &name);
   InstalledModInfo _modInfo;
};

}

#endif
