#ifndef FCSWUPD_PRM_IF_H
#define FCSWUPD_PRM_IF_H

#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"
#include "util/swu_isoContainer.h"
#include "main/fcswupd_component.h"


namespace fcswupdate {


class IsoMounter: 
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<IsoMounter>
 {
      
   friend class swu::Singleton<IsoMounter>;
 private:
    IsoMounter();

public:
   virtual ~IsoMounter();
   virtual char const *getName() {
      return "IsoMounter";
   }

   virtual void traceState();

   virtual void vInit();
   virtual void vDeInit();




   void vProcess(Msg_NotifyDevManagerChanged *pMsg);



private:
    bool addIsoMount(trSourceInfo const & sourceInfo, trSourceInfo & isoSourceInfo, std::string const &);
    void removeIsoMount(trSourceInfo & isoSourceInfo);
   
    tUInt _numIsoMountAttemps;
    std::map<std::string, swu::IsoContainer *> _mapIsoContainers;
};

}



#endif
