/*
 * fcswupd_hmisettings.cpp
 *
 *  Created on: May 31, 2016
 *      Author: vri7cob
 */

#include <dirent.h>
#include "fcswupd_hmisettings.h"
#include "config/fcswupd_config.hpp"
#include "fcswupd_mainMessages.hpp"
#include "util/swu_filesystem.h"
#include "util/swu_robustFile.h"
#include "util/swu_execCommand.h"

#define ETG_I_FILE_PREFIX fcswupdate::hmisettings::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_hmisettings.cpp.trc.h"
#endif

namespace fcswupdate {

hmisettings::hmisettings(){
   _pLangSettings = NULL;
   _psettingsroot = NULL;
   _pLangSettings = NULL;   
}

hmisettings::~hmisettings() {
	// TODO Auto-generated destructor stub
}

tVoid hmisettings::vDeInit() {
  ETG_I_UNREGISTER_FILE();
}

tVoid hmisettings::vInit() {
  ETG_TRACE_USR1(("hmiSettings::vInit"));
  vPrepareHMISettings();
  ETG_I_REGISTER_FILE();
}


tVoid hmisettings::vPrepareHMISettings() {
  ETG_TRACE_USR1(("vPrepareHMISettings"));

  if(Config::instance()->cfg_MultiLanguageSupportStatus.get() &&
     Config::instance()->cfg_EnterFullOperation.readAsBool()) {
    vDeleteAndCreateHMIDir();

    TiXmlDeclaration* settingsdecl = new TiXmlDeclaration( "1.0", "", "" );
    _settingsdoc.LinkEndChild( settingsdecl );
    _psettingsroot = new TiXmlElement( "HMISettings" );
    _settingsdoc.LinkEndChild(_psettingsroot);

    _pLangSettings = new TiXmlElement( "LANGUAGESETTINGS" );
    _psettingsroot->LinkEndChild( _pLangSettings );
  }
  else if(Config::instance()->cfg_EnterFullOperation.readAsBool()){
    ETG_TRACE_USR4(("Deleting the HMI Folder, Since MutiLanguage Support is not Needed"));
    std::string strOrginalPath = Config::getHMISettingsPath();
    bool hmi_dir_exists;
    if(swu::exists(strOrginalPath, hmi_dir_exists)){
      if(hmi_dir_exists){
        std::string strDirName = strOrginalPath.substr(0, strOrginalPath.size()-1);
        swu::removeDirectoryRecursive(strDirName);
      }
    }
  }
  else {
    ETG_TRACE_USR4(("Multi Language is not enabled & Not in Normal Mode to Perform HMI Settings"));
  }

}

tVoid hmisettings::vStoreHMISettings() {
  ETG_TRACE_USR1(("vStoreHMISettings"));

  if(Config::instance()->cfg_MultiLanguageSupportStatus.get() &&
     Config::instance()->cfg_EnterFullOperation.readAsBool()) {
    ETG_TRACE_USR4(("Storing the HMI Settings in Persistent Partition"));
    vUpdateTargetSettings();
    vUpdateDefaultSettings();
    bDohmiSettingsFilepersist();
  }
  else {
    ETG_TRACE_USR4(("Multi Language is not supported"));
  }
}

tVoid hmisettings::vUpdateTargetSettings() {
  ETG_TRACE_USR1(("vUpdateTargetSettings"));

  bool isbackGndImageReq = false;
  std::string strImagesrc = Config::instance()->cfg_ImageLocInNormalMode.get();
  std::string strbackgndImagedest = Config::getHMISettingsPath();
  std::string strbackgndImageName = "";

  if(!strImagesrc.empty()){
     strbackgndImagedest = strbackgndImagedest + "bg";
     if(!swu::exists(strbackgndImagedest)) {        
        swu::makeDirectoryRecursive(strbackgndImagedest, 0700);
     }
        strbackgndImagedest = strbackgndImagedest + "/";
    isbackGndImageReq = true;
  }

  TiXmlElement*	pTargetSettings;
  pTargetSettings = new TiXmlElement("TARGETSETTINGS");
  _psettingsroot->LinkEndChild(pTargetSettings);

  TiXmlElement* Variant = new TiXmlElement("VARIANTTYPE");
  tU32 VariantDisplay = Config::instance()->cfg_CmVariantOem.get();
  switch(VariantDisplay){
  case NISSAN_VARIANT_OEM:
    Variant->LinkEndChild( new TiXmlText("Nissan"));
    strImagesrc = strImagesrc + "Nissan/";
    strbackgndImageName = "Nissan.png";
    break;
  case RENAULT_VARIANT_OEM:
    Variant->LinkEndChild( new TiXmlText("Renault"));
    strImagesrc = strImagesrc + "Renault/";
    strbackgndImageName = "Renault.png";
    break;
  case SUZUKI_VARIANT_OEM:
    Variant->LinkEndChild( new TiXmlText("SUZ-SLN"));
    break;
  case PSA_VARIANT_OEM:
    Variant->LinkEndChild( new TiXmlText("PSA"));
    break;
  case INFINITI_VARIANT_OEM:
    Variant->LinkEndChild( new TiXmlText("Infiniti"));
    strImagesrc = strImagesrc + "Infiniti/";
    strbackgndImageName = "Infiniti.png";
    break;
  default:
    Variant->LinkEndChild( new TiXmlText("Unknown"));
    isbackGndImageReq = false;
    break;
  }
  pTargetSettings->LinkEndChild(Variant);

  TiXmlElement* DisplayOrientation = new TiXmlElement("DISPLAYORIENTATION");

  tU32 Orientation = Config::instance()->cfg_CmVariantDisplayType.get();
  if(Orientation == LANDSCAPE_ORIENTATION) {
    DisplayOrientation->LinkEndChild( new TiXmlText("Landscape"));
    strImagesrc = strImagesrc + "Landscape/";
  }
  else if(Orientation == PORTRAIT_ORIENTATION) {
    DisplayOrientation->LinkEndChild( new TiXmlText("Portrait"));
    strImagesrc = strImagesrc + "Portrait/";
  }
  else {
    DisplayOrientation->LinkEndChild( new TiXmlText("Unknown"));
    isbackGndImageReq = false;
  }
  pTargetSettings->LinkEndChild(DisplayOrientation);

  if(isbackGndImageReq) {
    std::string strbackgndImagesrc = strImagesrc + "bg/";
    strbackgndImagesrc = strbackgndImagesrc + strbackgndImageName;
    strbackgndImagedest = strbackgndImagedest + strbackgndImageName;

    ETG_TRACE_USR4(("Image Copy File! %100s --> %s", strbackgndImagesrc.c_str(), strbackgndImagedest.c_str()));
    if(swu::copyFile(strbackgndImagesrc, strbackgndImagedest)) {
      ETG_TRACE_USR4(("Background image copy is successful"));
    }
    else {
      ETG_TRACE_USR4(("Background image copy is unsuccessful"));
    }

    TiXmlElement* ImagePath = new TiXmlElement("BACKGNDIMAGELOC");
    ImagePath->LinkEndChild(new TiXmlText(strbackgndImagedest.c_str()));
    pTargetSettings->LinkEndChild(ImagePath);
  }

  std::string strProgressBarPath = strImagesrc + "progressbar/";
  ETG_TRACE_USR4(("Progress Bar Path:%s", strProgressBarPath.c_str()));

  Msg_CopyProgressBarElements msg(strProgressBarPath);
  notify(msg);
}

tVoid hmisettings::vSetProgressBarPath(std::string pbarpath) {
  ETG_TRACE_USR1(("vSetProgressBarPath"));

  TiXmlElement *pTargetSettings = _psettingsroot->FirstChildElement("TARGETSETTINGS");

  TiXmlElement* PBARImagePath = new TiXmlElement("PBARIMAGELOC");
  PBARImagePath->LinkEndChild(new TiXmlText(pbarpath.c_str()));
  pTargetSettings->LinkEndChild(PBARImagePath);
}

tVoid hmisettings::vUpdateLanguageName(std::string strLangName) {
  ETG_TRACE_USR1(("vUpdateLanguageName"));

  ETG_TRACE_USR4(("Language:%s", strLangName.c_str()));

  //Remove the child if exist
  TiXmlElement* childElem ;
  childElem = _pLangSettings->FirstChildElement("LANGUAGENAME");
  if(childElem)
    {
      if(strLangName.compare(childElem->GetText()) == 0)
        return;
      else
        _pLangSettings->RemoveChild(childElem);
    }

  TiXmlElement* pTransLang = new TiXmlElement( "LANGUAGENAME" );

  ETG_TRACE_USR4(("Language path:%s", Config::instance()->cfg_MultiLangLocInNormalMode.get().c_str()));
  ETG_TRACE_USR4(("Image path:%s", Config::instance()->cfg_ImageLocInNormalMode.get().c_str()));

  if(!Config::instance()->cfg_MultiLangLocInNormalMode.get().empty() && vCopyFontFile(strLangName)) {
    ETG_TRACE_USR4(("Copy Font File is Success"));
    pTransLang->LinkEndChild( new TiXmlText(strLangName.c_str() ));
  }
  else {
    ETG_TRACE_USR4(("Copy Font File is Failure"));
    pTransLang->LinkEndChild( new TiXmlText("ENGLISH_UK"));
  }
  _pLangSettings->LinkEndChild( pTransLang );
}

tVoid hmisettings::vUpdateDefaultSettings() {
  ETG_TRACE_USR1(("vUpdateDefaultSettings"));

  std::string strDefaultLangName("English_UK");

  //Remove the child if exist
  TiXmlElement* childElem ;
  childElem = _pLangSettings->FirstChildElement("DEFAULTLANGUAGENAME");
  if(childElem)
    _pLangSettings->RemoveChild(childElem);

  //add the child
  TiXmlElement* pTransLang = new TiXmlElement( "DEFAULTLANGUAGENAME" );
  pTransLang->LinkEndChild( new TiXmlText(strDefaultLangName.c_str() ));
  _pLangSettings->LinkEndChild( pTransLang );
}

tBool hmisettings::vCopyFontFile(std::string strLangName) {
  ETG_TRACE_USR1(("vCopyFontFile"));

  tBool bReturn = false;

  std::string srcFontFilePath("");
  srcFontFilePath.assign(Config::instance()->cfg_MultiLangLocInNormalMode.get());
  srcFontFilePath.append(strLangName);

  std::string destFontFilePath("");
  destFontFilePath.assign(Config::getHMISettingsPath());

  vDeleteAndCreateHMIDir();


  if(swu::exists(srcFontFilePath)) {
    struct dirent *dent=0;
    DIR *dir=opendir(srcFontFilePath.c_str());

    while (0 != (dent = readdir(dir))) {
      char* filename = dent->d_name;
      if(swu::hasSuffix(filename, TTF_SUFFIX()) || swu::hasSuffix(filename, OTF_SUFFIX()) ){
        std::string tempsrcPath = srcFontFilePath + "/" + filename;
        std::string tempdestPath = destFontFilePath + filename;
        ETG_TRACE_USR4(("Font Copy File! %100s --> %s", tempsrcPath.c_str(), tempdestPath.c_str()));
        if(swu::copyFile(tempsrcPath, tempdestPath)){

          ETG_TRACE_USR4(("Font File Copy is Suceess"));

          //Remove Child
          TiXmlElement* childElem ;
          childElem = _pLangSettings->FirstChildElement("FONTFILEPATH");
          if(childElem)
            _pLangSettings->RemoveChild(childElem);

          //Add Child
          TiXmlElement* pFontFilePath = new TiXmlElement( "FONTFILEPATH");
          pFontFilePath->LinkEndChild( new TiXmlText(tempdestPath.c_str() ));
          _pLangSettings->LinkEndChild( pFontFilePath );

          bReturn = true;
        }
      }
      else if(swu::hasSuffix(filename, XML_SUFFIX())){
        std::string tmpsrcPath = srcFontFilePath + "/" + filename;
        std::string tmpdestPath = destFontFilePath + filename;
        ETG_TRACE_USR4(("Translation Copy File! %100s --> %s", tmpsrcPath.c_str(), tmpdestPath.c_str()));
        if(swu::copyFile(tmpsrcPath, tmpdestPath)) {
          ETG_TRACE_USR4(("Translation File Copy is Success"));

          //Remove Child
          TiXmlElement* childElem ;
          childElem = _pLangSettings->FirstChildElement("TRANSFILEPATH");
          if(childElem)
            _pLangSettings->RemoveChild(childElem);

          //Add Child
          TiXmlElement* pTransFilePath = new TiXmlElement( "TRANSFILEPATH");
          pTransFilePath->LinkEndChild( new TiXmlText(tmpdestPath.c_str() ));
          _pLangSettings->LinkEndChild( pTransFilePath );


          bReturn = true;
        }
      }
    }
  }

  return bReturn;
}


bool hmisettings::bDohmiSettingsFilepersist() {

  ETG_TRACE_USR1(("hmisettings::bDohmiSettingspersist"));

  swu::RobustFile rf(Config::getHMISettingsFile());
  SWU_ASSERT_RETURN_FALSE(rf.init());
  bool status = _settingsdoc.SaveFile(Config::getHMISettingsFile().c_str());
  SWU_ASSERT_RETURN_FALSE(rf.sync());

  return status;
}

tVoid hmisettings::vDeleteAndCreateHMIDir()
{
  ETG_TRACE_USR1(("vDeleteAndCreateHMIDir"));

  std::string strOrginalPath = Config::getHMISettingsPath();
  bool hmi_dir_exists;
  if(swu::exists(strOrginalPath, hmi_dir_exists)){
    if(hmi_dir_exists){
      std::string strDirName = strOrginalPath.substr(0, strOrginalPath.size()-1);
      swu::removeDirectoryRecursive(strDirName);
    }
  }
  swu::makeDirectoryRecursive(strOrginalPath, 0700);
}

ETG_I_CMD_DEFINE((simDohmiSettingsFilepersist, "simDohmiSettingsFilepersist"))
void hmisettings::simDohmiSettingsFilepersist() {
   ETG_TRACE_COMP(("simDohmiSettingsFilepersist START"));
   bDohmiSettingsFilepersist();
   ETG_TRACE_COMP(("simDohmiSettingsFilepersist END"));
}


} /* namespace fcswupdate */
