#ifndef FCSWUPD_HISTORY_HPP
#define FCSWUPD_HISTORY_HPP

#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include <string>

class TiXmlElement;
class TiXmlDocument;

namespace fcswupdate {

class CtrlProgressSection;

/**
 * The History is NOT thread safe yet, keep this in mind!
 */
class History: public swu::Member<FcSwUpdRoot>, public swu::Singleton<History> {
   friend class swu::Singleton<History>;
private:
   History();

public:

   virtual ~History();

   virtual tVoid vInit();
   tVoid setHistoryFileName(std::string FileName);

   virtual const char *getName() { return "History"; }

   int getNumReleases() const;
   int getNumUpdates() const;
   int getNumUpdatesAfterReset() const;
   const TiXmlElement *getReleases() const { return _releases; }
   const TiXmlElement *getInitialRelease() { return getSpecialRelease("INITIAL"); }
   const TiXmlElement *getFirstUsbRelease() { return getSpecialRelease("FIRST_USB"); }
   const TiXmlElement *getFirstOtaRelease() { return getSpecialRelease("FIRST_OTA"); }
   const TiXmlElement *getFirstUsbReleaseSinceReset() { return getSpecialRelease("FIRST_USB_AFTER_RESET"); }
   const TiXmlElement *getFirstOtaReleaseSinceReset() { return getSpecialRelease("FIRST_OTA_AFTER_RESET"); }
   const TiXmlElement *getInitialReleaseSinceReset() { return getSpecialRelease("INITIAL_AFTER_RESET"); }

   virtual void traceState();

   bool store(const char *path, bool sinceFactoryReset);

   bool addRelease(CtrlProgressSection const *progressSection);
   void reset();
   void clear();
   void updateDeviceProductionTime();
  
private:
   void setSpecialRelease(std::string relType, TiXmlElement *release, bool force=false);

   static std::string getPersistentHistoryFileName();
   TiXmlElement *getLastRelease() const;
   void convertToInitialRelease(TiXmlElement *release, bool isClear=false);
   TiXmlElement *createInitialRelease();
   TiXmlElement *getChildForced(TiXmlElement *parent, std::string childName);
   TiXmlElement *getSpecialRelease(std::string relType);


   bool persist();
   bool timestamp(TiXmlElement *release);

private:
   static const tInt k_MAX_ENTRIES = 20;

   bool _initialized;
   TiXmlDocument _doc;
   TiXmlElement *_root;
   TiXmlElement *_releases;
   TiXmlElement *_specialReleases;

   std::string _historyFileName;
   
};

}

#endif
