#ifndef FCSWUPD_DAIGLOG_H
#define FCSWUPD_DAIGLOG_H

#include "util/swu_memberList.hpp"
#include "main/fcswupd_mainMessages.hpp"

namespace fcswupdate {




// Base-class to handle trouble-code item
class DiagLogItem {
   friend class DiagLog;
public:
   typedef enum {
      enResultCode_Passed=0,
      enResultCode_Failed=1,
      enResultCode_NoResult=2,
      enResultCode_PassedDiagnostic=3,
      enResultCode_FailedDiagnostic=4,
      enResultCode_NoResultDiagnostic=5,
      enResultCode_Disable=6,
      enResultCode_Enable=7,
      enResultCode_Invalid=10
   }tenResultCode;

   DiagLogItem(char const *name="unknown"):
      _name(name),
      _itc(0),
      _resultCode(enResultCode_Invalid), 
      _resultCodeSent(enResultCode_Invalid)
   {}

   virtual ~DiagLogItem();

   bool init(char const *name, tUInt itc, tenResultCode enResCode=enResultCode_Invalid);
   bool setItc(tUInt itc);
   void vSendResult(DiagLogItem::tenResultCode enResultCode, tBool bForced=FALSE);
   void vSetResult(DiagLogItem::tenResultCode enResultCode, tBool bForced=FALSE);

   void vSendPassed(bool passed, tBool bForced=FALSE) {
      vSendResult(passed ? DiagLogItem::enResultCode_Passed : DiagLogItem::enResultCode_Failed, bForced);
   }
   void vSetPassed(bool passed, tBool bForced=FALSE) {
      vSetResult(passed ? DiagLogItem::enResultCode_Passed : DiagLogItem::enResultCode_Failed, bForced);
   }

   bool operator<(DiagLogItem const &r) const;

protected:
   char const *_name;
   tUInt _itc;
   tenResultCode _resultCode;
   tenResultCode _resultCodeSent;

private:
   DiagLogItem *getItem(tUInt itc);


};






class DiagLog : public swu::Member<FcSwUpdRoot>,
                public swu::Singleton<DiagLog>
  {
     friend class swu::Singleton<DiagLog>;
  public:
#if 0
    typedef enum {
      // DTC 614: "Mismatch detected"
      enErrorCode_VersionMismatch,
      // DTC 613: "Version back Documentation needed"
      enErrorCode_DownloadIncomplete,

      enErrorCode_Last
    }tenErrorCode;

#endif



    virtual tVoid vInit();
    
     virtual const char *getName() {
        return "DiagLog";
     }
     virtual void traceState();


    tVoid vProcess(Msg_SaveTestResultResult *pMsg);
    tVoid vProcess(Msg_SendNextTestResultStatus *pMsg);


    tVoid vSendTestResults(bool bForced = FALSE);
     
     bool registerItem(DiagLogItem *item);
     void unregisterItem(DiagLogItem *item);


  private:
    DiagLog() {};
    std::map<tUInt,DiagLogItem *> _mapItems;
    

  };


}

#endif
