#ifndef FCSWUPD_DATASTORE_HPP
#define FCSWUPD_DATASTORE_HPP


#include <sys/stat.h>

#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "util/swu_dataStore.hpp"
#include "config/fcswupd_config.hpp"

namespace fcswupdate {
// DataStore Singleton with given storage-path Config::getPersistentDataStoreFileName()
class DataStore:
      public swu::DataStore,
      public swu::Singleton<DataStore> {
    
   friend class swu::Singleton<DataStore>;

private:
   DataStore():
      swu::DataStore(Config::getUsePersistentPart() ?
                     Config::getPersistentDataStoreFileName() :
                     Config::getNonPersistentDataStoreFileName())
   {};

   virtual tVoid vInit() {
      swu::DataStore::vInit();
   }

public:
   virtual char const *getName() {
      return "DataStore";
   }

     
};


}
#endif
