#define FCSWUPD_NO_USING_NS
#include <fstream>
#include <systemd/sd-daemon.h>

#ifdef VARIANT_S_FTR_ENABLE_SWU_DBUS
#include "fcswupdatesrv/FcSwUpdateSrvDBus.h"

#endif

// signal-handling to get callstack

#include "fcswupd_component.h"
#include "fcswupd_srv.h"
#include "fcswupd_srvSystemSettings.h"

#include <util/swu_util.hpp>
#include <util/swu_filesystem.h>
#include "util/swu_preInit.h"
#include <sys/stat.h>
#include <config/fcswupd_config.hpp>
#include <sys/types.h>

#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdateComponent::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_component.cpp.trc.h"
#endif 

namespace fcswupdate {

bool FcSwUpdRoot::bSendLoobBackMsg(swu::MsgCompBase<FcSwUpdRoot> *msg) {
   FcSwUpdateComponent::instance()->bSendLoobBackMsg(msg);
   return true;
}

std::list< swu::AutoProperty * > FcSwUpdateComponent::_autoPropertyList;
DEFINE_CLASS_LOGGER_AND_LEVEL("fcswupdate", FcSwUpdateComponent, Info);

FcSwUpdateComponent::FcSwUpdateComponent() :
   FcSwUpdateLoopBackSrvStub("loopbackSrvOut") /* todo: check usage of portName for CMS-service*/
{
   setInstance(this);
   // App-level: open Trace for asf-app
   vInitPlatformEtg();
   // register exception-handler to get callstacks via ttfis
   swu::registerSignalHandler();

   ETG_I_REGISTER_FILE();
   ETG_TRACE_COMP(("FcSwUpdateComponent::FcSwUpdateComponent() CTOR start"));

   vInit();

   ETG_TRACE_COMP(("FcSwUpdateComponent::FcSwUpdateComponent() CTOR end\n"));
   printf("FcSwUpdateComponent CTOR END");
}


void FcSwUpdateComponent::vInit() {
   _memberList.addMember(FcSwUpdSrv::instance());
   _memberList.addMember(FcSwUpdDefsetSrv::instance());
   _loopBackProxy.init("loopbackSrvIn");
   _swUpdCoreProxy.init("SWUCoreServicePort");
   _diaglogProxy.init("diagLogFiPort");

   _memberList.addMember(FcSwUpdCore::instance());
   swu::PreInitManager<FcSwUpdRoot>::instance()->execute();
   _memberList.vInit();

   Config* cfg = Config::instance();

   std::string tmpDir;
   cfg->cfg_SwuTmpDir.get(tmpDir);
   if (!swu::isDirectory(tmpDir)) {
      swu::makeDirectoryRecursive(tmpDir, 0700);
   }
      
   cfg->cfg_SwuStarting.setFromBool(false);
   cfg->cfg_SwuStarted.setFromBool(true);
   cfg->cfg_bootChainMarkerForFcOta.setFromBool(true);
   if  (cfg->cfg_EnterFullOperation.readAsBool()) {
      sd_notify(0, "READY=1");
   }
}

FcSwUpdateComponent::~FcSwUpdateComponent() {
   ETG_I_UNREGISTER_FILE();
}

void FcSwUpdateComponent::traceState() {
   ETG_TRACE_COMP(("  Proxys availability:"));
   std::map <std::string, swu::ProxyAccessBase * > const &proxyList=_proxyList.getList();
   for(std::map <std::string, swu::ProxyAccessBase * >::const_iterator iter =proxyList.begin();
       iter !=proxyList.end();
       ++iter) {
      std::string const &name=iter->first;
      ETG_TRACE_COMP(("    %20s:        %u", name.c_str(), iter->second->getProxyBase()->isAvailable()));
   }

   _memberList.traceState(getName());
}

void FcSwUpdateComponent::onReceiveLoopbackMessageRequest(
      const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD_LB::ReceiveLoopbackMessageRequest >& request) {
   ETG_TRACE_COMP(("onReceiveLoopbackMessageRequest: start!"));

   intptr_t pGetMsg=static_cast<intptr_t> (request->getPMsg());      // gen3armmake, gen3x86make: conversion to 'intptr_t {aka int}' from 'uint64 {aka long long unsigned int}' made explicit
   if (pGetMsg) {
      swu::MsgCompBase<FcSwUpdRoot> *pMsg=(swu::MsgCompBase<FcSwUpdRoot> *)pGetMsg;
      ETG_TRACE_USR4(("onReceiveLoopbackMessageRequest call iNotify START pMsg=%p", pMsg));
      notify(*pMsg);
      ETG_TRACE_USR4(("onReceiveLoopbackMessageRequest call iNotify END"));
      OSAL_DELETE pMsg;
   }
};

void FcSwUpdateComponent::bSendLoobBackMsg(swu::MsgCompBase<FcSwUpdRoot> *pMsg) {
   ETG_TRACE_COMP(
                  ("bSendLoobBackMsg  START pMsg=%p avail=%u", pMsg, _loopBackProxy.isAvail()));
   if (_loopBackProxy.isAvail()) {
      _loopBackProxy.getProxy()->sendReceiveLoopbackMessageRequest((uint64) pMsg);
   }
}

// ServiceAvailableIF
void FcSwUpdateComponent::onAvailable(
      const boost::shared_ptr< asf::core::Proxy >& proxy,
      const ServiceStateChange &/* stateChange*/) {
   ETG_TRACE_COMP(("FcSwUpdateComponent::onAvailable  START State=%i proxy=%s", proxy->getServiceState(), proxy->getPortName().c_str()));

   _proxyList.onAvail(proxy, true);
   
   for (std::list< swu::AutoProperty * >::iterator iter = _autoPropertyList.begin();
         iter != _autoPropertyList.end(); ++iter) {
      if ((*iter)->getProxy() == proxy) {
         ETG_TRACE_COMP(("FcSwUpdateComponent::onAvailable: found property %s  START", (*iter)->getName()));
         (*iter)->vOnSrvAvail();
      }
   }

   if (proxy==getLoopBackProxy()) {
      /*
        todo: this should be done by a class that uses the normal 
        subsription to availability, but not in main.h, because
        asf-headers should not be included from there.
       */
      ETG_TRACE_COMP(("FcSwUpdCore::LoopBack is available now"));
      swu::MsgCompBase<FcSwUpdRoot>::onLoopbackReady();
   }

   if(proxy==getSwUpdCoreProxy()) {
      ETG_TRACE_COMP(("onAvailable for SWUCore proxy"));
      SEND_REQ_TO_PROXY(FcSwUpdateComponent,getSwUpdCoreProxy,sendStartInstallResponseRegister);
   }

   ETG_TRACE_COMP(("FcSwUpdateComponent::onAvailable  END"));
}

void FcSwUpdateComponent::onUnavailable(
      const boost::shared_ptr< asf::core::Proxy >& proxy,
      const ServiceStateChange &stateChange) {
   (void)stateChange; 
   ETG_TRACE_COMP(("FcSwUpdateComponent::onUnavailable  START"));
   _proxyList.onAvail(proxy, false);
   for (std::list< swu::AutoProperty * >::iterator iter = _autoPropertyList.begin();
         iter != _autoPropertyList.end(); ++iter) {
      if ((*iter)->getProxy() == proxy) {
         ETG_TRACE_COMP(
               ("FcSwUpdateComponent::onUnavailable: found proxy %s  START", (*iter)->getName()));
         (*iter)->vOnSrvUnavail();
      }
   }
   ETG_TRACE_COMP(("FcSwUpdateComponent::onUnavailable  END"));
}





/* TTFIS-commands */

ETG_I_CMD_DEFINE((simDiagLogSendNextTestResultStatus, "simDiagLogSendNextTestResultStatus"))
void FcSwUpdateComponent::simDiagLogSendNextTestResultStatus() {
   ::boost::shared_ptr< FCSWUPD_NS_DIAGLOG::SendNextTestResultStatus> payload(new FCSWUPD_NS_DIAGLOG::SendNextTestResultStatus());
   payload->setStatus(true);
                                                                
   ETG_TRACE_COMP(("simDiagLogSendNextTestResultStatus START"));
   onSendNextTestResultStatus(getDiagLogProxy(), payload);
   ETG_TRACE_COMP(("simDiagLogSendNextTestResultStatus END"));
}

ETG_I_CMD_DEFINE(
      (simSwUpdCoreEnterUpdateSessionResponse, "simSwUpdCoreEnterUpdateSessionResponse %u", tU32))void FcSwUpdateComponent::simSwUpdCoreEnterUpdateSessionResponse(
      bool bOk) {
   ETG_TRACE_USR4(("simSwUpdCoreEnterUpdateSessionResponse bOk=%u", bOk));
   const ::boost::shared_ptr< FCSWUPD_NS_SWUCORE::EnterUpdateSessionResponse > payload(new FCSWUPD_NS_SWUCORE::EnterUpdateSessionResponse());
   payload->setBOk(true);
   onEnterUpdateSessionResponse(getSwUpdCoreProxy(), payload);
}


ETG_I_CMD_DEFINE(
      (simSwUpdCoreExitUpdateSessionResponse, "simSwUpdCoreExitUpdateSessionResponse %u", tU32))
void FcSwUpdateComponent::simSwUpdCoreExitUpdateSessionResponse(bool bOk) {
   ETG_TRACE_USR4(("simSwUpdCoreExitUpdateSessionResponse bOk=%u", bOk));
   const ::boost::shared_ptr< FCSWUPD_NS_SWUCORE::ExitUpdateSessionResponse > payload(new FCSWUPD_NS_SWUCORE::ExitUpdateSessionResponse());
   payload->setBOk(true);
   onExitUpdateSessionResponse(getSwUpdCoreProxy(), payload);
}

ETG_I_CMD_DEFINE(
      (simSwUpdCoreStartInstallResponse, "simSwUpdCoreStartInstallResponse %u", tU32))void FcSwUpdateComponent::simSwUpdCoreStartInstallResponse(
      tUInt ok) {
   ETG_TRACE_USR4(("simSwUpdCoreSystemModeResult"));
   const ::boost::shared_ptr< FCSWUPD_NS_SWUCORE::StartInstallResponse > payload(new FCSWUPD_NS_SWUCORE::StartInstallResponse());
   payload->setEnResult((FCSWUPD_NS_SWUCORE_T::tenInstallResult)ok);
   onStartInstallResponse(getSwUpdCoreProxy(), payload);
}

ETG_I_CMD_DEFINE((testLuaScript, "testLuaScript %s", ETG_I_STRING))
void FcSwUpdateComponent::testLuaScript(char const *toolsPath) {
   ETG_TRACE_COMP(("testLuaScript(toolsPath=%s)", toolsPath));
      FCSWUPD_NS_SWUCORE_T::trCkSum toolsCksum;
      FCSWUPD_NS_SWUCORE_T::trCkSum dataFileCksum;
      FCSWUPD_NS_SWUCORE_T::trKeyValuePairs kv;
      SEND_REQ_TO_PROXY(FcSwUpdateComponent, getSwUpdCoreProxy,
      sendStartInstallRequest, "testLua",
			toolsPath, "",toolsCksum, "",dataFileCksum , kv);


   ETG_TRACE_COMP(("testLuaScript END"));
}

ETG_I_CMD_DEFINE((traceState, "traceState"))

}
