

#ifndef FCSWUPD_CAMPAIGNMANAGER_H_
#define FCSWUPD_CAMPAIGNMANAGER_H_

#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "util/fcswupd_types.hpp"
#include "main/fcswupd_mainMessages.hpp"
#include "ctrl/fcswupd_ctrl.h"
#include "ctrl/fcswupd_ctrlProgress.h"
#include "configurator/fcswupd_configurator.h"

namespace fcswupdate {

struct Msg_NotifySwUpdateState;
struct Msg_ConfiguratorReady;
struct Msg_CtrlReady;
struct Msg_NotifyPrjState;

//Fake Transistion
struct Msg_ReEnterStateRunning: public swu::Msg<Msg_ReEnterStateRunning, FcSwUpdRoot>  {
   virtual tVoid vTrace() { }
};

class CampaignManager :public swu::Member<FcSwUpdRoot>, public swu::Singleton<CampaignManager>{
      friend class swu::Singleton<CampaignManager>;
   public:
   CampaignManager();
   virtual ~CampaignManager();
   virtual tVoid vInit();
   virtual tVoid vDeInit();

   virtual void traceState();
   virtual const char *getName() {
      return "CampaignManager";
   }

   tVoid vProcess(Msg_ConfiguratorReady *pMsg);
   tVoid vProcess(Msg_CtrlReady *pMsg);
   tVoid vProcess(Msg_NotifyPrjState *pMsg);
   tVoid vProcess(Msg_ReEnterStateRunning *pMsg); 

   tVoid vEnterStateIdle();
   tVoid vEnterStatePreResult();
   tVoid vEnterStateConfig(tenSwUpdateMode enMode, Configurator *configurator);
   tVoid vEnterStateRunning(TiXmlDocument *xmlDoc);
   bool bReEnterStateRunning();


   tVoid scomoStart();
   tVoid startInstallScomo(tU8 u8Phase);
   tBool scomoDone();
   tVoid forceScomoDone();


   tBool bIsIdle();   

   //Helpers
   tU8 getCurrentCampaignPhase() { 
      return _u8CurrentPhase;
   }

   tU8 getRequestedCampaignPhase() {
      return _u8RequestedPhase;
   }

   tBool isScomoMode() { 
      return _enUpdateMode == tenSwUpdateMode_Scomo;
   }

   std::string getScomoComponentId() { 
      return _componentId;
   }
   std::string getActualScomoCompId();
   
   tenSwUpdateMode enGetUpdateMode() const { 
      return _enUpdateMode;
   }

   tVoid enSetUpdateMode(tenSwUpdateMode enMode) { 
      _enUpdateMode = enMode;
   }

   tenSwUpdateState enGetSwUpdateState() const { 
      return _enState;
   }

   CtrlProgressSection* getProgressSectionInst() {      
      return _ctrlProgress;
   }

   Ctrl* getCtrlInstance() {
      return _ctrl;
   }

   //TTIF's cmd
   void simInitCtrlByFile(const char* path_xml, tU16 updateMode);

   private:   
   // state-transitions
   tVoid vSetState(tenSwUpdateState enState);

   tVoid createCtrlProgress(std::string fileName);
   tVoid createScomoCtrlProgress(TiXmlDocument *doc);  

   tBool searchCompIdProgressFile(std::string &fileName);
   tBool searchForProgressFile(std::string &fileName);
   tBool searchProgressFileForComp(std::string strFileName, std::string strCompId);
   
   tBool evaluatePhase();


   std::string _componentId;
   std::string _progState;

   uint_least8_t _u8CurrentPhase;   // updated the type from tU8 to uint_least8_t since value stored is of type uint_least8_t
   tU8 _u8RequestedPhase;

   tenSwUpdateMode _enUpdateMode;
   tenSwUpdateState _enState;

   swu::MemberList<FcSwUpdRoot> _memberList;

   Configurator *_configurator;
   Ctrl *_ctrl;
   CtrlProgressSection *_ctrlProgress;
   
};

} /* namespace fcswupdate */

#endif /* FCSWUPD_CAMPAIGNMANAGER_H_ */
