
#include "main/fcswupd_campaignmanager.h"
#include "main/fcswupd_main.h"
#include "util/swu_filesystem.h"
#include "main/fcswupd_srv.h"
#include "main/fcswupd_propDevMgr.h"

#define ETG_I_FILE_PREFIX fcswupdate::CampaignManager::instance()->

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_campaignmanager.cpp.trc.h"
#endif

namespace fcswupdate {

CampaignManager::CampaignManager() :
   _enState(tenSwUpdateState_Initial),
   _enUpdateMode(tenSwUpdateMode_Invalid),
   _u8CurrentPhase(CampaignPhase__Idle),
   _u8RequestedPhase(CampaignPhase__Idle),
   _configurator(0),
   _ctrl(0),
   _ctrlProgress(0) {
   ETG_TRACE_USR2(("CampaignManager(%p)::CampaignManager CTOR", this));
   ETG_I_REGISTER_FILE();
}

CampaignManager::~CampaignManager(){
   ETG_TRACE_USR2(("CampaignManager()::CampaignManager DTOR"));
}

tVoid CampaignManager::vInit() {
   Msg_ConfiguratorReady::vSubscribe(this);
   Msg_CtrlReady::vSubscribe(this);
   Msg_ReEnterStateRunning::vSubscribe(this);
   _memberList.vInit();

}

tVoid CampaignManager::vDeInit() {   
   _memberList.vDeInit();
}

tVoid CampaignManager::traceState() {
   ETG_TRACE_COMP(("  _enState=%u", ETG_CENUM(tenSwUpdateState, _enState)));
   ETG_TRACE_COMP(("  _enUpdateMode=%u", ETG_CENUM(tenSwUpdateMode, _enUpdateMode)));
   ETG_TRACE_COMP(("  _configurator=%p", _configurator));
   ETG_TRACE_COMP(("  _ctrl=%p", _ctrl));
   ETG_TRACE_COMP(("  _ctrlProgress=%p", _ctrlProgress));
   ETG_TRACE_COMP(("  currentPhase=%u requestedPhase=%u", _u8CurrentPhase, _u8RequestedPhase));
   ETG_TRACE_COMP(("  _componentId=%s", _componentId.c_str()));
}

tVoid CampaignManager::vSetState(tenSwUpdateState enState) {      
    ETG_TRACE_USR1(("CampaignManager::vSetState(%p):%u -> %u", this, 
                    ETG_CENUM(tenSwUpdateState, _enState),
                    ETG_CENUM(tenSwUpdateState, enState)));
   _enState = enState;   
   Msg_NotifySwUpdateState msg(_enState);
   notify(msg);
}

tVoid CampaignManager::vEnterStateIdle() {
   _memberList.deleteMember(_ctrl);
   _memberList.deleteMember(_ctrlProgress);
   _memberList.deleteMember(_configurator);
   /*
     delete occasionally running post image installation
    */
   Config::instance()->cfg_PostImageInstallationRunning.set(false);

   if(_enUpdateMode != tenSwUpdateMode_Scomo) {
      _enUpdateMode = tenSwUpdateMode_Invalid;
   }
   vSetState(tenSwUpdateState_Idle);
}

tVoid CampaignManager::vEnterStatePreResult() {
   _memberList.deleteMember(_ctrl);
   _memberList.deleteMember(_ctrlProgress);
   _memberList.deleteMember(_configurator);
   vSetState(tenSwUpdateState_PreResult);
}

tVoid CampaignManager::vEnterStateConfig(tenSwUpdateMode enMode, Configurator *configurator) {
   SWU_ASSERT_RETURN(_enState==tenSwUpdateState_Idle);
   SWU_ASSERT_RETURN(OSAL_NULL != configurator);
   SWU_ASSERT_RETURN(OSAL_NULL == _configurator);

   if(_enUpdateMode != tenSwUpdateMode_Scomo) {
      _enUpdateMode = enMode;
   }
   _configurator = configurator;
   _memberList.addMember(_configurator);   
   // we can't handle further request now, so unsubscribe
   vSetState(tenSwUpdateState_Config);
}

tVoid CampaignManager::vEnterStateRunning(TiXmlDocument *xmlDoc) {
   SWU_ASSERT_RETURN(_enState==tenSwUpdateState_Config);
   ETG_TRACE_USR1(("CampaignManager::vEnterStateRunning"));

   ETG_TRACE_USR1(("CampaignManager::Stopping Idle state timer"));
   FcSwUpdCore::instance()->stopFinalizeTimer();      

   _ctrl = new Ctrl(_ctrlProgress, _enUpdateMode, xmlDoc);
   _memberList.addMember(_ctrl);   
   
    // start sw-update
   vSetState(tenSwUpdateState_Running);
   _ctrl->vRun();
}

tVoid CampaignManager::vProcess(Msg_ReEnterStateRunning *pMsg) {
   ETG_TRACE_USR2(("CampaignManager-Msg_ReEnterStateRunning"));
   _memberList.deleteMember(_configurator);
   bReEnterStateRunning();
}


bool CampaignManager::bReEnterStateRunning() {
   bool bRes = false;

   ETG_TRACE_USR3(("CampaignManager::bReEnterStateRunning:START"));
   if(_ctrlProgress == 0) {
      std::string progFileName;
      if(searchForProgressFile(progFileName)) {
         ETG_TRACE_USR1(("Progress File is already present in persistent"));
         createCtrlProgress(progFileName);                  
      } else {
         ETG_TRACE_USR2(("no progress file present in persistent"));
         return false;
      }
   }
   if( _configurator )
   {
        ETG_TRACE_USR3(("CampaignManager::bReEnterStateRunning : configurator deleted"));
        _memberList.deleteMember(_configurator);
   }
   _ctrl = new Ctrl(_ctrlProgress);
   _memberList.addMember(_ctrl);

   ETG_TRACE_USR2(("_u8CurrentPhase:%u", _u8CurrentPhase));
   if(_ctrlProgress->getSourceType() == tenSourceType_SCOMO_INDEX && _u8CurrentPhase == CampaignPhase__Idle) {
      ETG_TRACE_USR4(("it's scomo-index. delete running.xml because bosch.xml is not available for loading"));
      _ctrlProgress->remove();
      if(Config::instance()->cfg_EnterFullOperation.readAsBool()) {
         vEnterStateIdle();
      } else {
         vEnterStateIdle();
         poGetProjectSpecific()->vEnterRecoveryDownload();
      }
      return true;
   }

   /*
     for compact update mode, running.xml is not needed to be loaded.
     start the SW-Update fresh in recovery mode, if it compact mode it never comes in normal mode.
    */

   ETG_TRACE_USR4(("_ctrlProgress->isUpdateDone()=%u  _ctrlProgress->getSpecialMode()=%s",_ctrlProgress->isUpdateDone(), _ctrlProgress->getSpecialMode().c_str()));
   if(((_ctrlProgress->getSpecialMode() == "COMPAT_UPDATE")  || (_ctrlProgress->getSpecialMode() == "ENTER_FULL_UPDATE") || (_ctrlProgress->isUpdateDone())) &&  Config::instance()->cfg_EnterRecovery.readAsBool()) {
      ETG_TRACE_USR4(("it's compact update. deleting running.xml since it's not valid "));
      _ctrlProgress->remove();
      vEnterStateIdle();
      poGetProjectSpecific()->vEnterRecoveryDownload();
      return true;
   }
   if(_ctrlProgress->isScomoMode()) {
      _enUpdateMode = tenSwUpdateMode_Scomo;
      _componentId = _ctrlProgress->getComponentId();
      _u8CurrentPhase = static_cast<uint_least8_t> (_ctrlProgress->getRequestedScomoPhase()); // gen3armmake, gen3x86make, gen4rcar, gen4lsim: conversion to 'tU8 {aka unsigned char}' from 'tU32 {aka unsigned int}' made explicit
   }

   vSetState(tenSwUpdateState_Running);
   _ctrl->vRun();
   bRes = true;
   ETG_TRACE_USR3(("CampaignManager::bReEnterStateRunning:END")); 
 
   return bRes;
}


tVoid CampaignManager::vProcess(Msg_ConfiguratorReady *pMsg) {
   ETG_TRACE_COMP(("CampaignManager:vProcess(Msg_ConfiguratorReady)"));
   SWU_ASSERT_RETURN(_enState==tenSwUpdateState_Config);
   SWU_ASSERT_RETURN(_configurator);
   if (!pMsg->_bFlashIt) {
      vEnterStateIdle();
   } else {
      // todo: check state and create matching configurator
      // fetch the configuration
      TiXmlDocument *xmlDoc = _configurator->getXmlDoc();
      SWU_ASSERT_RETURN(xmlDoc);
      _memberList.deleteMember(_configurator);
      // create control and set the configuation
      // delete the no longer used configurator
      if(_enUpdateMode == tenSwUpdateMode_Scomo) {
         createScomoCtrlProgress(xmlDoc);
      } else {
         createCtrlProgress(Config::getProgressFileName());
      }
      vEnterStateRunning(xmlDoc);
   }
}

tVoid CampaignManager::vProcess(Msg_CtrlReady *pMsg) {
   ETG_TRACE_COMP(("CampaignManager:vProcess(Msg_CtrlReady), enReadyMode=%u enAction=%u enInterval=%u"
                   "u32NumIntervals=%u, _enUpdateMode=%u",
                   ETG_CENUM(tenCtrlReadyMode, pMsg->_readyAction.enMode),
                   ETG_CENUM(tenCtrlReadyAction, pMsg->_readyAction.enAction),
                   ETG_CENUM(tenCtrlReadyInterval, pMsg->_readyAction.enInterval),

                   pMsg->_readyAction.u32NumIntervals,
                   ETG_CENUM(tenSwUpdateMode, _enUpdateMode)));
   // decide what to do now.
   SWU_ASSERT_RETURN(_enState==tenSwUpdateState_Running); 

   if(_ctrlProgress) {
      //always remove the progress section from campaign manager in whatever mode
      if(pMsg->_readyAction.enMode != enCtrlReadyMode_intermediate) {
         ETG_TRACE_USR1(("removing the persistent progress file"));
         _ctrlProgress->remove();
      }
      _memberList.deleteMember(_ctrlProgress); 
   }
  
   _memberList.deleteMember(_ctrl);
      
   FcSwUpdCore::instance()->setReadyAction(pMsg->_readyAction);
   tU32 delay = pMsg->_readyAction.getIntervalMs();
   ETG_TRACE_COMP(("CampaignManager:vProcess(Msg_CtrlReady) start finalizeTimer (%u ms)", delay));
   FcSwUpdCore::instance()->displayReadyMsg();
   if (pMsg->_readyAction.enAction!=enCtrlReadyAction_blocking) {
      FcSwUpdCore::instance()->startFinalizeTimer(delay);
   }   
}

tVoid CampaignManager::vProcess(Msg_NotifyPrjState *pMsg) {

   tenPrjState enPrjState = pMsg->_enState;
   ETG_TRACE_USR2(("CampaignManager-NotifyPrjState:%u", ETG_CENUM(tenPrjState, enPrjState)));
   
   if(Config::instance()->cfg_DoIgnoreNormalModeHMIInteractions.get() && enPrjState == tenPrjState_Config) {         
      FcSwUpdSrv::instance()->simHmiApplyDocRequest();
      //this prjState is not required any more.
      Msg_NotifyPrjState::vUnSubscribe(this);
   } 
   //If any error from configurator, it will be informed to scomo here
   else if(enPrjState == tenPrjState_SelectRelease && _enState == tenSwUpdateState_Config) {
      FcSwUpdCore::getIfOrDefault<ScomoSrvIf>()->sendPhaseResult(false);
   }   
}

tBool CampaignManager::bIsIdle() {
   ETG_TRACE_USR4(
               ("CampaignManager(%p)::bIsIdle: _enState=%u tenState_Idle=%u", this, _enState, tenSwUpdateState_Idle));
   return _enState == tenSwUpdateState_Idle;
}

tVoid CampaignManager::scomoStart() {
   ETG_TRACE_USR2(("CampaignManager::scomoStart - START"));
   
   Config *cfg=Config::instance(); 
   //no hmi-interactions are needed for scomo-update
   cfg->cfg_DoIgnoreNormalModeHMIInteractions.set(true);
   cfg->cfg_AllowRebootDuringInstall.set(false);
   cfg->cfg_WriteFcIdAfterUpdate.set(false);
 
   
   _enUpdateMode = tenSwUpdateMode_Scomo;
   Msg_NotifyPrjState::vSubscribe(this);
   ETG_TRACE_USR2(("CampaignManager::scomoStart - END"));
}

tBool CampaignManager::scomoDone() {
   ETG_TRACE_USR2(("CampaignManager::scomoDone - START"));
   tBool bResult = false;  

   std::string fileName;
   //todo: Need to extend for more files, currently it handle one file
   if(searchCompIdProgressFile(fileName)) {
      _u8RequestedPhase = CampaignPhase__End;
      createCtrlProgress(fileName);
      _ctrlProgress->remove();
      delete _ctrlProgress;
      _ctrlProgress = 0;      
   }   

   Config *cfg=Config::instance();
   std::string pattern = "fcswupd_running*.xml";
   std::set<std::string> files = swu::getMatchingFiles(cfg->getPersitentDirName(), pattern);
   if(files.empty()) {
      ETG_TRACE_USR2(("No running XML is present, Finalizing the Scomo Update"));

      cfg->cfg_DoIgnoreNormalModeHMIInteractions.set(false);
      cfg->cfg_WriteFcIdAfterUpdate.set(true);

      _enUpdateMode = tenSwUpdateMode_Hmi;
      _u8CurrentPhase = CampaignPhase__Idle;  
      _u8RequestedPhase = CampaignPhase__Idle;
      _componentId.clear();
      bResult = true;
   }
   
   ETG_TRACE_USR2(("CampaignManager::scomoDone-%u - END", bResult));
   return bResult;
}

/*
this function has to be called when some things gone wrong in scomo ota update.
no possibility of rollback means, finalize all scomo components which is present.
accept the other sources as usual for sw-update
 */
ETG_I_CMD_DEFINE((forceScomoDone, "forceScomoDone"))
tVoid CampaignManager::forceScomoDone() {
   ETG_TRACE_USR2(("CampaignManager::forceScomoDone - START"));

   //this will clear existing fcswupd_running
   std::string pattern = "*fcswupd_running*";
   std::set<std::string> files = swu::getMatchingFiles(Config::instance()->getPersitentDirName(), pattern);
   for(std::set<std::string>::iterator iter = files.begin(); iter != files.end(); iter++) {
      std::string file = *iter;
      ETG_TRACE_USR4(("File Taken - %s", file.c_str()));
      
      if(file.substr(file.find_last_of(".")) == ".xml") {
         createCtrlProgress(file);
         _ctrlProgress->remove();
         delete _ctrlProgress;
         _ctrlProgress = 0;
      }         
   }

   //reset all configuration to normal.
   Config *cfg=Config::instance();
   if(cfg->cfg_EnterFullOperation.readAsBool()) {
      cfg->cfg_DoIgnoreNormalModeHMIInteractions.set(false);
      cfg->cfg_WriteFcIdAfterUpdate.set(true);

      _enUpdateMode = tenSwUpdateMode_Hmi;
   }
   _u8CurrentPhase = CampaignPhase__Idle;  
   _u8RequestedPhase = CampaignPhase__Idle;
   _componentId.clear();

   if(_enState == tenSwUpdateState_Running) {
      ETG_TRACE_USR1(("CampaignManager::forceScomoDone, forcing update state to Idle"));
      vEnterStateIdle();
   }

   ETG_TRACE_USR2(("CampaignManager::forceScomoDone - END"));
}


tVoid CampaignManager::startInstallScomo(tU8 u8Phase) {
   ETG_TRACE_USR3(("CampaignManager::startInstallScomo, enPhase:%u", u8Phase));
 
   _componentId = PropDevMgr::instance()->getComponentId();
   _u8RequestedPhase = u8Phase;  
   _u8CurrentPhase = CampaignPhase__Idle;
   Config::instance()->cfg_ScomoPhase.set(_u8RequestedPhase);   
   
   do {
      if(!evaluatePhase()) {
         FcSwUpdCore::getIfOrDefault<ScomoSrvIf>()->sendPhaseResult(false);
         break;
      }
      if(_u8CurrentPhase == CampaignPhase__Idle) {
         PropDevMgr *property = PropDevMgr::instance();
         property->notifyLater();
         break;
      }
      if(_u8CurrentPhase >= 1) {
         _memberList.addMember(_ctrlProgress);
         Msg_NotifyPrjState::vUnSubscribe(this);
         Msg_ReEnterStateRunning *pMsg=new Msg_ReEnterStateRunning();
         pMsg->bNotifyLater();
         pMsg = 0;
         break;
      }
     
   }while(false);
 
}


tVoid CampaignManager::createScomoCtrlProgress(TiXmlDocument *doc) {

  ETG_TRACE_USR4(("CampaignManager::createScomoCtrlProgress - START"));

  BXmlAccess access(doc);
  std::string deviceName = access.getTextFromDevice("NAME");
  std::string moduleName = access.getTextFromModule("NAME");

  std::string fileName = "fcswupd_running_";
  fileName = fileName + deviceName + "_" + moduleName + ".xml";
  ETG_TRACE_USR2(("File Name From XmlDoc:%s", fileName.c_str()));

  std::string absoluteFileName = Config::instance()->getPersitentDirName();
  absoluteFileName = absoluteFileName + fileName;

  createCtrlProgress(absoluteFileName);   
  ETG_TRACE_USR4(("CampaignManager::createScomoCtrlProgress - END"));
}


tBool CampaignManager::searchCompIdProgressFile(std::string &fileName) {
   ETG_TRACE_USR2(("CampaignManager::searchCompIdProgressFile - START"));

   tBool bReturn = false;
   std::string pattern = "fcswupd_running*.xml";
   std::set<std::string> files = swu::getMatchingFiles(Config::instance()->getPersitentDirName(), pattern);
   for(std::set<std::string>::iterator iter = files.begin(); iter != files.end(); iter++) {
      std::string file = *iter;
      ETG_TRACE_USR4(("File Taken - %s", file.c_str()));
      
      if(file.substr(file.find_last_of(".")) == ".xml")  {
         _progState.clear();
         
         if(searchProgressFileForComp(file, _componentId)) {   
            fileName = file;         
            bReturn = true;
            break;
         }
      }
   }     
   ETG_TRACE_USR2(("CampaignManager::searchCompIdProgressFile - END"));
   return bReturn;
}

tVoid CampaignManager::createCtrlProgress(std::string fileName) {
   ETG_TRACE_USR2(("CampaignManager::createCtrlProgress-%s", fileName.c_str()));   

   _ctrlProgress = new CtrlProgressSection(fileName);
   SWU_ASSERT_RETURN(_ctrlProgress);
   _memberList.addMember(_ctrlProgress);

   ETG_TRACE_USR4(("CampaignManager::createCtrlProgress - END"));
}

tBool CampaignManager::evaluatePhase() {

   std::string fileName;
   tBool bEvaluationStatus = true;
   _u8CurrentPhase = CampaignPhase__Idle;

   ETG_TRACE_USR2(("Evaluation Before: _u8RequestedPhase-%u, _u8CurrentPhase-%u", _u8RequestedPhase, _u8CurrentPhase));

   do {
      if(searchCompIdProgressFile(fileName)) {
         ETG_TRACE_USR3(("Progress State-%s", _progState.c_str()));
         if(_progState == "result") {
            bEvaluationStatus = false;
            break;
         }
      }
      if(_u8CurrentPhase == CampaignPhase__Idle ) {
         break;
      }
      if(_u8CurrentPhase >= _u8RequestedPhase) {
         _u8RequestedPhase = _u8CurrentPhase;
         bEvaluationStatus = false;
         break;
      }
      if(_u8CurrentPhase < _u8RequestedPhase) {
         createCtrlProgress(fileName);
         break;
      }
   }while(false); 
  
   ETG_TRACE_USR2(("Evaluation Status-%u: _u8RequestedPhase-%u, _u8CurrentPhase-%u",bEvaluationStatus, 
                   _u8RequestedPhase, _u8CurrentPhase));
   return bEvaluationStatus;
}

tBool CampaignManager::searchForProgressFile(std::string &fileName) {

   ETG_TRACE_USR2(("CampaignManager::searchForProgressFile - START"));
   tBool bReturn = false;

   std::string pattern = "fcswupd_running*.xml";
   std::set<std::string> files = swu::getMatchingFiles(Config::instance()->getPersitentDirName(), pattern);
   for(std::set<std::string>::iterator iter = files.begin(); iter != files.end(); iter++) {

      std::string file = *iter;
      ETG_TRACE_USR4(("File Taken - %s", file.c_str()));

      if(file.substr(file.find_last_of(".")) == ".xml") {

         swu::ScopedPointer<CtrlProgressSection> ctrlProgInst(new CtrlProgressSection(file));
         CtrlPersistentConfig persisentConfig;
         if(ctrlProgInst->restore(true, &persisentConfig)) {
            std::string progState = ctrlProgInst->getPersistentState();
	    ETG_TRACE_USR2(("CampaignManager::progState=%s",progState.c_str()));
            if(progState == "running" || progState == "scomoPending" || progState == "result") {   
            
               //take only the firmware in case of scomo in recovery mode
               Config* cfg = Config::instance();
               if(cfg->cfg_EnterRecovery.get() && ctrlProgInst->getInitialMode() == tenSwUpdateMode_Scomo) {
                  if(ctrlProgInst->getComponentId() != "FIRMWARE") {
                     continue;
                  }
               }
               fileName = file;
               bReturn = true;

            }
         }
      }
   }  
   ETG_TRACE_USR2(("CampaignManager::searchForProgressFile - END"));
   return bReturn;
}


tBool CampaignManager::searchProgressFileForComp(std::string scomoFile, std::string strCompId) {

   ETG_TRACE_USR2(("CampaignManager::searchProgressFileForComp - START"));
   tBool bReturn = false;

   swu::ScopedPointer<CtrlProgressSection> ctrlProgInst(new CtrlProgressSection(scomoFile));
   CtrlPersistentConfig persisentConfig;
   if(ctrlProgInst->restore(true, &persisentConfig)) {
      std::string compId =  ctrlProgInst->getComponentId();
      if(compId == strCompId) {
         _progState = ctrlProgInst->getPersistentState();
         _u8CurrentPhase = static_cast<uint_least8_t> (ctrlProgInst->getRequestedScomoPhase()); // gen3armmake, gen3x86make, gen4rcar, gen4lsim: conversion to 'tU8 {aka unsigned char}' from 'tU32 {aka unsigned int}' made explicit
         bReturn = true;
         ETG_TRACE_USR2(("Found Progress File with comp:%s", strCompId.c_str()));
      }
   }
   ETG_TRACE_USR2(("CampaignManager::searchProgressFileForComp - END"));
   return bReturn;
}

std::string CampaignManager::getActualScomoCompId() {

   std::string compId = "unknown";
   Config* cfg = Config::instance();

   if(_componentId == "FIRMWARE") {
      compId = cfg->getCompId(cfg->cfg_ScomoFirmwareCompId);
   } else if (_componentId == "WCS") {
      compId = cfg->getCompId(cfg->cfg_ScomoWelcomeSequenceCompId);
   }

   ETG_TRACE_USR3(("CampaignManager::getActualScomoCompId:%s",compId.c_str()));
   return compId;

}


ETG_I_CMD_DEFINE((simInitCtrlByFile, "simInitCtrlByFileForHmi %80s", ETG_I_STRING, ETG_I_CONST_ARG(1)))
ETG_I_CMD_DEFINE((simInitCtrlByFile, "simInitCtrlByFileForEmergency %80s", ETG_I_STRING, ETG_I_CONST_ARG(3)))
ETG_I_CMD_DEFINE((simInitCtrlByFile, "simInitCtrlByFileForEngineering %80s", ETG_I_STRING, ETG_I_CONST_ARG(6)))
ETG_I_CMD_DEFINE((simInitCtrlByFile, "simInitCtrlByFileForScomo %80s", ETG_I_STRING, ETG_I_CONST_ARG(7)))

void CampaignManager::simInitCtrlByFile(const char* path_xml, tU16 updateMode) {
   ETG_TRACE_COMP(("CampaignManager::simInitCtrlCustomerDownload for xml file %s", path_xml));
   TiXmlDocument doc(path_xml);
   if (doc.LoadFile()) {

      createCtrlProgress(path_xml);
      _ctrl = new Ctrl(_ctrlProgress,(tenSwUpdateMode)updateMode, &doc);      
      _memberList.addMember(_ctrl);

      // continue sw-update
      _enUpdateMode = (tenSwUpdateMode)updateMode;
      vSetState(tenSwUpdateState_Running);
      _ctrl->vRun();

      _memberList.deleteMember(_configurator);
   } else {
      ETG_TRACE_ERR(("CampaignManager::simInitCtrlCustomerDownload could not load file %s", path_xml));
   }
   ETG_TRACE_COMP(("CampaignManager::simInitCtrlCustomerDownload END"));
}



} /* namespace fcswupdate */
