/**
 * @file fcswupd_bxmlCheck.h
 * @author hcg1hi
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup ai_sw_update
 * @{
 */

#ifndef FCSWUPD_BXMLCHECK_H_
#define FCSWUPD_BXMLCHECK_H_

#include "fcswupd_main.h"
#include "util/fcswupd_types.hpp"
#include "tinyxml/tinyxml.h"
#include "util/swu_msg.hpp"
#include "util/swu_member.hpp"

namespace fcswupdate {

class CurrentBoschXml;


struct Msg_CurrentBoschXmlChanged: public swu::Msg < Msg_CurrentBoschXmlChanged, FcSwUpdRoot >
{
   Msg_CurrentBoschXmlChanged(CurrentBoschXml *currentBoschXml) :
            _currentBoschXml(currentBoschXml)
   {
   };
   virtual tVoid vTrace();

   CurrentBoschXml *_currentBoschXml;
};

struct Msg_NotifyDevManagerChanged;

class CurrentBoschXml: public swu::Member < FcSwUpdRoot >, public swu::Singleton<CurrentBoschXml>
{
   friend class swu::Singleton<CurrentBoschXml>;
private:
   CurrentBoschXml();
public:
   virtual ~CurrentBoschXml();
   // Configured with non-empty string for version (checksum is optional)
   tBool setConfig(const std::string &version, const std::string &checksum = "");
   /* provide pointer to root-node of bosch.xml or null. Caller has to copy data.*/
   TiXmlElement * getOverallXml() const {
      return _root;
   }
   tBool getConfig(std::string &version, std::string &checksum) const;
   // return, if we have a valid bosch.xml
   tBool isValid() const;
   tBool hasOtherRelease() const;
   int getErrorCode() const;
   tVoid vProcess(Msg_NotifyDevManagerChanged const *pMsg);
   tVoid vProcess(Msg_CurrentBoschXmlChanged const *pMsg);

   virtual void traceState() {
   };
   // TTFis commands
   static tVoid testGetBoschXml(const char *version);
   static tVoid testSHA256Hash(const char *text);
   static void simStickRemoved(uint8 removed);

private:
   tVoid lookupBoschXml(std::map < std::string, trSourceInfo > sourcesList);

   std::string _version;
   std::string _checksum;
   TiXmlElement *_root;
   bool _hasOtherRelease;
   static bool _simStickRemoved;
   int _errorCode;
};

}

#endif /* FCSWUPD_BXMLCHECK_H_ */
