/*
 * fcswupd_ctrlRecovery.h
 *
 *  Created on: Oct 15, 2013
 *      Author: efs1hi
 */

#ifndef FCSWUPD_CTRL_RECOVERY_GENERIC_H_
#define FCSWUPD_CTRL_RECOVERY_GENERIC_H_

#include "ctrl/fcswupd_ctrl.h"
#include "util/fcswupd_trace.hpp"

namespace fcswupdate {

#define SWUPD_RECOVERY_FAILED_FINALIZE_TIMER_SEC 300
#define SWUPD_RECOVERY_SHUTDOWN_NOW_SEC          1
#define SWUPD_RECOVERY_MEDIUM_REMOVED_TIMER_MSEC 1200*1000 // 20*60*1000 

/**
 * This Control Adapter is for the Recovery/Emergency update
 */



class CtrlRecoveryGeneric: public CtrlAdapter {
private:

public:

   CtrlRecoveryGeneric(Ctrl *pCtrl):
      CtrlAdapter(pCtrl)
   {}
   virtual ~CtrlRecoveryGeneric() { }

   virtual const char *getName() {
      return "CtrlRecoveryGeneric";
   }

   virtual void traceState() { }

   virtual tenSwUpdateMode enSwUpdateMode() {
      return tenSwUpdateMode_Emergency;
   }

   virtual tenErrorHandling enOnCtrlError(std::list< uint32_t > const &errors);

   virtual void modifyConfig(CtrlPersistentConfig &ctrlConfig);
   virtual void modifyConfig(CtrlStaticConfig &ctrlConfig);
   virtual void modifyCtrlResultAction(bool updateSuccess, CtrlReadyAction *readyAction);

};

}

#endif
