/*
 * fcswupd_ctrlHmi.h
 *
 *  Created on: Oct 15, 2013
 *      Author: efs1hi
 */

#ifndef FCSWUPD_CTRL_HMI_GENERIC_H_
#define FCSWUPD_CTRL_HMI_GENERIC_H_

#include "ctrl/fcswupd_ctrl.h"
#include "fcswupdatesrv/FcSwUpdateSrvStub.h"
#include "util/swu_timer.h"


#include "util/fcswupd_trace.hpp"

namespace fcswupdate {

#define SWUPD_HMI_UPDATE_FAILED_FINALIZE_TIMER_SEC 10

/**
 * This Control Adapter is for the Hmi update
 */
class CtrlHmiGeneric: public CtrlAdapter {
public:
   CtrlHmiGeneric(Ctrl *pCtrl):
      CtrlAdapter(pCtrl) {
   }

   virtual ~CtrlHmiGeneric() { }

   tVoid vInit();

   virtual const char *getName() {
      return "CtrlHmiGeneric";
   }
   virtual void traceState() { }

   virtual tVoid vOnCtrlWaitRecoveryAllowed(bool &interact) {
      setHmiState(tenPrjState_WaitAllowRecoveryMode);
   }
   
   virtual tenSwUpdateMode enSwUpdateMode() {
      return tenSwUpdateMode_Hmi;
   }


   // configuration of Ctrl
   virtual void modifyConfig(CtrlPersistentConfig &ctrlConfig);
   virtual void modifyConfig(CtrlStaticConfig &ctrlConfig);

   // todo: rework Ctrl-Ready action, add ctrtResult action or combine both.
   // optimal case would be that only the result-action is needed.
   virtual void modifyCtrlResultAction(bool updateSuccess, CtrlReadyAction *readyAction);

   virtual tVoid vOnCtrlResult(bool success);

   virtual tVoid getNeededResourcesOnRun(tenReqMode &enResMode, std::set<std::string> &resList);
   virtual tVoid getNeededResourceOnIn(tenReqMode &enResMode);
   
   // interface to HMI
   tVoid vProcess(Msg_UpdateEndRequest *pMsg);
   tVoid vProcess(Msg_UpdateAbortRequest *pMsg);

private:
   CtrlPersistentConfig _persistConfig;
   CtrlStaticConfig _staticConfig;

   std::vector<std::string> _updateLocks;
   
private:
   bool checkForLocks();   

};

}

#endif
