/*
 * fcswupd_ctrlHmi.cpp
 *
 *  Created on: Mar 13, 2014
 *      Author: efs1hi
 */

#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "util/swu_execCommand.h"
#include "util/swu_filesystem.h"
#include "config/fcswupd_config.hpp"
#include "main/fcswupd_component.h"
#include "main/fcswupd_srv.h"

#include "main/fcswupd_bxmlCheck.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_spmIf.h"
#include "ctrl/fcswupd_ctrl.h"
#include "ctrl/fcswupd_ctrlHmiGeneric.hpp"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_CTRL
#include "trcGenProj/Header/fcswupd_ctrlHmiGeneric.cpp.trc.h"
#endif

namespace fcswupdate {


tVoid CtrlHmiGeneric::vInit() {
   ETG_TRACE_COMP(("CtrlHmiGeneric::vInit"));
   Msg_UpdateEndRequest::vSubscribe(this);
   Msg_UpdateAbortRequest::vSubscribe(this);
}



// configuration that is fetched on start of update and stored persistently in progress-section if needed
void CtrlHmiGeneric::modifyConfig(CtrlPersistentConfig &ctrlConfig) {
   Config *cfg=Config::instance();

   // if set, sw-update will keep persistent progress-section in case update has been finished in recovery-mode
   // and will again come up in hmi-mode in state result.
   ctrlConfig.needsResultOkInHmiMode.set(1);
   /*
     Result will be shown after the new sw is activated.
     So even if the update ends without recovery-mode, that result will displayed in next power-cycle
   */
   ctrlConfig.needsResultAfterActivation.set(_pCtrl->isScomoModeFirmware());
   /*
     Even if the real result-state will only be entered after next power-cycle, 
     A pre-result state will be exposed before the power-cycle.
   */
   ctrlConfig.needsPreResult.set(_pCtrl->isScomoModeFirmware());
   /*
     Target shall shutdown after update. This is also valid for a failed update.
   */
   ctrlConfig.forceShutdown.set(cfg->cfg_DoShutdownAfterUpdate.readAsBool());
   /*
     Lock implementation has to be handled or not
    */
   if(cfg->cfg_HandleCentralLock.get() && !_pCtrl->isScomoMode()) {
      ctrlConfig.needsUpdateLock.set(true);
   }
   
   ctrlConfig.maxModTries.set(cfg->cfg_CtrlMaxModRetries.get());
   _persistConfig = ctrlConfig;

}


// configuration that is fetched on startup
void CtrlHmiGeneric::modifyConfig(CtrlStaticConfig &ctrlConfig) {
   Config *cfg=Config::instance();
   // next not needed, all adapters should use Config directly
   ctrlConfig.needsSpmSwUpdateMode=cfg->getUseSpmUpdateMode();

   ctrlConfig.interactOnResult=false;
   _staticConfig = ctrlConfig;
}




/*
  this is the the ready-action if the update is over, not for intermediate reboots.
*/
void CtrlHmiGeneric::modifyCtrlResultAction(bool updateSuccess, CtrlReadyAction *readyAction) {

   (void)updateSuccess;    
   
   readyAction->enAction=enCtrlReadyAction_idle;
   readyAction->u32NumIntervals=0;
}


tVoid CtrlHmiGeneric::vProcess(Msg_UpdateEndRequest *pMsg) {
   (void)pMsg; 
   ETG_TRACE_USR1(("CtrlHmiGeneric::vProcess(Msg_UpdateEndRequest *pMsg)"));
   bool success=_pCtrl->vUpdateEndRequest();

   ETG_TRACE_USR1(("CtrlHmiGeneric::Msg_UpdateEndRequest success=%u", success));
   FcSwUpdSrv::instance()->sendUpdateEndResponse(success);
}


tVoid CtrlHmiGeneric::vProcess(Msg_UpdateAbortRequest *pMsg) {
   SWU_ASSERT_RETURN(pMsg);
   
   // device-only ignored (not supported)
   //   bool deviceOnly=pMsg->payload->getBDeviceOnly(); 
   ETG_TRACE_USR1(("CtrlHmiGeneric::vProcess(Msg_UpdateAbortRequest)"));
   bool success=_pCtrl->bAbortAllRequest();
   // send result directly, further communication via state
   ETG_TRACE_USR1(("CtrlHmiGeneric::vProcess(Msg_UpdateAbortRequest): success=%u", success));
   FcSwUpdSrv::instance()->sendUpdateAbortResponse(success);
   
}



tVoid CtrlHmiGeneric::vOnCtrlResult(bool success) {
   ETG_TRACE_USR1(("CtrlHmiGeneric::vOnCtrlResut() success=%u", success)); 

   if(!_pCtrl->isScomoModeNormal()) {
      setHmiState(tenPrjState_Result);
   }
} 

tVoid CtrlHmiGeneric::getNeededResourceOnIn(tenReqMode &enResMode) {
   ETG_TRACE_USR4(("CtrlHmiGeneric::getNeededResourceOnIn - START"));

   enResMode = _enReqMode_invalid;
   if(_staticConfig.needsSpmSwUpdateMode) {
      enResMode = _enReqMode_spmSWUMode;
   } else if(_persistConfig.needsUpdateLock.get()) {
      enResMode = _enReqMode_lock;           
   }

   ETG_TRACE_USR4(("CtrlHmiGeneric::getNeededResourceOnIn - END mode:%u", ETG_CENUM(tenReqMode, enResMode)));
}

tVoid CtrlHmiGeneric::getNeededResourcesOnRun(tenReqMode &enResMode, std::set<std::string> &resList) {

   ETG_TRACE_USR4(("CtrlHmiGeneric::getNeededResourcesOnRun - START"));
   enResMode = _enReqMode_invalid;                 
   resList.clear();

   if (_persistConfig.needsUpdateLock.get() && checkForLocks() ) {   
      if(_updateLocks.size() > 0) {
         enResMode = _enReqMode_lock;           
         std::set<std::string> tmpList(_updateLocks.begin(), _updateLocks.end());
         resList = tmpList;
      }
    }
    ETG_TRACE_USR4(("CtrlHmiGeneric::getNeededResourcesOnRun - END mode:%u", ETG_CENUM(tenReqMode, enResMode)));
}

bool CtrlHmiGeneric::checkForLocks() {

   ETG_TRACE_USR4(("CtrlHmiGeneric::checkLocks"));
   _updateLocks.clear();
   CtrlProgItem progItem = _pCtrl->getCurrentProgItem();
   if(progItem.isValid()) {          
      if(!progItem.isItemChildValid("LOCK_STATE")) {
         _updateLocks=progItem.getRequiredLocks();
         return true;
      }
   }   
   return false;
}


}
