#ifndef FCSWUPD_CTRL_H
#define FCSWUPD_CTRL_H

#include "map"
#include "util/swu_types.h"
#include "util/swu_memberList.hpp"
#include "util/swu_asfUtil.hpp"
#include "util/swu_timer.h"
#include "util/swu_robustFile.h"
#include "util/swu_xmlItem.h"
#include "main/fcswupd_component_inc.h"
#include "main/fcswupd_mainMessages.hpp"
#include "ctrl/fcswupd_ctrlXmlUtil.h"
#include "ctrl/fcswupd_ctrlProgress.h"
#include "main/fcswupd_propDevMgr.h"

/*
modes:
a) only engineering mode.
b) only usb stick recovery mode.
c) only hmi mode sw-update.
d) hmi mode + recovery mode + normal mode update. (scomo)
e) postimage mode
f) compactability mode update
g) special mode 
h) scomo-index (oem update)
*/



class TiXmlElement;

namespace ai_sw_update {
namespace common{
namespace core {
namespace imp {
namespace SWUCoreService {
class SWUCoreServiceProxy;
}
}
}
}
}


namespace fcswupdate {

typedef enum {
   tenErrorHandling_invalid,
   tenErrorHandling_skip,
   tenErrorHandling_retry,
   tenErrorHandling_abort,
   tenErrorHandling_interact
} tenErrorHandling;


struct Msg_CtrlHandleError: public swu::Msg< Msg_CtrlHandleError, FcSwUpdRoot > {
   Msg_CtrlHandleError(tenErrorHandling errorHandling_):
      errorHandling(errorHandling_){};
   virtual tVoid vTrace(){};
   
   tenErrorHandling errorHandling;
};


class Msg_CurrentBoschXmlChanged;
/*
  start flasing of a sub-module
 */
   struct Msg_NotifyStartModInstall: public swu::Msg<Msg_NotifyStartModInstall, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyStartModInstall(CtrlProgItem const &itemData, 
                                bool &sendToCore,
                                uint32_t &res):
         _itemData(itemData),
         _sendToCore(sendToCore),
         _res(res)
      {};

      CtrlProgItem const &_itemData;
      bool &_sendToCore;
      uint32_t &_res;
   };




typedef enum {
   enCtrlReadyAction_invalid,
   enCtrlReadyAction_reboot,
   enCtrlReadyAction_shutdown,
   enCtrlReadyAction_idle,
   enCtrlReadyAction_blocking,
   enCtrlReadyAction_enterPreResult
} tenCtrlReadyAction;

typedef enum {
   enCtrlReadyMode_success,
   enCtrlReadyMode_intermediate,
   enCtrlReadyMode_failed
} tenCtrlReadyMode;

typedef enum {
   enCtrlReadInterval_Ms,
   enCtrlReadInterval_Seconds,
   enCtrlReadInterval_Minutes,
   enCtrlReadInterval_None,
} tenCtrlReadyInterval;


struct CtrlReadyAction {
   CtrlReadyAction():
      enMode(enCtrlReadyMode_success),
      enAction(enCtrlReadyAction_invalid),
      enInterval(enCtrlReadInterval_None),
      u32NumIntervals(0),
      clearOnDone(true)
   {}
   tU32 getIntervalMs() {
      switch (enInterval) {
         case enCtrlReadInterval_Seconds:
            return 1000;
         case enCtrlReadInterval_Minutes:
            return 1000 * 60;
         case enCtrlReadInterval_Ms:
         default:
            return 1;
      }
   }


   char const *actionToString() {
      switch (enAction) {
         case enCtrlReadyAction_reboot:
            return "Reboot";
         case enCtrlReadyAction_shutdown:
            return "Shutdown";
         case enCtrlReadyAction_idle:
         default:
            return "enter Idle";
      }
   }

   tenCtrlReadyMode enMode;
   tenCtrlReadyAction enAction;
   tenCtrlReadyInterval enInterval;
   tU32 u32NumIntervals;
   std::string line1;
   std::string line2;
   bool clearOnDone;
};

struct Msg_CtrlReady: public swu::Msg< Msg_CtrlReady, FcSwUpdRoot > {
   Msg_CtrlReady(CtrlReadyAction readyAction):
      _readyAction(readyAction) 
   { }
   virtual tVoid vTrace();
   CtrlReadyAction _readyAction;
};

struct Msg_ConfigPrjReadyAction : public swu::Msg<Msg_ConfigPrjReadyAction, FcSwUpdRoot> {
	Msg_ConfigPrjReadyAction(CtrlReadyAction readyAction):
		_prjreadyAction(readyAction)
		{}
	   virtual tVoid vTrace() { }
	tenCtrlReadyMode _enReadyMode;
	CtrlReadyAction _prjreadyAction;
};
struct Msg_PrjCtrlResult : public swu::Msg<Msg_PrjCtrlResult, FcSwUpdRoot> {
        virtual tVoid vTrace(){ }
};
struct Msg_TimeOutInstall {
};

struct Msg_TimeOutAbortInstall {
};


struct Msg_EnterUpdateSessionResponse;
struct Msg_ExitUpdateSessionResponse;
struct Msg_ProgressUpdate;
struct Msg_DisplayTextUpdate;
struct Msg_StartInstallResponse;
struct Msg_AbortInstallResponse;
struct Msg_ReInitializeCampaign;
struct Msg_ResourceManagerChanged;
struct Msg_StartInstallResponseSignal; 

class XmlFile;
class HistoryRelease;


class Ctrl;
class CtrlAdapter: public swu::Member<FcSwUpdRoot> {
public:
   CtrlAdapter(Ctrl *pCtrl);

   virtual ~CtrlAdapter();

   // configuration of Ctrl
   virtual tVoid setHmiState(tenPrjState enState) {
      SWU_TRACE_VARG_USR1("CtrlAdapter::setHmiState(%u)", ETG_CENUM(tenPrjState, enState));
      Msg_NotifyPrjState msg(enState);
      notify(msg);
   }

   // notifications from Ctrl   
   virtual tenErrorHandling enOnCtrlError(std::list< uint32_t > const &errors) {
      SWU_TRACE_VARG_USR1("CtrlAdapter::enOnCtrlError()");
      setHmiState(tenPrjState_Error);
      return tenErrorHandling_abort;
   };

  virtual tVoid getNeededResourcesOnRun(tenReqMode &enResMode, std::set<std::string> &resList) {
      enResMode = _enReqMode_invalid;                                            
      resList.clear();
   }

   virtual tVoid getNeededResourceOnIn(tenReqMode &enResMode) {
      enResMode = _enReqMode_invalid;                                            
   }

   virtual tVoid vOnCtrlResult(bool success) {
      if(success) {
         setHmiState(tenPrjState_Result);
      } else {
         setHmiState(tenPrjState_Error);
      }
   }

   virtual tVoid vOnCtrlRunning(){
      SWU_TRACE_VARG_USR1("CtrlAdapter::vOnCtrlRunning()");
      setHmiState(tenPrjState_Running);  
   };

   virtual tVoid vOnCtrlAborting() {
      SWU_TRACE_VARG_USR1("CtrlAdapter::vOnCtrlAborting()");
      setHmiState(tenPrjState_Aborting);
   }

   virtual tVoid vOnCtrlWaitRecoveryAllowed(){
      setHmiState(tenPrjState_WaitAllowRecoveryMode);
   };

   virtual tVoid vOnCtrlReconnectInvalidStick(){
      SWU_TRACE_VARG_USR1("CtrlAdapter::vOnCtrlAborting()");
      setHmiState(tenPrjState_SelectRelease);
   }

   virtual bool getRemoveStickMessage(std::string &line1, std::string &line2) {
      line1 ="Please wait for the system to restart";
      line2="System will Reboot once the Update Media is removed";
      return true;
   }

   /* give adapter to modify the persistent config when progress-section is created */
   virtual void modifyConfig(CtrlPersistentConfig &ctrlConfig) {};  

   /* give adapter to modify the static config when progress-section is created or restored */     
   virtual void modifyConfig(CtrlStaticConfig &ctrlConfig) {};            
   
   virtual void modifyCtrlResultAction(bool updateSuccess,  CtrlReadyAction *readyAction) {};

   //todo: not used, need to check for implementation
   virtual tVoid vOnCtrlRebooting() {};
   //todo: not used, need to check for implementation
   virtual tVoid vOnCtrlDone() {};
   //todo: not used, need to check for implementation
   virtual void vOnDeviceSucceed(std::string deviceName, bool success) {};
   //todo: not used, need to check for implementation
   virtual void vOnUpdateInstalled(bool success, std::string const &trainname){};
 
   // identification
   virtual tenSwUpdateMode enSwUpdateMode()=0;

protected:
   Ctrl *_pCtrl;
};

// Central Ctrl-class, common for all modes
class Ctrl: public swu::Member<FcSwUpdRoot> {

   struct Msg_TerminateTimer {      
   };

   struct Msg_InstallFailedTimer {
      tU32 u32Error;
      Msg_InstallFailedTimer():u32Error(0){};
   };

   struct Msg_FullOpResultSupervisionTimer {      
   };


   typedef enum {
      tenState_Initial=0,
      tenState_In=1,
      tenState_Run = 2,
      tenState_Result = 3,
      tenState_Out=4,
      tenState_Done = 5,
      // unrecoverable error:
      tenState_SystemError = 6,
   } tenState;


   typedef enum {
      // way in
      tenInState_Initial = 1,
      tenInState_WaitRunCommand = 2,
      tenInState_WaitResources = 3, 
      tenInState_WaitSwUpdCoreSessionStart = 4,
      tenInState_WaitProgressSection = 5,
   } tenInState;


   typedef enum {
      // way in
      tenRunState_Initial = 1,
      tenRunState_FetchItem = 2,
      /*
        we must feth the item first, since needed resource are evaluated from it.
       */
      tenRunState_WaitResources = 3,
      tenRunState_WaitStick = 4,
      tenRunState_WaitStartInstallResponse = 5,
      tenRunState_Done = 6,
      tenRunState_Error = 7,
   } tenRunState;


   typedef enum {
      // way out
      tenOutState_Initial = 1,
      tenOutState_WaitSwUpdCoreSessionEnd = 2,
      tenOutState_WaitReleaseResources = 3,
      tenOutState_WaitRecoveryAllowed = 4,
      tenOutState_WaitStickRemoved = 5,
      tenOutState_Terminate = 6,
      tenOutState_DeInit = 7,
      tenOutState_Done = 8,
   } tenOutState;

   typedef  enum {
      tenStickState_initial,
      tenStickState_ok,
      tenStickState_missing,
      tenStickState_recovered,
   } tenStickState;
   

private:
   Ctrl & operator=(const Ctrl &);
   Ctrl(const Ctrl &);

public:
   Ctrl(CtrlProgressSection* ctrlProgress, tenSwUpdateMode enMode=tenSwUpdateMode_Invalid, TiXmlDocument *xmlDoc=0);

   static const std::string k_UPDATE_STATE_RUNNING;
   static const std::string k_UPDATE_STATE_NEXT_RELEASE;
   static const std::string k_UPDATE_STATE_RESULT;
  
   virtual ~Ctrl();
   virtual const char *getName() {
      return "Ctrl";
   }

   virtual void traceState();  
   void traceCtrlStates();  

   virtual tVoid vInit();
   virtual tVoid vDeInit();
   virtual tVoid vRun();

   // method result for EnterUpdateSessionRequest
   tVoid vProcess(Msg_EnterUpdateSessionResponse *pMsg);
   /* This method is called when a downloadtask is done by the FC Download Core and gives us the result, 
   @param pMsg Pointer to the result of the Start Install call, so the result of the installation.     
   */
   tVoid vProcess(Msg_StartInstallResponse *pMsg); 
   tVoid vProcess(Msg_StartInstallResponseSignal *pMsg);   
   tVoid vProcess(Msg_ProgressUpdate *pMsg);
   tVoid vProcess(Msg_TerminateTimer *pMsg);                  // interface to SpmIf
   tVoid vProcess(Msg_InstallFailedTimer *pMsg);
   tVoid vProcess(Msg_FullOpResultSupervisionTimer *pMsg);
   tVoid vProcess(Msg_TimeOutInstall *pMsg);
   tVoid vProcess(Msg_TimeOutAbortInstall *pMsg);
   tVoid vProcess(Msg_CurrentBoschXmlChanged *pMsg);
   tVoid vProcess(Msg_ProgressSectionChanged *pMsg);
   tVoid vProcess(Msg_CtrlHandleError *msg);  // private
   tVoid vProcess(Msg_ConfigChanged *pMsg); 
   tVoid vProcess(Msg_ResourceManagerChanged *msg);
   tVoid vProcess(Msg_DisplayTextUpdate *pMsg);
   // method result for AbortInstallRequest
   tVoid vProcess(Msg_AbortInstallResponse *pMsg);   
   // method result for ExitUpdateSessionRequest      
   tVoid vProcess(Msg_ExitUpdateSessionResponse *pMsg);    
   tVoid vProcess(swu::Msg_ProxyAvailability< FCSWUPD_NS_SWUCORE::SWUCoreServiceProxy, FcSwUpdRoot > *pMsg);
   tVoid vProcess(Msg_NextRequest *pMsg);

   bool vRetryFailedModules();
   tVoid vHandleError(tenErrorHandling enMode);

   bool bAbortAllRequest();
   bool vUpdateEndRequest();
   bool wasStickRemoved();
   bool setNewFcid();
   bool isOtaUpdate();
   bool isInDownloadMode();
   bool isMISRunning();

   tVoid vEnterStateWaitRecoveryAllowed();
   tVoid vAllowRecoveryMode();

   static void setSendAutoInstallResponse(bool val);
   static void allowRebootDuringInstall(bool val);
   static void setDefaultDecision(uint8 u8Decision);

   void updateProgressText(std::string line1, std::string line2="", std::string luaCmd="", bool force=true);
   void updateProgressTextItem(std::string const &newVal, std::string &val, bool force, bool &changed);
   void nextRequested();
   void killMISUpdater();

   CtrlProgItem getCurrentProgItem() {
      return _curProgItem;
   }

   bool isScomoMode() {
      return (Config::instance()->cfg_EnterFullOperation.get() &&
              (getInitialMode()==tenSwUpdateMode_Scomo));
   }

   bool isScomoModeNormal() {
      return isScomoMode() && !isFirmwareComponentId();
   }

   bool isScomoModeFirmware() {
      return isScomoMode() && isFirmwareComponentId();
   }

   bool isFirmwareComponentId() {
      return (PropDevMgr::instance()->getComponentId() == "FIRMWARE");
   }


   tenSwUpdateMode getInitialMode() {
      return _persistentConfig.enInitialMode.get();
   }

   const std::string getActualMediaPath() const {
      return _progSection->getMediaPath();
   }

   //TTIf's cmd
   void simSpoofingStatus(tUInt bstatus);
   void simRunStateTransistion(tUInt state);
   
      
protected:
   void vNotifyReady();

private:
   tVoid setInitVals();   
   tVoid setState(tenState enNewState);
   tVoid setInState(tenInState enNewInState);
   tVoid setRunState(tenRunState enNewRunState);
   tVoid setOutState(tenOutState enNewOutState);

   // main state transitions
   tVoid vEnterStateIn();
   tVoid vEnterStateRun();
   tVoid vEnterStateResult();   
   tVoid vEnterStateOut();

   // in-state transitions
   tVoid vEnterInStateWaitResources();
   tVoid vEnterInStateWaitSwUpdCoreSessionStart();
   tVoid vEnterInStateWaitProgressSection();

   // run-state transitions
   tVoid vEnterRunStateFetchItem();
   tVoid vEnterRunStateWaitResources();
   tVoid vEnterRunStateWaitStick();
   tVoid vEnterRunStateWaitStartInstallResponse();
   tVoid vEnterRunStateError(std::list < uint32_t > const &errors);

   // out-state transitions
   tVoid vEnterOutStateWaitReleaseResources();
   tVoid vEnterOutStateWaitRecoveryAllowed();
   tVoid vEnterOutStateWaitStickRemoved();
   tVoid vEnterOutStateTerminate();

   tVoid vEnterStateSystemError();

   tVoid generateProgressSection();

   tVoid onUpdateSuceed(bool succeeded, bool stopUpdate=false);

   bool startNextUpdate();
   void enterPostInstallPhase();
   bool isSpecialUpdate();

   bool sendStartInstallRequest();
   bool sendStartInstallRequestToCore();

   void updateProgress();
   void cleanupConfigFiles();
   void cleanupKdsConfigFile();
   bool getPredefinedKvPairs(std::map< std::string, std::string > &kvPairs);

   ProgressInformation &accessProgressInfo();
   void notifyProgressProp();

   /** @brief Prepare registry file with customer version string.  
    *
    * Delete the old customer version file and write a new one on the 
    * persistent partition, @see swu::Constants::Registry.
    * The version contains customer version, build version and build version 
    * label concatenated by "_". It is read from the OVERALL section of the 
    * bosch.xml, which should contain:
    * <pre>
    * <BOSCHXML> ...
    *    <OVERALL> ...
    *       <BUILD_LABEL>AI_PRJ_RN_AIVI_15.0V42</BUILD_LABEL>
    *       <FINALNAME>5241_150612</FINALNAME>
    *       <FINALNAME_CUSTOMER>A100</FINALNAME_CUSTOMER> ...
    *    </OVERALL> ...
    * </BOSCHXML>
    * </pre>
    * */
   void updateCustomerVersionOnTarget(bool success);
   void printModuleDuration();
 
   bool checkAllowMisCmcRelease();
   void updateMisResult(bool success);
   void createMisPendingMarkerFile(const std::string misPendingMarkerFile);

   void updateOverallCISSWVersiononTarget(bool success);
   bool getMisUpdateResult();
   bool getMcpUpdateResult();
 
private:      
          
   // this flag has to be set when you are spoofing yourself         
   static bool _isttifsSpoofing;            
   /* Flag to be set by ttfis. if set, ctrl will generate answers to each StartInstallRequest                
    */
   static bool _sendAutoInstallResponse;   
   /* For testing: overwrite default-decision of adapters, 
      if value is !=    update_decision_setting_type__invalid                  
   */
   static update_decision_setting_type _defaultDecision;    
   
   // action to deInit the ctrl.
   CtrlReadyAction _ctrlReadyAction; 
   // create on start of update, restore from progress-section later                     
   CtrlPersistentConfig _persistentConfig;  
   // setting from the current adapter             
   CtrlStaticConfig _staticConfig; 
   // Pointer the currently processed Item in Progress Section. Only valid in State running.                       
   CtrlProgItem _curProgItem;       
   // progress instance.                      
   CtrlProgressSection *_progSection;  
   // Config::instance                   
   Config *_cfg;                                          
   // Adapter to the controlling instance (e.g. HMI)     
   CtrlAdapter *_pAdapter;   
   /* This document holds the Progress Section and anything else, 
      Release-Section will be removed, as it shall not be persisted.                        
   */
   TiXmlDocument *_xmlDoc;                               


   CtrlProgressSection::tenState _lastProgSectionState;   
   // USB stick state. 
   tenStickState _enStickState;                           
   // Identifies the kind of CtrlAdapter used here.
   tenSwUpdateMode _enMode;                               
   tenState _enState;
   tenInState _enInState;
   tenRunState _enRunState;
   tenOutState _enOutState;

   /* A List holding Members, 
     which have to Initialized on Startup and deinitialized on shutdown.                             
   */
   swu::MemberList<FcSwUpdRoot> _memberList;              
   // actual errors 
   std::list< uint32_t > _errors;         
   // Extra Args for the whole release we are running at the moment                
   std::map< std::string, std::string > _releaseExtraArgs;  


   swu::SwUpdTimer< Ctrl, Msg_TimeOutInstall > _installTimer;
   swu::SwUpdTimer< Ctrl, Msg_TimeOutAbortInstall > _abortInstallTimer;
   swu::SwUpdTimer< Ctrl, Msg_TerminateTimer > _terminateTimer;
   swu::SwUpdTimer< Ctrl, Msg_InstallFailedTimer > _installFailedTimer;
   swu::SwUpdTimer< Ctrl, Msg_FullOpResultSupervisionTimer > _fullOpResultSupervisionTimer;


   bool _coreProxyAvailable;
   bool _coreSessionStarted;
   bool _firstResult;
   // true if we shall abort
   bool _abort;                                           
   // todo: check whether it can be removed
   bool _needWaitRecoveryAllowed;                         
   // true if we shall skip the actual device
   bool _skip;                                            


   // the module id which is currently updated by download core
   std::string _curRefKey;                                
   // Path to the used mounted download medium
   std::string _media_path;                               
   
   tU32 _startInstallSendTimeStampSec;
   // number of tries for current item
   tUInt _numCurFailed;                                   
   // time duration of a module.
   time_t _updateStartTime;                               


};


}



#endif







