#ifndef FCSWUPD_CONFIGIRATOR_RECOVERY_H
#define FCSWUPD_CONFIGIRATOR_RECOVERY_H

#include "util/swu_xmlDoc.h"
#include "tinyxml/tinyxml.h"
#include "util/swu_util.hpp"
#include "main/fcswupd_systemData.h"
#include "configurator/fcswupd_configurator.h"
#include "configurator/fcswupd_configuratorUtil.h"

namespace fcswupdate {

class Msg_NotifyDevManagerChanged;

class ConfiguratorRecoveryGeneric: public Configurator {
   
   struct Msg_InitialConfiguratorTimer {      
   };

public:
   typedef enum {
      enState_Initial,
      enState_SearchRelease,
      enState_FoundRelease,
      enState_Terminated,
   }tenState;


   // constructor and destructor
   ConfiguratorRecoveryGeneric();
   virtual ~ConfiguratorRecoveryGeneric();

   virtual tVoid vInit(); // post construction setup
   virtual tVoid vDeInit(); // pre destruction clean up	- relies on others calling this

   virtual const char *getName() {
      return "ConfiguratorRecoveryGeneric";
   }

   virtual TiXmlDocument *getXmlDoc();

   virtual void traceState();

   // message from device-manager
   tVoid vProcess(Msg_NotifyDevManagerChanged *pMsg);
   tVoid vProcess(Msg_InitialConfiguratorTimer *pMsg);

private:
   tVoid findReleaseXml();
   tenState	     _enState;
   TiXmlDocument *_releaseXml;
   ConfiguratorUtil::tenConfigOption _enFilterOption;

   struct RelInfo {
      RelInfo():overallSection("") {};
      TiXmlElement overallSection;
      trSourceInfo rSourceInfo;
      bool operator<(RelInfo const &r) const;
   };

   typedef enum {
      enConfigTrigger_DevManagerChanged,
      enConfigTrigger_SetReleaseFilter,
      enConfigTrigger_SetUdateOptions,
      enConfigTrigger_Invalid
   } tenConfigTrigger;
   tenConfigTrigger _enConfigTrigger;

   ConfiguratorUtil _util;
   swu::SwUpdTimer<ConfiguratorRecoveryGeneric, Msg_InitialConfiguratorTimer> _initTimer;

private:
   tVoid vSetSWUHMIState(tenPrjState newState);
   bool filterPassed(RelInfo  const &checkRelInfo);
   ConfiguratorUtil::tenConfigOption getOverallReleaseFilter(TiXmlElement const &overallSection);
   bool hasMediumFormatSupported(std::string path);
   bool isIncompactMediumCanProceed(std::string path, tenSwUpdateError& status);

};

}
#endif
