#ifndef FCSWUPD_CONFIGIRATOR_RECOVERY_H
#define FCSWUPD_CONFIGIRATOR_RECOVERY_H

#include "util/swu_xmlDoc.h"
#include "tinyxml/tinyxml.h"
#include "util/swu_util.hpp"
#include "main/fcswupd_systemData.h"
#include "configurator/fcswupd_configurator.h"

namespace fcswupdate {


class MIB_Parser;


class ConfiguratorEngineering: public Configurator {
public:
typedef enum {
   enState_Initial,
   enState_SearchRelease,
   enState_FoundRelease,
   enState_Terminated,
}tenState;


	// constructor and destructor
	ConfiguratorEngineering();
	virtual ~ConfiguratorEngineering();

	virtual tVoid vInit(); // post construction setup
	virtual tVoid vDeInit(); // pre destruction clean up	- relies on others calling this

	virtual const char *getName() {
		return "ConfiguratorEngineering";
	}

	virtual TiXmlDocument *getXmlDoc();

	virtual void traceState();

        virtual tVoid vProcess(Msg_NotifyDevManagerChanged *pMsg);


private:
   tVoid findReleaseXml();
   tVoid vFetchBoschXmlDoc();
   tVoid checkV850CompatUpdate(TiXmlDocument *releaseDoc);
   tenState	     _enState;
   TiXmlDocument *_releaseXml;

};

}
#endif
