#include "util/swu_member.hpp"
#include "tinyxml/tinyxml.h"
#include "util/fcswupd_types.hpp"
#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "configurator/fcswupd_configurator.h"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_CONFIGURATOR
#include "trcGenProj/Header/fcswupd_configurator.cpp.trc.h"
#endif 


namespace fcswupdate {
using namespace fcswupdate;

void Configurator::vNotifyReady(bool bFlashIt) {
   /*
     we want to be deleted, so we have to send a async notification
     to get removed from the callstack first
   */

   Msg_ConfiguratorReady *pMesg = OSAL_NEW Msg_ConfiguratorReady(bFlashIt);
   SWU_ASSERT_RETURN(pMesg);
   pMesg->bNotifyLater();
   pMesg = 0;

}

tVoid Msg_ConfiguratorReady::vTrace() {
   ETG_TRACE_USR4(("Msg_ConfiguratorReady (_bFlashIt=%u)", _bFlashIt));
}



}
