/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
***************************************************************************/
/*!
*\file     SWULCMComponent.h
*\brief    hand crafted code
*
*\par Copyright:
*(c) 2012-2013 Robert Bosch Car Multimedia GmbH
***************************************************************************/

#ifndef SWULCMCOMPONENT_H_
#define SWULCMCOMPONENT_H_


#include "asf/core/ApplicationIF.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "platform/imp/wdgHandler.h"


namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {


class SWULCMComponent
: public ::asf::core::BaseComponent
, public ::asf::core::TimerCallbackIF
{
public:
  SWULCMComponent();
  virtual ~SWULCMComponent(); //@todo check lint: Warning 1510: base class 'TimerCallbackIF' has no destructor


  /**
   * Default interval for sending message WUP_EXTEND_POWER_OFF_TIMEOUT in ms.
   * http://hi0vm019.de.bosch.com/wiki/index.php?title=/dev/wup#OSAL_C_S32_IOCTRL_WUP_EXTEND_POWER_OFF_TIMEOUT
   */
  static const uint32 DEFAULT_WUP_EXTENDED_POWER_OFF_TRIGGER_INTERVAL_MS = 60000;


  /**
   * Default extended power off timeout in sec.
   * http://hi0vm019.de.bosch.com/wiki/index.php?title=/dev/wup#OSAL_C_S32_IOCTRL_WUP_EXTEND_POWER_OFF_TIMEOUT
   */
  static const uint16 DEFAULT_WUP_EXTENDED_POWER_OFF_TIMEOUT_SEC = 7200;


  /**
	* Expired timer callback
	* @param timer ID of timer for distinguishing multiple timers.
	* @param data User specific data attached to timer (not used here).
	*/
  virtual void onExpired(::asf::core::Timer& timer, boost::shared_ptr< ::asf::core::TimerPayload > data);


private:
  // Disallow copy and assign by defining the method but not implement them
  SWULCMComponent(const SWULCMComponent &orig);
  void operator=(const SWULCMComponent &orig);

  WDGControl _WdgCtrl;
  ::asf::core::Timer _TimerWUPExtendPowerOff; //!< ASF timer

  static const int      EVENT_MASK_STOP=0x01000000;
  volatile bool         AckThreadRunning;
  volatile bool         EventNameValid;
  volatile const char   *EventName;

  void sendMsgWUPExtendPowerOffTimeout();
  void sendMsgWUPIndicateStartupFinished();
  static void *acknowledgeWUPReasonsThread(void *Arg);

  DECLARE_CLASS_LOGGER ();
};


} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update


#endif // SWULCMCOMPONENT_H_
