#ifndef AI_SW_UPDATE_COMMON_BASE_GEN2_ADMINDATACHECK_H_
#define AI_SW_UPDATE_COMMON_BASE_GEN2_ADMINDATACHECK_H_


// Ported functionality from Gen2 DL-Core
// @todo: Refactor to C++ class, remove OSAL


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace ai_sw_update {
namespace common {
  
typedef struct
{
   tU32 u32Config1;
   tU32 u32Config2;
   tU32 u32Version1; // yymmddhh
   tU32 u32Version2;
   tU32 u32Magic1;   // 0xCEADDECE
   tU32 u32Magic2;   // 0x31522131/SW_TYPE
   tU32 u32Length;
   tU32 u32CRC;
}  tR_SW_ADMIN_DATA;


#define SIZE_FLASH_ADMIN_DATA         ((tU32) 0x00000020) // 32 bytes flash SW admin data size
#define MAGIC_VALUE                   ((tU32) 0xCEADDECE) // Magic Value to indicate valid admin data
#define MAGIC_VALUE2                  ((tU32) 0x31522131) // Magic Value to indicate valid admin data

tVoid bInitAdminData (tR_SW_ADMIN_DATA *adminData);


/******************************************************************************************
*
* FUNCTION:   dl_tclDABPlusMain::u32GetSizeOfAdmin()
*
* DESCRIPTION:  calculate the size of the admin block (with crc etc.) at the end of the file
*
* PARAMETER:  pu8Buffer, u32SizeOfFile
*
* RETURN VALUE: size of the admin block
*
******************************************************************************************/
// relocated from file dl_tclDABPlusMain.h/cpp
tU32 u32GetSizeOfAdmin(tPU8 pu8Buffer, tU32 u32SizeOfFile);

} // namespace ai_sw_update {
} // namespace common {


#endif //AI_SW_UPDATE_COMMON_BASE_GEN2_ADMINDATACHECK_H_
