#include "gen2_AdminData.h"
#include "swupd_trace.h"

//************ TRACE IF ***************************************************
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_BASE
#include "trcGenProj/Header/gen2_AdminData.cpp.trc.h"
#endif  // VARIANT_S_FTR_ENABLE_TRC_GEN
//************ TRACE IF ***************************************************

//@todo: add tracing, refactor to C++ class

namespace ai_sw_update {
namespace common {

tVoid bInitAdminData (tR_SW_ADMIN_DATA *adminData)
{
	tCString method = "bInitAdminData";
	ETG_TRACE_USR4 (("%s was entered", method));

	//pathological case
	if (0 != adminData)
	{
		//initialise all values to zero
		adminData->u32Config1  = 0;
		adminData->u32Config2  = 0;
		adminData->u32CRC      = 0;
		adminData->u32Length   = 0;
		adminData->u32Magic1   = 0;
		adminData->u32Magic2   = 0;
		adminData->u32Version1 = 0;
		adminData->u32Version2 = 0;
	}

	ETG_TRACE_USR4 (("%s was left", method));
}


tU32 u32GetSizeOfAdmin(tPU8 pu8Buffer, tU32 u32SizeOfFile)
{
  tCString method = "dl_tclDABPlusMain::u32GetSizeOfAdmin";
  ETG_TRACE_USR3 (("%s was entered", method));
	tU32  u32SizeOfAdmin;
	tBool bEndOfAdminFound  = FALSE;
	tPU8  pu8LastByteOfFile = pu8Buffer + u32SizeOfFile - 1;

	for( u32SizeOfAdmin = 0 ; !bEndOfAdminFound && (u32SizeOfAdmin < ( u32SizeOfFile - 8 )) ; u32SizeOfAdmin++)
	{
		 bEndOfAdminFound =
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 7)) == 'A') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 6)) == 'D') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 5)) == 'M') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 4)) == 'I') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 3)) == 'N') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 2)) == 'E') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 1)) == 'N') &&
				(*(pu8LastByteOfFile - (u32SizeOfAdmin + 0)) == 'D') ;

	  if(bEndOfAdminFound) 
			break;
	}
  ETG_TRACE_USR3 (("%s was left", method));
  return (u32SizeOfAdmin + 8 );
}

} // namespace ai_sw_update {
} // namespace common {

