/*******************************************************************************************
* FILE:			RegistryAccess.h
*
* SW-COMPONENT: Software Update
*
* DESCRIPTION: 
*				
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2014  2015 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*				18.02.2014	Aditya Kumar Jha
*				Initial Version.
********************************************************************************************/

#ifndef REGISTRY_ACCESS_H
#define REGISTRY_ACCESS_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "ai_osal_linux/components/system/system_types.h"
#include "swu_macros.h"


class RegistryAccess
{
    SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(RegistryAccess);

public:
	virtual tU32 u32RegWriteValue(tCString cDeviceName, tCString cKeyName, tString cKeyValue ) const;
	virtual tU32 u32RegCreateWriteValue(tCString cDeviceName, tCString cKeyName, tCString cKeyValue ) const;
	virtual tU32 u32RegReadValue(tCString cDeviceName, tCString cKeyName, tS8*   pcKeyValue ) const;

	RegistryAccess ();
	virtual ~RegistryAccess ();

};

SWU_DECL_GET_AND_RELEASE_INSTANCE(RegistryAccess);

#endif //REGISTRY_ACCESS_H




