/**
 * @file IsoContainer.h
 * @author kut2hi
 * @copyright (c) 2013 Robert Bosch Car Multimedia GmbH
 * @addtogroup ai_sw_update/common
 * @{
 */


#ifndef SWUC_BASE_ISOCONTAINER_H
#define SWUC_BASE_ISOCONTAINER_H

#include <string>

// If this #define is active and a directory with the same name exists without the .iso extension,
// it is mounted instead of the real container to simplify development
#ifdef REPLACE_ISO_BY_DIRECTORY
#error
#endif

namespace ai_sw_update {
namespace common {


/**
 * Class for mounting and unmounting an ISO container file.
 */
class IsoContainer
{
public:
  IsoContainer();
  ~IsoContainer();

  /**
   * Mounting of an ISO container file to a provided mount point.
   *
   * The returned value might be wrong because the underlying SystemCall::exec returns everytime a "true".
   *
   * @param inIsoContainerFile
   * @param inMountPoint
   * @return true in every case, no error checking possible right now.
   */
  const bool mount(
    const std::string & inIsoContainerFile,
    const std::string & inMountPoint);



  /**
   * Unmounting of a mounted ISO container file which has been previously mounted by method mount()
   */
  void umount();

private:
  std::string _isoContainerFile;
  std::string _mountPoint;
  bool _isMounted;
};


} // namespace common
} // namespace ai_sw_update


#endif // SWUC_BASE_ISOCONTAINER_H
