/*************************************************************************
* FILE:         ErrorHandler.h
* PROJECT:      Gen3
* SW-COMPONENT: SW Update
*----------------------------------------------------------------------
*
* DESCRIPTION:  Gen3 Software Update Error Handler
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author        | Modification
*
* 2014-02-12  W.Stautz		  01.00
* 2014-02-27  W.Stautz		  01.01
**************************************************************************/
#ifndef DL_ERROR_HANDLER_H
#define DL_ERROR_HANDLER_H

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

//#define OSAL_S_DISABLE_OVERLOAD_NEW
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace ai_sw_update {
namespace common {

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

// -------------------- Defines for writing to the error memory ----------------
#define DNL_ERR_TMP_FILE "/tmp/ErrorHandler.tmp"
//#define DNL_ERR_CMD1     "cat /tmp/ErrorHandler.tmp > /dev/errmem"
//#define DNL_ERR_CMD2     "cat /tmp/ErrorHandler.tmp >> /tmp/downloadPipe"

#define SW_UPDATE_ERROR_ARRAY_SIZE  10  // Array can store 10 errors
#define SW_UPDATE_ERROR_TEXT1_SIZE 255
#define SW_UPDATE_ERROR_TEXT2_SIZE 255
#define SW_UPDATE_ERROR_MEM_MAX_LENGTH 200

// Error texts for devices
#define	SW_UPDATE_ERROR_TEXT_DEVICE_RAM					"RAM             "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NOR_RAW		"NOR_RAW         "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NOR_FFS		"NOR_FFS         "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NAND_FFS		"NAND_FFS        "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_KDS			"KDS             "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_V850				"V850            "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_SXM					"SXM             "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_ADR3				"ADR3            "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_TESEO				"TESEO           "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_DTV 				"DTV           "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_BLUETOOTH			"BLUETOOTH       "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_SOURCE_MEDIA		"SOURCE_MEDIA    "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_IMAGE				"IMAGE           "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_SCRIPT				"SCRIPT          "
#define	SW_UPDATE_ERROR_TEXT_DEVICE_UNKNOWN				"UNKNOWN         "
#define SW_UPDATE_ERROR_TEXT_DEVICE_MCP                          "MCP            "

// Error texts for error types
#define	SW_UPDATE_ERROR_TEXT_TYPE_NOT_RDY				"NOT_RDY               "
#define	SW_UPDATE_ERROR_TEXT_TYPE_READ					"READ                  "
#define	SW_UPDATE_ERROR_TEXT_TYPE_ERASE					"ERASE                 "
#define	SW_UPDATE_ERROR_TEXT_TYPE_WRITE					"WRITE                 "
#define	SW_UPDATE_ERROR_TEXT_TYPE_VERIFY				"VERIFY                "
#define	SW_UPDATE_ERROR_TEXT_TYPE_CHECKSUM				"CHECKSUM              "
#define	SW_UPDATE_ERROR_TEXT_TYPE_MEMORY_SIZE			"MEMORY_SIZE           "
#define	SW_UPDATE_ERROR_TEXT_TYPE_INVALID				"INVALID               "
#define	SW_UPDATE_ERROR_TEXT_TYPE_INVALID_SECTORHEADER	"INVALID_SECTORHEADER  "
#define	SW_UPDATE_ERROR_TEXT_TYPE_MSG_DIG_SIG_MISMATCH	"MSG_DIG_SIG_MISMATCH  "
#define	SW_UPDATE_ERROR_TEXT_TYPE_LIC_DIG_SIG_MISMATCH	"LIC_DIG_SIG_MISMATCH  "
#define	SW_UPDATE_ERROR_TEXT_TYPE_FILES_NOT_AVAILABLE	"FILES_NOT_AVAILABLE   "
#define	SW_UPDATE_ERROR_TEXT_TYPE_NOT_AVAILABLE		    "IS_NOT_AVAILABLE      "
#define	SW_UPDATE_ERROR_TEXT_TYPE_COMPATIBLE_MISMATCH	"COMPATIBLE_MISMATCH   "
#define	SW_UPDATE_ERROR_TEXT_TYPE_CHANGE_BOOTMODE		"CHANGE_BOOTMODE       "
#define	SW_UPDATE_ERROR_TEXT_TYPE_SCRIPT_LOAD			"SCRIPT_LOAD           "
#define	SW_UPDATE_ERROR_TEXT_TYPE_SCRIPT_EXECUTE		"SCRIPT_EXECUTE        "
#define	SW_UPDATE_ERROR_TEXT_TYPE_UNKNOWN_ERROR			"UNKNOWN_ERROR         "
#define	SW_UPDATE_ERROR_TEXT_TYPE_RETRY_RECOVERY			"RETRY_RECOVERY         "
#define	SW_UPDATE_ERROR_TEXT_TYPE_RETRY_ALL_RECOVERY			"RETRY_ALL_RECOVERY         "

// -----------------------------------------------------------------------------
// data declarations
// -----------------------------------------------------------------------------

// SwUpdate devices:
enum SwUpdateDevice
{
	SW_UPDATE_ERROR_DEVICE_RAM,
	SW_UPDATE_ERROR_DEVICE_FLASH_NOR_RAW,
	SW_UPDATE_ERROR_DEVICE_FLASH_NOR_FFS,
	SW_UPDATE_ERROR_DEVICE_FLASH_NAND_FFS,
	SW_UPDATE_ERROR_DEVICE_FLASH_KDS,
	SW_UPDATE_ERROR_DEVICE_SXM,
	SW_UPDATE_ERROR_DEVICE_V850,
	SW_UPDATE_ERROR_DEVICE_ADR3,
	SW_UPDATE_ERROR_DEVICE_TESEO,
	SW_UPDATE_ERROR_DEVICE_DTV,
	SW_UPDATE_ERROR_DEVICE_BLUETOOTH,
	SW_UPDATE_ERROR_DEVICE_SOURCE_MEDIA,
	SW_UPDATE_ERROR_DEVICE_IMAGE,
	SW_UPDATE_ERROR_DEVICE_SCRIPT,
        SW_UPDATE_ERROR_DEVICE_MCP,
	SW_UPDATE_ERROR_DEVICE_UNKNOWN,
	SW_UPDATE_ERROR_DEVICE_LAST
};
#ifdef DL_ERROR_HANDLER_DATA_INCLUDE
// Array with error device text
tCString StrUpdateDevice[SW_UPDATE_ERROR_DEVICE_LAST] =
{
	SW_UPDATE_ERROR_TEXT_DEVICE_RAM,
	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NOR_RAW,
	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NOR_FFS,
	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_NAND_FFS,
	SW_UPDATE_ERROR_TEXT_DEVICE_FLASH_KDS,
	SW_UPDATE_ERROR_TEXT_DEVICE_SXM,
	SW_UPDATE_ERROR_TEXT_DEVICE_V850,
	SW_UPDATE_ERROR_TEXT_DEVICE_ADR3,
	SW_UPDATE_ERROR_TEXT_DEVICE_TESEO,
	SW_UPDATE_ERROR_TEXT_DEVICE_DTV,
	SW_UPDATE_ERROR_TEXT_DEVICE_BLUETOOTH,
	SW_UPDATE_ERROR_TEXT_DEVICE_SOURCE_MEDIA,
	SW_UPDATE_ERROR_TEXT_DEVICE_IMAGE,
	SW_UPDATE_ERROR_TEXT_DEVICE_SCRIPT,
        SW_UPDATE_ERROR_TEXT_DEVICE_MCP,
	SW_UPDATE_ERROR_TEXT_DEVICE_UNKNOWN
};
#endif

//  SWUpdate errors:
enum SwUpdateErrorType
{
	SW_UPDATE_ERROR_TYPE_NOT_RDY,
	SW_UPDATE_ERROR_TYPE_READ,
	SW_UPDATE_ERROR_TYPE_ERASE,
	SW_UPDATE_ERROR_TYPE_WRITE,
	SW_UPDATE_ERROR_TYPE_VERIFY,
	SW_UPDATE_ERROR_TYPE_CHECKSUM,
	SW_UPDATE_ERROR_TYPE_MEMORY_SIZE,
	SW_UPDATE_ERROR_TYPE_INVALID,
	SW_UPDATE_ERROR_TYPE_INVALID_SECTORHEADER,
	SW_UPDATE_ERROR_TYPE_MSG_DIG_SIG_MISMATCH,
	SW_UPDATE_ERROR_TYPE_LIC_DIG_SIG_MISMATCH,
	SW_UPDATE_ERROR_TYPE_FILES_NOT_AVAILABLE,
	SW_UPDATE_ERROR_TYPE_NOT_AVAILABLE,
	SW_UPDATE_ERROR_TYPE_COMPATIBLE_MISMATCH,
	SW_UPDATE_ERROR_TYPE_CHANGE_BOOTMODE,
	SW_UPDATE_ERROR_TYPE_SCRIPT_LOAD,
	SW_UPDATE_ERROR_TYPE_SCRIPT_EXECUTE,
	SW_UPDATE_ERROR_TYPE_UNKNOWN_ERROR,
	SW_UPDATE_ERROR_TYPE_RETRY_RECOVERY,
	SW_UPDATE_ERROR_TYPE_RETRY_ALL_RECOVERY,
	SW_UPDATE_ERROR_TYPE_LAST
};
#ifdef DL_ERROR_HANDLER_DATA_INCLUDE
// Array with error type text
tCString StrUpdateErrorType[SW_UPDATE_ERROR_TYPE_LAST] =
{
	SW_UPDATE_ERROR_TEXT_TYPE_NOT_RDY,
	SW_UPDATE_ERROR_TEXT_TYPE_READ,
	SW_UPDATE_ERROR_TEXT_TYPE_ERASE,
	SW_UPDATE_ERROR_TEXT_TYPE_WRITE,
	SW_UPDATE_ERROR_TEXT_TYPE_VERIFY,
	SW_UPDATE_ERROR_TEXT_TYPE_CHECKSUM,
	SW_UPDATE_ERROR_TEXT_TYPE_MEMORY_SIZE,
	SW_UPDATE_ERROR_TEXT_TYPE_INVALID,
	SW_UPDATE_ERROR_TEXT_TYPE_INVALID_SECTORHEADER,
	SW_UPDATE_ERROR_TEXT_TYPE_MSG_DIG_SIG_MISMATCH,
	SW_UPDATE_ERROR_TEXT_TYPE_LIC_DIG_SIG_MISMATCH,
	SW_UPDATE_ERROR_TEXT_TYPE_FILES_NOT_AVAILABLE,
	SW_UPDATE_ERROR_TEXT_TYPE_NOT_AVAILABLE,
	SW_UPDATE_ERROR_TEXT_TYPE_COMPATIBLE_MISMATCH,
	SW_UPDATE_ERROR_TEXT_TYPE_CHANGE_BOOTMODE,
	SW_UPDATE_ERROR_TEXT_TYPE_SCRIPT_LOAD,
	SW_UPDATE_ERROR_TEXT_TYPE_SCRIPT_EXECUTE,
	SW_UPDATE_ERROR_TEXT_TYPE_UNKNOWN_ERROR,
	SW_UPDATE_ERROR_TEXT_TYPE_RETRY_RECOVERY,
	SW_UPDATE_ERROR_TEXT_TYPE_RETRY_ALL_RECOVERY
};
#endif

// Structure to store the error
struct structSwUpdateErrors
{
	int  iCount;
	int  iDevice;
	int  iErrorType;
	char acText1[SW_UPDATE_ERROR_TEXT1_SIZE + 1];
	char acText2[SW_UPDATE_ERROR_TEXT2_SIZE + 1];
};


#if 0
/*	Install Result codes from the core:
enum tenInstallResult {
	// Updated sucessfully
	tenInstallResult__OK = 0u,
	// The Checksum of the Tools-File was not correct
	tenInstallResult__ERR_TOOLS_CKSUM = 1u,
	// The Checksum of the Data-File was not correct
	tenInstallResult__ERR_DATA_CKSUM = 2u,
	// There is no file at the given Position for the Tools-File
	tenInstallResult__ERR_TOOLS_NOT_FOUND = 3u,
	// There is no file at the given Position for the Data-File
	tenInstallResult__ERR_DATA_NOT_FOUND = 4u,
	// Updating the device failed and no other error fitted.
	tenInstallResult__ERR_DEVICE_ERROR = 5u,
	// The download was stopped up on Request
	tenInstallResult__ABORD_ON_REQUEST = 6u,
	// Download is busy (another update is running)
	tenInstallResult__ERR_BUSY = 7u,
	// Error Reading data (not tools file or data file, these have seperate
	// error code)
	tenInstallResult__ERR_READ = 8u,
	// Not enogh memory to run the update
	tenInstallResult__ERR_NOT_ENOUGH_MEMORY = 9u,
	// Any other error, not mentioned here (means, that we should update this
	// list)
	tenInstallResult__ERR_UNKNOWN = 10u,
	// Image size of Checksum Data does not fit file size
	tenInstallResult__ERR_IMAGE_SIZE = 11u,
	// Tools size vorm Checksum Data does not fit file size
	tenInstallResult__ERR_TOOLS_SIZE = 12u,
	// Invalid Data in data file
	tenInstallResult__ERR_IMAGE_INVALID_SECTOR = 13u,
	// The given update data do not fit the available hardware
	tenInstallResult__ERR_IMAGE_INCOMPATIBLE_VERSION = 14u,
	// Could not read the data file
	tenInstallResult__ERR_IMAGE_READ = 15u,
	// Could not write the data (flashing failed)
	tenInstallResult__ERR_IMAGE_FLASHING = 16u,
	// The given module is not supported
	tenInstallResult__ERR_DEVICE_NOT_SUPPORTED = 17u,
	// The given module is not ready to be flashed
	tenInstallResult__ERR_DEVICE_NOT_READY = 18u,
	// Could not read the tools file
	tenInstallResult__ERR_TOOLS_READ = 19u

};
*/
/* not used, only for documentation:
enum dl_HMIErrorType
{
	//DL_ENUM_TYPE_HMI_SWL_ERROR_ERG_WRITE,					   // Indicates that the information could not be written in persistency
	//DL_ENUM_TYPE_HMI_SWL_ERROR_ERG_READ,					   // Indicates that the information could not be read from persistency
	//DL_ENUM_TYPE_HMI_SWL_ERROR_NOT_ENOUGH_MEMORY, 		   // Indicates that there is not enough memory to store the necessary information
	//DL_ENUM_TYPE_HMI_SWL_ERROR_INVALID_SOURCE_SET, 	       // Indicates that the source set by HMI is incorrect (e.g. source was removed)
	//DL_ENUM_TYPE_HMI_SWL_ERROR_IMAGE_CHECKSUM, 			   // Indicates that the checksum from metainfo differs from real one
	//DL_ENUM_TYPE_HMI_SWL_ERROR_IMAGE_INVALID_SECTORHEADER,   // Indicates that the image has an invalid header
	//DL_ENUM_TYPE_HMI_SWL_ERROR_IMAGE_READ,				   // Indicates that the image can not be read
	//DL_ENUM_TYPE_HMI_SWL_ERROR_IMAGE_FLASHING,			   // Indicates that a flashing-related error occurred
	//DL_ENUM_TYPE_HMI_SWL_ERROR_IMAGE_DEVICE_NOT_READY,	   // Indicates that the device for the image was not ready at the time of flashing
	//DL_ENUM_TYPE_HMI_SWL_ERROR_CHANGE_BOOTMODE_NOT_POSSIBLE, // Can not change the bootmode because the target image does not exists in flash (Bootchain umschaltung geht nicht oder V850 bleibt im BL mode stehen)
	//DL_ENUM_TYPE_HMI_SWL_ERROR_MEDIA_UNAVAILABLE,			   // Indicates that there is no media available
	//DL_ENUM_TYPE_HMI_SWL_ERROR_UNKNOWN,					   // Indicates that an unknown error occurred
	//DL_ENUM_TYPE_HMI_SWL_ERROR_ENTIRE_COUNTER
};
*/
#endif

// ----------------------------------------------------------------------------
// function prototypes
// ----------------------------------------------------------------------------

int iInitializeSwUpdateErrorArray(void);

int iSetSwUpdateError(int iUpdateDevice, int iUpdateError, const char* pcText1, const char* pcText2);
int iSetSwUpdateError(enum SwUpdateDevice iUpdateDevice, enum SwUpdateErrorType iUpdateError, const char* pcText1, const char* pcText2);

int iSetSwUpdateErrorString(const char* pcErrorDevice, const char* pcErrorType, const char* pcText1, const char* pcText2);

int iGetSwUpdateError (const char * acFileName);

int iGetSwUpdateCoreInstallResult (void);

struct structSwUpdateErrors *paGetSwUpdateErrorArray (const char * acFileName, int * piErrorCounter);

const char * pcGetSwUpdateErrorDeviceText (int iErrorDevice);

const char * pcGetSwUpdateErrorTypeText   (int iErrorType);

int iClearSwUpdateError(int iUpdateDevice, int iUpdateError);

int iTestErrorCodes (void); 

void vSwUpdateErrorSimulation (void);

bool bSwUpdateErrorSimulation (void);

void vWriteErrmem(const tChar *acBuf, tU32 u32Len);

void vWriteDownloadPipe(const tChar *acBuf, tU32 u32Len);

} // namespace ai_sw_update {
} // namespace common {

#endif //DL_ERROR_HANDLER_H
/***********************************************************************************************************************/
//EOF
