/**********************************************************************************************
* FILE:           dldab_defines.cpp
* PROJECT:        Nissan
* SW-COMPONENT:   Download
*-----------------------------------------------------------------------------------------------
* DESCRIPTION:  DAB Plus Firmware defines Class
*------------------------------------------------------------------------------------------------
* COPYRIGHT: (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:
* Date       |Author								  |Modification
* 22.02.11   |Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)  |Initial
*************************************************************************************************/

#ifndef _DL_DAB_DEFINES_H
#define _DL_DAB_DEFINES_H

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------
#define DL_INC_HELP
#define DL_INC_ADDRESS 
#define DL_INC_TYPES 
#define DL_INC_TRACE
#define DL_INC_COPY 
#define DL_INC_SRC_IF 
#define DL_INC_SEQ 
#define DL_INC_STATE 
#define DL_INC_APP
#define DL_INC_SRC_DVD


#define MAX_DAB_DATABYTES_TOWRITE	512			//Bytes to be read from the Buffer and to WRITE to ADR
#define MAX_DAB_DATABYTES_TOBEREAD	512			//Bytes to be read from ADR
#define MAX_DAB_DATAFRAME_CMD_SIZE	524			//Data Command Size

#define	DAB_READ_RESPONSE_BUFFER_SIZE	(MAX_DAB_DATABYTES_TOBEREAD+4)	//Buffer Size to Read all cmds rsp

#define TROJAN_CRC_2007_POLYNOM		0xedb88320	//polynom for CRC generation
#define CRC32_2007_DEFAULT			(~0x00000000)

#define ERASE_CMD_BUFFER_SIZE		12	//Erase Cmd Size
#define	DAB_SEC_ERASE_CMD			0x29//Erase Command Event
#define	DAB_ERASE_SUCCESS			0x21
#define	DAB_ERASE_ERROR				0x20

#define	DAB_WRITE_CMD				0x38
#define	DAB_WRITE_SUCCESS			0x31
#define	DAB_WRITE_DATA_ERROR		0x30

#define READ_CMD_BUFFER_SIZE		12	
#define	DAB_READ_CMD				0x48
#define	DAB_READ_SUCCESS			0x41
#define	DAB_READ_CMD_ERROR			0x40

#define CHECKSUM_CMD_BUFFER_SIZE	13
#define	DAB_CRC_2007_MODE			0x01
#define	DAB_CRC_CALC_CMD			0x58
#define	DAB_CRC_CALC_ERROR			0x52
#define	DAB_CRC_CALC_SUCCESS		0x51	
#define	DAB_CRC_CALC_NOT_SUPORTED	0x50

#define DAB_ABORTED_BY_BREAK		0xaa
#define DAB_NO_XLOADER_RESPONSE		0xab
#define DAB_RESPONSE_TIMEOUT        0xac

#define	DAB_UNKNOWN_MSG_ID_ERROR	0xff		


#endif // _DL_DAB_DEFINES_H


