/**********************************************************************************************
* FILE:           dldab_ProcessCmd.h
* PROJECT:        Nissan
* SW-COMPONENT:   Download
*----------------------------------------------------------------------------------------------
* DESCRIPTION:  Class to process download commands
* In this file class dldab_tclProcessDnlCmd is declared. This class spawns two more classes 
* one for creating the message frames and other for processing the responses.
*----------------------------------------------------------------------------------------------
* COPYRIGHT: (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:
* Date       |Author								  |Modification
* 23.02.11   |Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)  |Initial
**********************************************************************************************/

#ifndef  _DLDAB_PROCESS_CMD_H
#define  _DLDAB_PROCESS_CMD_H

//----------------------------------------------------------------------------------------
// includes
//----------------------------------------------------------------------------------------
#include "dldab_includes.h"
#include "dldab_defines.h"


#include "FSM/dldab_DnlFsmActions.h"

#define DL_ADR3_ERASE_ERROR                         0x81
#define DL_ADR3_WRITE_DATA_ERROR                    0x82
#define DL_ADR3_READ_CMD_ERROR                      0x83
#define DL_ADR3_CRC_CALC_ERROR                      0x84
#define DL_ADR3_CRC_CALC_NOT_SUPORTED               0x85
#define DL_ADR3_ABORTED_BY_BREAK                    0x86
#define DL_ADR3_UNKNOWN_MSG_ID_ERROR                0x87
#define DL_ADR3_UNKNOWN_ERROR                       0x88
#define DL_ADR3_NO_XLOADER_RESPONSE                 0x89
#define DL_ADR3_RESPONSE_TIMEOUT                    0x8A

//----------------------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------------------
class dldab_DnlFsmActions;

//----------------------------------------------------------------------------------------
// class definition
//----------------------------------------------------------------------------------------
class dldab_tclProcessCmd 
{
    SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dldab_tclProcessCmd);

	public:  

		virtual tVoid vSetProgressOfAction(tU32 u32Progress);
		static tU32 u32GetProgressOfAction();

		//Function to break the download
		virtual tVoid vBreakADR3Download();

		//Function to upload xloader		
		virtual tBool WriteXLoaderCmd(tPU8 pu8RamBuffer, tU32 u32SizeOfFile);

		//Function to start the Chip Initialization
		virtual tBool bHandleInitilization();

		//Function to start the Chip Erase (starts with a READ to see if xloader is running)
		virtual tBool bHandleErase(tPU8 pu8RamBuffer, tU32 u32SizeOfFlashFile);

		//Function to start the read function
		virtual tBool bHandleRead(tPU8 pu8RamBuffer, tU32 u32SizeOfFile);

		//Function to read the adr3 version
		virtual tBool bHandleReadVersion(tPU8 pu8RamBuffer, tU32 u32AddressOfVersion, tU32 u32SizeOfVersion);

		//Function to transfer the Data to Flash
		virtual tBool bHandleDataTransfer(tPU8 pu8RamBuffer, tU32 u32SizeOfFile);

		virtual tU32 u32ComputeBufCRC2007(tPU8 data_buf, tU32 num_bytes) ;
		
		// Checks the reason for the error	
		virtual tVoid SetErrorInfo();
		static 	tU8	u8GetLastError();

		virtual tVoid vResetADR3();

		tPU8	pDataBuffer;

		tS32	s32FileSize;

		tU32    u32VersionAddr;

		tU32	u32VersionSize;

		tU32	u32FileChecksum;	//Stores the File checksum 

	protected:	

		dldab_tclProcessCmd();

		~dldab_tclProcessCmd(); 
		
		static dldab_tclProcessCmd* m_poInstance;		

		dldab_DnlFsmActions* m_poDnlFsmActions;

		tU32 CRC_ulwGetCRC32( tU8 ubData,  tU32 ulwPrevCRC) const;		

	private:

		static tU32 u32LastReportedProgress;
		static tU8 u8LastError;
		
};

SWU_DECL_GET_AND_RELEASE_INSTANCE(dldab_tclProcessCmd);

#endif //_DLDAB_PROCESS_CMD_H

//EOF

