//----------------------------------------------------------------------------------------
// includes
//----------------------------------------------------------------------------------------

#include <stdio.h>
#include "dl_tclHelp.h"

#define OSAL_S_IMPORT_INTERFACE_ANSI
#include "osal_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
/* Needed for Trace */
#define ETG_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etg_if.h"
#endif


/* Needed for ETG trace */
#include "dl_Adr3TraceMacros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_ADR3
#include "trcGenProj/Header/dl_tclHelp.cpp.trc.h"
#endif


//----------------------------------------------------------------------------------------
// defines
//----------------------------------------------------------------------------------------

#define TRACE_FILE "/var/opt/bosch/persistent/swupdate/update_adr.log"


void dl_tclHelp::vStartTrace(void)
{
	FILE * fdTraceFile = NULL;
	
	if ((fdTraceFile = fopen (TRACE_FILE, "w")) == NULL)
	{
		ETG_TRACE_FATAL (("Tracefile %s could not be created", TRACE_FILE));
		NORMAL_M_ASSERT_ALWAYS ();
		return;
	}
	fclose(fdTraceFile);
}


void dl_tclHelp::vStopTrace(void)
{
	// Currently nothing to do here
}


void dl_tclHelp::vTrace(const char * traceString)
{
	FILE * fdTraceFile = NULL;
	
	if ((fdTraceFile = fopen (TRACE_FILE, "a")) == NULL)
	{
		ETG_TRACE_FATAL (("Tracefile %s could not be opened", TRACE_FILE));
		NORMAL_M_ASSERT_ALWAYS ();
		return;
	}
	fprintf(fdTraceFile, "%s\n", traceString);

	fclose(fdTraceFile);
}

