/************************************************************************
* FILE:			tclSpiIF.h
* PROJECT:      Nissan
* SW-COMPONENT: Download
*-------------------------------------------------------------------------
*
* DESCRIPTION: tclADR3Driver class for the ADR3 communication
*              
*-------------------------------------------------------------------------
* AUTHOR:		Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)
* COPYRIGHT:    (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:      Rev 1.0 
*				Initial version
**************************************************************************/

#ifndef _tclSpiIF_h_
#define _tclSpiIF_h_

#include "../Generic/tclSemaphore.h"

class tclSpiIF 
{
public:

    virtual tBool bOpen()=0;
   
    virtual tBool bClose()=0;

    virtual tS32 s32Read(tPS8 pBuffer, tU32 u32Count)=0;

    virtual tS32 s32Write(tPCS8 pBuffer, tU32 u32Count)=0;
    
	virtual tBool bSetReadTimeout()=0;

    virtual tBool bReset()=0;

protected:   
   tclSpiIF() {}

   virtual ~tclSpiIF(){}
};


#endif //_tclSpiIF_h_

//EOF

























