/*************************************************************************************
* FILE:			tclSpiADR3.cpp
* PROJECT:      Nissan
* SW-COMPONENT: Download
*--------------------------------------------------------------------------------------
*
* DESCRIPTION: tclADR3Driver class for the ADR3 SPI communication
*              
*--------------------------------------------------------------------------------------
* AUTHOR:		Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)
* COPYRIGHT:    (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:      Rev 1.0 
*				Initial version
***************************************************************************************/
//--------------------------------------------------------------------------------------
// includes
//--------------------------------------------------------------------------------------
#include "../dldab_includes.h"
#include "tclSpiADR3.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
/* Needed for Trace */
#define ETG_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etg_if.h"
#endif

/* Needed for ETG trace */
#ifdef DL_ADR3_GEN2_CORE
#include "../dl_Adr3TraceMacros.h"
#else
#include "ai_sw_update/common/base/imp/swupd_trace.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_ADR3
#include "trcGenProj/Header/tclSpiADR3.cpp.trc.h"
#endif


/*******************************************************************************************/

#ifndef __SW_UPDATE_UNIT_TESTING__
// Implementation of the methods getInstanceOftclSpiADR3 and releaseInstanceOftclSpiADR3
// In case of __SW_UPDATE_UNIT_TESTING__ they are implemented in mock!
SWU_IMPL_GET_AND_RELEASE_INSTANCE(tclSpiADR3);
#endif

// Implementation of the singleton methods
SWU_IMPL_SINGLETON(tclSpiADR3);

/*******************************************************************************************/


/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::bOpen()
* 
* DESCRIPTION:  Opens the SPI port and increments _OpenCount if port is opened 
*
* PARAMETER:	None
*
* RETURN VALUE: TRUE = No error, False = Error
*
******************************************************************************************/
tBool tclSpiADR3::bOpen()
{
   dl_semaphore_protection on(sem);
   
   ETG_TRACE_USR4(("tclSpiADR3::bOpen"));
   
    tBool bRet = (OpenCount>0) || SpiWrapper.bOpen();
   
    if(bRet==TRUE)//Only after Port is opened
    {
        OpenCount++;//Ensures that port is opened only once
	}
   return bRet;
}

/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::bClose()
* 
* DESCRIPTION:  Cloases the SPI port and decrements _OpenCount
*
* PARAMETER:	None
*
* RETURN VALUE: TRUE = No error, False = Error
*
******************************************************************************************/
tBool tclSpiADR3::bClose()
{
   dl_semaphore_protection on(sem);
   tBool bRet = FALSE;
   if(OpenCount == 1)
   {
      bRet = SpiWrapper.bClose();
   }
   if(OpenCount > 0)OpenCount--;
   return bRet;
}

/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::s32Read()
* 
* DESCRIPTION:  Reads the No of Bytes requested
*
* PARAMETER:	data - > Buffer Ptr , size - no of Bytes
*
* RETURN VALUE: No of Bytes Rd in case of success ,In case of Error Returns OSAL_ERROR(-1)
*
******************************************************************************************/
tS32 tclSpiADR3::s32Read(tPS8 pBuffer, tU32 u32Count)
{
   tS32 s32BytesRead = 0;
   if(OpenCount && pBuffer)
   {
      if(u32Count>0)
      {
         s32BytesRead = SpiWrapper.s32Read(pBuffer,u32Count);
      }
   }
   else 
   {
      NORMAL_M_ASSERT(OpenCount); 
      NORMAL_M_ASSERT(pBuffer); 
   }
   return s32BytesRead;
}

/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::s32Write()
* 
* DESCRIPTION:  Writes the Buffer Data send 
*
* PARAMETER:	data - > Buffer Ptr , size - no of Bytes
*
* RETURN VALUE: No of Bytes wrote in case of success ,In case of Error Returns OSAL_ERROR(-1)
*
******************************************************************************************/
tS32 tclSpiADR3::s32Write(tPCS8 pBuffer, tU32 u32Count)
{
   tS32 BytesWritten = 0;
   if(OpenCount && pBuffer)
   {
      if(u32Count>0)
      {
         BytesWritten = SpiWrapper.s32Write(pBuffer,u32Count);
      }
   }
   else 
   {
      NORMAL_M_ASSERT(OpenCount); 
      NORMAL_M_ASSERT(pBuffer); 
   }

   return BytesWritten;
}

const char* tclSpiADR3::name() const
{
   return "tclSpiADR3";
}

/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::bSetReadTimeout()
* 
* DESCRIPTION:  Time till which rsp is polled
*
* PARAMETER:	None
*
* RETURN VALUE: TRUE = No error, False = Error
*
******************************************************************************************/
tBool tclSpiADR3::bSetReadTimeout()
{
   return SpiWrapper.bSetReadTimeout();
}
/******************************************************************************************
*
* FUNCTION:		tclSpiADR3::bSetReadTimeout()
* 
* DESCRIPTION:  Resets the Chip , invoked upon Error
*
* PARAMETER:	None
*
* RETURN VALUE: TRUE = No error, False = Error
*
******************************************************************************************/
tBool tclSpiADR3::bReset()
{
   return SpiWrapper.bReset();
}


//EOF



