/**********************************************************************************************
* FILE:           dldab_DnlFsmActions.h
* PROJECT:        Nissan
* SW-COMPONENT:   Download
*----------------------------------------------------------------------------------------------
* DESCRIPTION:  
*    Declares all the actions to be implemented in State Machine
*----------------------------------------------------------------------------------------------
* COPYRIGHT: (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:
* Date       |Author								  |Modification
* 23.02.11   |Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)  |Initial
**********************************************************************************************/

#ifndef  _DLDAB_DNL_FSM_ACTIONS_H
#define  _DLDAB_DNL_FSM_ACTIONS_H

//----------------------------------------------------------------------------------------
// includes
//----------------------------------------------------------------------------------------
#include "../dldab_includes.h"
#include "../dldab_defines.h"

#include "../SPI/tclSpiADR3.h"
#include "DABPlusDNLFsm.h"
#include "../dldab_ProcessCmd.h"

//----------------------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------------------
class tclSpiADR3;
class dldab_tclProcessCmd;

class dldab_DnlFsmActions : public DABPlusDNLFsm::FsmBehaviour
{
    SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dldab_DnlFsmActions);

public:
	/////////////////
    // FSM actions //
    /////////////////
    // Function  to open SPI Port
    virtual void OpenPort ( void* pArg );
    // Function  to Read the command acknowledgement
    virtual void ReadAck ( void* pArg );
    // Function  to verify the binary data to be flashed
    virtual void VerifyData ( void* pArg );
    // Function  to Create Message commands
    virtual void CreateMsgFrame ( void* pArg );
    // Function  to Create Read command
    virtual void CreateReadCmd ( void* pArg );
    // Function  to Create ReadFlash command
    virtual void CreateReadFlashCmd ( void* pArg );
    // Function  to Create ReadVersion command
    virtual void CreateReadVersionCmd ( void* pArg );
    // Function  to Report Error to the upper layers
    virtual void ErrorReport ( void* pArg );
    // Function  to Send Commands to the ADR3 Chip
    virtual void SendMsg ( void* pArg );
    // Function  to verify response 
    virtual void VerifyRsp ( void* pArg );
    // Function  to Handle error when invalid response obtained
    virtual void HandleError ( void* pArg );
	// Function  to create Data Message Frames each 512 bytes
    virtual void CreateDataMsgFrames ( void* pArg );
    // Function  to Create Checksum Commands
    virtual void CreateChecksumCmd ( void* pArg );
    // Function  to Notify Download finished in the normal mode    
    virtual void NotifyDNLFinished ( void* pArg );
    
    //////////////////
    //  FSM Guards  //
    //////////////////
    
    // Will be set once SPI Port is opened
    virtual bool PortOpened ( void* pArg );
    // Will be set once SPI Mode is activated
    virtual bool SPIMode ( void* pArg );
    // Will be set once data file is verified
    virtual bool VerificationSucess ( void* pArg );
    // Will be set if xloader was dnl succesfully
    virtual bool xloaderDnlSuccess ( void* pArg );
    // Will be set if xloader Response was Read
    virtual bool xloaderRspSuccess ( void* pArg );
    // Will be set valid response is received
    virtual bool ValidRsp ( void* pArg );
    // Will be set once response is received for the command set
    virtual bool AckReceived ( void* pArg );
    // Will be set if invalid response is received
    virtual bool ErrorResponse ( void* pArg );
    // Will be set if the Erase command was set successfully
    virtual bool EraseSuccess ( void* pArg );
    // Will be set after Data is being sent
    virtual bool DataSent ( void* pArg );
    // Will be set after the Dnl is finished
    virtual bool DnlFinished ( void* pArg );
    
protected:
     tVoid vInit ( tVoid );  
     tclSpiADR3* m_poSpiADR3;
     tBool bSendFBUSPacket(tU16);     
     tU8   u8CheckSumModCalc(const tU8  *pcu8Buffer, tU16 u16Len) const;
     DABPlusDNLFsm::Fsm* mpFSM; // pointer to the FSM object
     
private:
	dldab_DnlFsmActions* m_poDnlFsmActions;
	dldab_tclProcessCmd* m_poProcessCmd;	
	dldab_DnlFsmActions ( const dldab_DnlFsmActions & ); //coverity fix for 48230
	dldab_DnlFsmActions& operator = ( const dldab_DnlFsmActions & ); //coverity fix for 47827

	bool	bSPIMode;			// Set when the SPI mode is activated
	bool	bVerificationSucess;// Checks whether the Verification is success
	bool	bWriteRes;			//Set once the Write is successfull
	bool	bSendChecksumCmd;    
    bool	bSendDataCmd;
    bool	bValidRspCheck;    
    bool	bErrorReceived;
	bool	bxloaderRdRspSuccess;
	
    tS32	s32FileSize;     	
	tPU8	pDataBuffer;//xloader buffer
	tU16	u16CmdLength;	
	tU32	u32FrameNumber;	
	tU32	u32StartAddress;	
	tU8     u8MessageStatus;
	tU8		u8NumberOfRetries;
	tU8		u8NumberOfReceivedErrors;
	tU32	u32MsgFrameSize;
	tU32	u32NoOfBytesRead;
	tU32	m_dwCurrentAddress;	//Stores the current address written
	tBool	bxLoaderFrm;
	tBool	bNextFrameToBeSent;	    
    tBool	bReadCmdSent;    
	tBool	bLastFrameSent;

    tS8 s8ReadCmdBuffer[READ_CMD_BUFFER_SIZE];
    tS8 s8DataCmdBuffer[MAX_DAB_DATAFRAME_CMD_SIZE];
    tS8 s8ChecksumCmdBuffer[CHECKSUM_CMD_BUFFER_SIZE];
    tS8 s8EraseCmdBuffer[ERASE_CMD_BUFFER_SIZE];
    tU8 u8ResponseBuffer[DAB_READ_RESPONSE_BUFFER_SIZE];
    
    
public: 

	dldab_DnlFsmActions();	
	virtual ~dldab_DnlFsmActions(tVoid);	
	
	tU8		u8errorCode;		// Stores the Error occured
	bool	bxLoaderDnlSuccess; 
	bool	bSecEraseSuccess;	
	bool	bChecksumCalcDone;
	bool	bReadFlashSuccess;
	bool	bPortOpened;		// To check whether port is opened
	
	//Stores the reference for dldab_tclProcessCmd class
	virtual tVoid vStoreReference(dldab_tclProcessCmd*  poProcessCmd);
	virtual tVoid vAcceptEvent ( DABPlusDNLFsm::FsmEvent event, tVoid* pArg );

	virtual tVoid vResetADR3 ();

	static tVoid vInsertOneWrongByte();  // TTFIS ETG_I
	static bool	bInsertOneWrongByte;     // TTFIS ETG_I Used for testing failures
	static tVoid vBreakADR3Download();   // static function to set break flag before object is available!
	static bool	bBreakDownload;          // static flag to break the download
	static tVoid vXloaderError();        // TTFIS ETG_I
	static bool	bXloaderError;           // TTFIS ETG_I Used for testing xloader error

};

SWU_DECL_GET_AND_RELEASE_INSTANCE(dldab_DnlFsmActions);

#endif //_DLDAB_DNL_FSM_ACTIONS_H






