///////////////////////////////////////////////////////////////////////////////
//
// File: DABPlusDNLFsm.h
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DABPLUSDNLFSM__
#define __INCLUDED_DABPLUSDNLFSM__

namespace DABPlusDNLFsm
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evChecksum,
   evDataTnfrCmd,
   evDownload,
   evErase,
   evError,
   evFailure,
   evNormalMode,
   evRead,
   evReadFlash,
   evReadVersion,
   evSend,
   evSuccess,
   evVerified,
   evVerify,
   evxLdrRead,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
public:
   virtual ~FsmBehaviour ( void ) {}

   // FSM actions
   virtual void CreateChecksumCmd ( void* pArg ) = 0;
   virtual void CreateDataMsgFrames ( void* pArg ) = 0;
   virtual void CreateMsgFrame ( void* pArg ) = 0;
   virtual void CreateReadCmd ( void* pArg ) = 0;
   virtual void CreateReadFlashCmd ( void* pArg ) = 0;
   virtual void CreateReadVersionCmd ( void* pArg ) = 0;
   virtual void ErrorReport ( void* pArg ) = 0;
   virtual void HandleError ( void* pArg ) = 0;
   virtual void NotifyDNLFinished ( void* pArg ) = 0;
   virtual void OpenPort ( void* pArg ) = 0;
   virtual void ReadAck ( void* pArg ) = 0;
   virtual void SendMsg ( void* pArg ) = 0;
   virtual void VerifyData ( void* pArg ) = 0;
   virtual void VerifyRsp ( void* pArg ) = 0;

   // FSM guards
   virtual bool AckReceived ( void* pArg ) = 0;
   virtual bool DataSent ( void* pArg ) = 0;
   virtual bool DnlFinished ( void* pArg ) = 0;
   virtual bool EraseSuccess ( void* pArg ) = 0;
   virtual bool ErrorResponse ( void* pArg ) = 0;
   virtual bool PortOpened ( void* pArg ) = 0;
   virtual bool SPIMode ( void* pArg ) = 0;
   virtual bool ValidRsp ( void* pArg ) = 0;
   virtual bool VerificationSucess ( void* pArg ) = 0;
   virtual bool xloaderDnlSuccess ( void* pArg ) = 0;
   virtual bool xloaderRspSuccess ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'DABPlusDNLFsm'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    virtual void init ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
