/*!
*******************************************************************************
* \file              SPIDatabaseSQLite3.h
* \brief             Wrapper Class for sqlite3
*******************************************************************************
\verbatim
PROJECT:         Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Database in SPI.
The Database library used here is sqlite3.

COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                            | Modifications
Sep 15 2018|  Ram Chaithanya S A(RBEI/ECO2)     | Initial Version

\endverbatim
******************************************************************************/


/******************************************************************************
| includes:
| 
|----------------------------------------------------------------------------*/
#include <stdarg.h>
#include "SPIDatabaseSQLite3.h"
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/SPIDatabaseSQLite3.cpp.trc.h"
#endif
#endif

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/
#if !(defined(_LINUXX86MAKE_) || defined(_LINUXX86_64_))
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPIDatabaseSQLite3()
***************************************************************************/

SPIDatabaseSQLite3::SPIDatabaseSQLite3():m_SQLitedb(NULL),m_poStatement(NULL)
{
	ETG_TRACE_USR1(("SPIDatabaseSQLite3::SPIDatabaseSQLite3 "));
}

/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::~SPIDatabaseSQLite3()
***************************************************************************/
SPIDatabaseSQLite3::~SPIDatabaseSQLite3()
{
	ETG_TRACE_USR1(("SPIDatabaseSQLite3::~SPIDatabaseSQLite3 "));
    this->m_poStatement = NULL;
    this->SPI_DB_close();
	this->m_SQLitedb = NULL;
}

/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::bInitialize()
***************************************************************************/
t_Bool SPIDatabaseSQLite3::bInitialize()
{
  t_Bool bRet = true;
  this->m_SQLitedb = NULL;
  this->m_poStatement = NULL;
  return bRet;
}

/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::bUnInitialize()
***************************************************************************/
t_Bool SPIDatabaseSQLite3::bUnInitialize()
{
 t_Bool bRet = true;
 this->m_poStatement = NULL;
 this->SPI_DB_close(); 
 this->m_SQLitedb = NULL;
 return bRet;
}

/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_open()
***************************************************************************/   
t_S32 SPIDatabaseSQLite3::SPI_DB_open(const t_String &DatabasePath)
{
    return sqlite3_open(DatabasePath.c_str(), &m_SQLitedb);   

}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_exec()
***************************************************************************/
t_U32 SPIDatabaseSQLite3::SPI_DB_exec(t_String szQuery,char *ErrorMsg)
{
    return sqlite3_exec(this->m_SQLitedb,                   //Database
                     szQuery.c_str(),                       // Requested query
                     NULL,                                  // Callback function
                     NULL,                                  //  1st argument to callback (NOT USED)
                     &ErrorMsg);                            // Error message pointer
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_free()
***************************************************************************/
void SPIDatabaseSQLite3::SPI_DB_free(t_Char *SQLString)
{
    sqlite3_free(SQLString);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_mprintf()
***************************************************************************/
t_Char * SPIDatabaseSQLite3::SPI_DB_mprintf(const char* SQLString,...)
{
	t_Char* c_rv = NULL;
	if(NULL != SQLString)
	{
        va_list argList;
        va_start(argList,SQLString);
        c_rv = sqlite3_vmprintf(SQLString,argList);
        va_end(argList);
	}
    return c_rv;    
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_errmsg()
***************************************************************************/
t_String SPIDatabaseSQLite3::SPI_DB_errmsg()
{
    return sqlite3_errmsg(this->m_SQLitedb);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_close()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_close()
{
    return sqlite3_close(this->m_SQLitedb);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_prepare_v2()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_prepare_v2(const char* Query,int nbyte)
{
    this->m_poStatement = NULL;
    return sqlite3_prepare_v2(this->m_SQLitedb,
              Query,
              nbyte,
              &m_poStatement,
              NULL);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_step()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_step()
{
    return sqlite3_step(this->m_poStatement);     
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_column_int()
***************************************************************************/
t_U32 SPIDatabaseSQLite3::SPI_DB_column_int(int icol)
{
    return sqlite3_column_int(this->m_poStatement, icol);    
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_finalize()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_finalize()
{
    return sqlite3_finalize(this->m_poStatement);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_bind_int()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 U32Key)
{
    return sqlite3_bind_int(this->m_poStatement,scou8FirstParameter,U32Key);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_bind_blob()
***************************************************************************/
int SPIDatabaseSQLite3::SPI_DB_bind_blob(int n,const void* info,int count)
{
    return sqlite3_bind_blob (this->m_poStatement,
                                   n, 
                                   &info,
                                   count,
                                   SQLITE_TRANSIENT);
}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_column_text()
***************************************************************************/
const unsigned char* SPIDatabaseSQLite3::SPI_DB_column_text(t_U8 icol)
{

    return sqlite3_column_text(this->m_poStatement, icol); 

}
/***************************************************************************
** FUNCTION: SPIDatabaseSQLite3::SPI_DB_column_blob()
***************************************************************************/
const void* SPIDatabaseSQLite3::SPI_DB_column_blob(int icol)
{
    return sqlite3_column_blob(this->m_poStatement, icol);
}

#endif // ifdef _LINUXX86MAKE_
