/*!
*******************************************************************************
* \file              SPIDatabaseMngr.h
* \brief             Abstract Class for the DatabaseMngrIntf
*******************************************************************************
\verbatim
PROJECT:         Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Database in SPI.
The Database library used here is sqlite3.

COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                            | Modifications
Sep 15 2018|  Ram Chaithanya S A(RBEI/ECO2)     | Initial Version

\endverbatim
******************************************************************************/

#ifndef SPIDATABASEMNGRINTF_H_
#define SPIDATABASEMNGRINTF_H_

/******************************************************************************
| includes:
| 
|----------------------------------------------------------------------------*/

#include "BaseTypes.h"

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

class SPIDatabaseMngrIntf
{


  
public:

   /***************************************************************************
   ** FUNCTION: ~SPIDatabaseMngrIntf()
   ***************************************************************************/
   /*!
   * \fn      ~SPIDatabaseMngrIntf()
   * \brief   Destructor
   * \sa      SPIDatabaseMngrIntf()
   ***************************************************************************/   

   virtual ~SPIDatabaseMngrIntf(){}


   /***************************************************************************
    ** FUNCTION: bInitialize() = 0;
    ***************************************************************************/
   /*!
    * \fn      bInitialize() = 0;
    * \brief   Wrapper Pure Virual Member function for initializing sqlite3
    **************************************************************************/
  
    virtual t_Bool bInitialize() = 0;
 
   /***************************************************************************
    ** FUNCTION: bUnInitialize() = 0;
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize() = 0;
    * \brief   Wrapper Pure Virual Member function for Uninitializing sqlite3
    **************************************************************************/

    virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_open(const t_String &DatabasePath) = 0;
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_open(const t_String &DatabasePath) = 0;
    * \brief   Wrapper Pure Virual Member function for sqlite3_open
    **************************************************************************/

   virtual t_S32    SPI_DB_open(const t_String &DatabasePath) = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_exec(t_String szQuery, char *ErrorMsg)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_exec(t_String szQuery, char *ErrorMsg)
    * \brief   Wrapper Pure Virual Member function for sqlite3_exec
    **************************************************************************/

   virtual t_U32    SPI_DB_exec(t_String szQuery, char *ErrorMsg) = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_free(t_Char *SQLString)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_free(t_Char *SQLString)
    * \brief   Wrapper Pure Virual Member function for sqlite3_free
    **************************************************************************/

   virtual void     SPI_DB_free(t_Char *SQLString) = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_mprintf(const t_String &SQLString)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_mprintf(const t_String &SQLString)
    * \brief   Wrapper Pure Virual Member function for sqlite3_free
    **************************************************************************/
   
    virtual t_Char*  SPI_DB_mprintf(const char* SQLString,...) = 0;
  
   /***************************************************************************
    ** FUNCTION: SPI_DB_errmsg()
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_errmsg()
    * \brief   Wrapper Pure Virual Member function for sqlite3_errmsg
    **************************************************************************/

   virtual t_String SPI_DB_errmsg() = 0;
   
   /***************************************************************************
    ** FUNCTION: SPI_DB_close()
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_close()
    * \brief    Wrapper Pure Virual Member function for sqlite3_close
    **************************************************************************/

   virtual int SPI_DB_close() = 0;

   /***************************************************************************
    ** FUNCTION:  SPI_DB_prepare_v2(const char* Query,int nbyte)
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_prepare_v2(const char* Query,int nbyte)
    * \brief    Wrapper Pure Virual Member function for sqlite3_prepare_v2
    **************************************************************************/

   virtual int SPI_DB_prepare_v2(const char* Query,int nbyte) = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_step() 
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_step()
    * \brief   Wrapper Pure Virual Member function for sqlite3_step
    **************************************************************************/

   virtual int SPI_DB_step() = 0;
  
   /***************************************************************************
    ** FUNCTION:  SPI_DB_column_int(int icol)
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_column_int(int icol)
    * \brief   Wrapper Pure Virual Member function for sqlite3_column_int
    **************************************************************************/

   virtual t_U32 SPI_DB_column_int(int icol) = 0;

   /***************************************************************************
    ** FUNCTION:  SPI_DB_finalize()
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_finalize()
    * \brief   Wrapper Pure Virual Member function for sqlite3_finalize
    **************************************************************************/

   virtual int SPI_DB_finalize() = 0;
  
   /***************************************************************************
    ** FUNCTION: SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key) 
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key) 
    * \brief   Wrapper Pure Virual Member function for sqlite3_bind_int
    **************************************************************************/

   virtual int SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key) = 0;
 
   /***************************************************************************
    ** FUNCTION:  SPI_DB_bind_blob(int n,const void* info,int count)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_bind_blob(int n,const void* info,int count)  
    * \brief   Wrapper Pure Virual Member function for sqlite3_bind_blob
    **************************************************************************/

   virtual int SPI_DB_bind_blob(int n,const void* info,int count) = 0;

   /***************************************************************************
    ** FUNCTION: SPI_DB_column_text(t_U8 icol)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_column_text(t_U8 icol)
    * \brief   Wrapper Pure Virual Member function for sqlite3_column_text
    **************************************************************************/

   virtual const unsigned char*  SPI_DB_column_text(t_U8 icol) = 0;
 
   /***************************************************************************
    ** FUNCTION:  SPI_DB_column_blob(int icol)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_column_blob(int icol)
    * \brief   Wrapper Pure Virual Member function for sqlite3_column_blob
    **************************************************************************/

   virtual const void*  SPI_DB_column_blob(int icol) = 0;
};

#endif // SPIDATABASEMNGRINTF_H_
